/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.model.GCameraSpinner;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GSolid;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GCamera
implements Cloneable {
    private Matrix3d attitude;
    private Matrix3d initialAttitude = new Matrix3d();
    private GCameraSpinner spinner;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GCamera() {
        this.initialAttitude.set(GCamera.defaultAttitude());
        this.attitude = new Matrix3d();
        this.attitude.set(this.initialAttitude);
    }

    public GCamera clone() {
        GCamera camera = new GCamera();
        camera.initialAttitude = new Matrix3d(this.initialAttitude);
        camera.attitude = new Matrix3d(this.attitude);
        return camera;
    }

    public void make(Element node) throws Exception {
        logger.info((Object)"");
        this.makeAttitude(node);
    }

    private void makeAttitude(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("attitude");
        if (ns.getLength() == 0) {
            return;
        }
        this.attitude = new Matrix3d();
        String[] tokens = ns.item(0).getTextContent().split(" ");
        int index = 0;
        Quat4d quat = new Quat4d(Double.valueOf(tokens[index++]).doubleValue(), Double.valueOf(tokens[index++]).doubleValue(), Double.valueOf(tokens[index++]).doubleValue(), Double.valueOf(tokens[index]).doubleValue());
        this.initialAttitude = new Matrix3d();
        this.initialAttitude.set(quat);
        this.attitude = new Matrix3d();
        this.attitude.set(this.initialAttitude);
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<camera>");
        Quat4d quat = new Quat4d();
        quat.set(this.attitude);
        buf.append("\n<attitude>");
        buf.append(String.valueOf(quat.x));
        buf.append(' ');
        buf.append(String.valueOf(quat.y));
        buf.append(' ');
        buf.append(String.valueOf(quat.z));
        buf.append(' ');
        buf.append(String.valueOf(quat.w));
        buf.append("</attitude>");
        buf.append("\n</camera>");
    }

    public void turn(Vector3d axis, int stroke, GFigure figure) {
        double angle = (double)stroke * 0.007;
        AxisAngle4d axisAngle = new AxisAngle4d(axis, angle);
        Matrix3d rotMatrix = new Matrix3d();
        rotMatrix.set(axisAngle);
        rotMatrix.mulNormalize(this.attitude);
        this.attitude.set(rotMatrix);
        figure.cameraTurned();
    }

    public void spin(Vector3d axis, int stroke, int delay, GFigure fig) {
        this.spinner = new GCameraSpinner(this, axis, stroke, delay, fig);
        new Thread(this.spinner).start();
    }

    public void seize() {
        if (this.spinner != null) {
            this.spinner.seize();
        }
    }

    public boolean visible(GFace face, GSolid solid, Point3d refPoint) {
        Vector3d on = new Vector3d(face.getNormal(solid, refPoint));
        this.attitude.transform((Tuple3d)on);
        return on.z > 0.0;
    }

    public static Matrix3d defaultAttitude() {
        AxisAngle4d axisAngle1 = new AxisAngle4d(1.0, 1.0, 1.0, -2.0943951023931953);
        Matrix3d m1 = new Matrix3d();
        m1.set(axisAngle1);
        AxisAngle4d axisAngle2 = new AxisAngle4d(0.0, 1.0, 0.0, 0.4487989505128276);
        Matrix3d m2 = new Matrix3d();
        m2.set(axisAngle2);
        AxisAngle4d axisAngle3 = new AxisAngle4d(1.0, 0.0, 0.0, 0.20943951023931953);
        Matrix3d m3 = new Matrix3d();
        m3.set(axisAngle3);
        m2.mul(m1);
        m3.mul(m2);
        return m3;
    }

    public Matrix3d getAttitude() {
        return this.attitude;
    }

    public Matrix3d getInitialAttitude() {
        return this.initialAttitude;
    }

    public void setInitialAttitude(Matrix3d initialAttitude) {
        this.initialAttitude = initialAttitude;
    }

    public void setAttitude(Matrix3d attitude) {
        this.attitude = attitude;
    }

    public void toInitialAttitude() {
        this.attitude.set(this.initialAttitude);
    }

    public void toDefaultAttitude() {
        this.attitude.set(GCamera.defaultAttitude());
    }

    public String toString() {
        return String.valueOf(this.attitude);
    }
}

