/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import net.geocentral.geometria.model.GCamera;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GLabelFactory;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GPoint3d
implements Cloneable,
GSelectable {
    private String label;
    public Point3d coords;
    public Point2d projCoords;
    public Point scrCoords;
    private boolean vertex;
    private List<GLine> lines = new ArrayList<GLine>();
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GPoint3d() {
    }

    public GPoint3d(double x, double y, double z, String label) {
        this();
        this.coords = new Point3d(x, y, z);
        this.label = label;
    }

    public GPoint3d(Point3d coords, String label) {
        this();
        this.coords = new Point3d(coords);
        this.label = label;
    }

    public GPoint3d clone() {
        GPoint3d p = new GPoint3d();
        p.label = this.label;
        p.vertex = this.vertex;
        p.coords = new Point3d(this.coords);
        return p;
    }

    public void make(Element node) throws Exception {
        this.makeLabel(node);
        this.makeCoords(node);
    }

    private void makeLabel(Element node) throws Exception {
        this.label = node.getElementsByTagName("label").item(0).getTextContent();
        GLabelFactory.getInstance().validateLabel(this.label);
    }

    private void makeCoords(Element node) throws Exception {
        NodeList ns = node.getElementsByTagName("coords");
        String coordsString = ns.item(0).getTextContent();
        this.coords = GStringUtils.coordsFromString(coordsString);
        if (this.coords == null) {
            logger.error((Object)this.coords);
            throw new Exception();
        }
    }

    public void project(GCamera camera, Point3d centerCoords) {
        Matrix3d attitude = camera.getAttitude();
        Point3d css = new Point3d(this.coords);
        css.sub((Tuple3d)centerCoords);
        Point3d cs = new Point3d();
        attitude.transform((Tuple3d)css, (Tuple3d)cs);
        this.projCoords = new Point2d(cs.x, cs.y);
    }

    public void serialize(StringBuffer buf) {
        buf.append("\n<point>");
        buf.append("\n<label>");
        buf.append(this.label);
        buf.append("</label>");
        buf.append("\n<coords>");
        buf.append(String.valueOf(this.coords.x));
        buf.append(' ');
        buf.append(String.valueOf(this.coords.y));
        buf.append(' ');
        buf.append(String.valueOf(this.coords.z));
        buf.append("</coords>");
        buf.append("\n</point>");
    }

    public void trimCoords(double epsilon) {
        if (Math.abs(this.coords.x) < epsilon) {
            this.coords.x = 0.0;
        }
        if (Math.abs(this.coords.y) < epsilon) {
            this.coords.y = 0.0;
        }
        if (Math.abs(this.coords.z) < epsilon) {
            this.coords.z = 0.0;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void resetLines() {
        this.lines = new ArrayList<GLine>();
    }

    public void addLine(GLine line) {
        this.lines.add(line);
    }

    public int lineCount() {
        return this.lines.size();
    }

    public GLine lineAt(int i) {
        return this.lines.get(i);
    }

    public Collection<GFace> getFaces() {
        LinkedHashSet<GFace> faces = new LinkedHashSet<GFace>();
        for (GLine line : this.lines) {
            GFace face = line.getFace();
            faces.add(face);
        }
        return faces;
    }

    public boolean isVertex() {
        return this.vertex;
    }

    public void setVertex(boolean vertex) {
        this.vertex = vertex;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return this.label == null ? this.coords.toString() : this.label + this.coords;
    }
}

