/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.model.GCamera;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GLabelFactory;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GStar;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.model.GXmlEntity;
import net.geocentral.geometria.util.GBoundingSphere;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GVersionManager;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GSolid
extends GXmlEntity
implements Cloneable {
    public static final double DEFAULT_SELECT_TOLERANCE = 5.0;
    public static final Color POINT_COLOR = Color.RED;
    public static final Color TRANSPARENT_LINE_COLOR = Color.BLACK;
    public static final Color OPAQUE_LINE_COLOR = Color.WHITE;
    public static final Color SELECTION_COLOR = Color.MAGENTA.darker();
    public static final int POINT_DIAMETER = 6;
    public static final int SELECTED_POINT_DIAMETER = 8;
    public static final Stroke SOLID_STROKE = new BasicStroke(1.0f);
    public static final float[] DASH = new float[]{12.0f, 8.0f};
    public static final Stroke DASH_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, DASH, 0.0f);
    public static final Stroke SELECTION_STROKE = new BasicStroke(4.0f);
    private Map<String, GPoint3d> points = new LinkedHashMap<String, GPoint3d>();
    private List<GFace> faces;
    private Map<GPoint3d, GStar> stars;
    private Point3d gCenter;
    private GBoundingSphere boundingSphere;
    private Set<GSelectable> selection = new LinkedHashSet<GSelectable>();
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GSolid() {
    }

    public GSolid(List<GPoint3d> pointList, List<GFace> faces) {
        this();
        logger.info((Object)(pointList + ", " + faces));
        for (GPoint3d p : pointList) {
            this.points.put(p.getLabel(), p);
        }
        this.faces = faces;
        this.makeConfig();
        this.computeGCenter();
        this.computeBoundingSphere();
    }

    public GSolid clone() {
        logger.info((Object)"");
        GSolid solid = new GSolid();
        solid.points = new LinkedHashMap<String, GPoint3d>();
        for (String label : this.points.keySet()) {
            GPoint3d p = this.points.get(label);
            GPoint3d clonedP = p.clone();
            solid.points.put(label, clonedP);
        }
        solid.faces = new ArrayList<GFace>();
        for (GFace face : this.faces) {
            GFace f = face.clone();
            solid.faces.add(f);
        }
        solid.gCenter = new Point3d(this.gCenter);
        solid.selection = new LinkedHashSet<GSelectable>();
        solid.boundingSphere = this.boundingSphere.clone();
        solid.makeConfig();
        return solid;
    }

    public void computeGCenter() {
        logger.info((Object)"");
        this.gCenter = new Point3d();
        int vertexCount = 0;
        for (GPoint3d p : this.points.values()) {
            if (!p.isVertex()) continue;
            ++vertexCount;
            this.gCenter.add((Tuple3d)p.coords);
        }
        this.gCenter.scale(1.0 / (double)vertexCount);
    }

    public void computeBoundingSphere() {
        logger.info((Object)"");
        double epsilon = 0.01;
        ArrayList<Point3d> ps = new ArrayList<Point3d>();
        for (GPoint3d p : this.points.values()) {
            if (!p.isVertex()) continue;
            ps.add(p.coords);
        }
        this.boundingSphere = new GBoundingSphere(ps, epsilon);
    }

    @Override
    public void make(Element node, GXmlEntity parent) throws Exception {
        logger.info((Object)"");
        this.makeVersion(node, parent);
        LinkedHashMap<String, GPoint3d> pointMap = new LinkedHashMap<String, GPoint3d>();
        this.makePoints(node, pointMap);
        ArrayList<GLine> lineList = new ArrayList<GLine>();
        this.makeLines(node, lineList);
        this.buildFaces(pointMap, lineList);
        this.computeGCenter();
        this.computeBoundingSphere();
    }

    private void makePoints(Element node, Map<String, GPoint3d> pointMap) throws Exception {
        GPoint3d p;
        logger.info((Object)"");
        TreeMap<String, GPoint3d> pMap = new TreeMap<String, GPoint3d>();
        NodeList ns = ((Element)node.getElementsByTagName("points").item(0)).getElementsByTagName("point");
        for (int i = 0; i < ns.getLength(); ++i) {
            Element n = (Element)ns.item(i);
            p = new GPoint3d();
            p.make(n);
            pMap.put(p.getLabel(), p);
        }
        for (String label : pMap.keySet()) {
            p = (GPoint3d)pMap.get(label);
            pointMap.put(label, p);
        }
    }

    private void makeLines(Element node, List<GLine> lineList) throws Exception {
        logger.info((Object)"");
        TreeSet<GStick> sticks = new TreeSet<GStick>();
        NodeList ns = ((Element)node.getElementsByTagName("lines").item(0)).getElementsByTagName("line");
        for (int i = 0; i < ns.getLength(); ++i) {
            Element n = (Element)ns.item(i);
            GStick stick = new GStick();
            stick.make(n);
            sticks.add(stick);
        }
        for (GStick stick : sticks) {
            GLine line = new GLine(stick);
            lineList.add(line);
        }
    }

    public void makeConfig() {
        logger.info((Object)"");
        this.stars = new LinkedHashMap<GPoint3d, GStar>();
        for (GFace face : this.faces) {
            for (int i = 0; i < face.lineCount(); ++i) {
                GStar star;
                GPoint3d p2;
                GPoint3d p1;
                int j;
                GLine line = face.lineAt(i);
                for (j = 0; j < line.labelCount() - 1; ++j) {
                    p1 = this.points.get(line.labelAt(j));
                    p2 = this.points.get(line.labelAt(j + 1));
                    star = this.stars.get(p1);
                    if (star == null) {
                        star = new GStar(p1);
                        this.stars.put(p1, star);
                    }
                    star.addNeighbor(p2);
                }
                for (j = line.labelCount() - 1; j > 0; --j) {
                    p1 = this.points.get(line.labelAt(j));
                    p2 = this.points.get(line.labelAt(j - 1));
                    star = this.stars.get(p1);
                    if (star == null) {
                        star = new GStar(p1);
                        this.stars.put(p1, star);
                    }
                    star.addNeighbor(p2);
                }
            }
        }
        for (GPoint3d p : this.points.values()) {
            p.resetLines();
        }
        LinkedHashMap<GStick, GLine> edges = new LinkedHashMap<GStick, GLine>();
        LinkedHashMap<GPoint3d, LinkedHashSet<GFace>> facesThroughPoints = new LinkedHashMap<GPoint3d, LinkedHashSet<GFace>>();
        for (GFace face : this.faces) {
            GLine line;
            int i;
            for (i = 0; i < face.lineCount(); ++i) {
                line = face.lineAt(i);
                line.setFace(face);
                for (int j = 0; j < line.labelCount(); ++j) {
                    GPoint3d p = this.points.get(line.labelAt(j));
                    p.addLine(line);
                    LinkedHashSet<GFace> fs = (LinkedHashSet<GFace>)facesThroughPoints.get(p);
                    if (fs == null) {
                        fs = new LinkedHashSet<GFace>();
                        facesThroughPoints.put(p, fs);
                    }
                    fs.add(face);
                }
            }
            for (i = 0; i < face.sideCount(); ++i) {
                line = face.lineAt(i);
                GStick stick = new GStick(line);
                GLine twin = (GLine)edges.get(stick);
                if (twin == null) {
                    edges.put(stick, line);
                    continue;
                }
                line.setTwin(twin);
                twin.setTwin(line);
                edges.remove(stick);
            }
        }
        Iterator<GFace> i$ = facesThroughPoints.keySet().iterator();
        while (i$.hasNext()) {
            GPoint3d p;
            Set fs = (Set)facesThroughPoints.get(p = (GPoint3d)((Object)i$.next()));
            p.setVertex(fs.size() > 2);
        }
    }

    public void project(GCamera camera) {
        Point3d bsCenter = this.boundingSphere.getCenter();
        for (GPoint3d p : this.points.values()) {
            p.project(camera, bsCenter);
        }
    }

    public void toScreen(double scalingFactor, Dimension figSize) {
        for (GPoint3d p : this.points.values()) {
            int scrX = (int)(0.5 * (double)figSize.width + scalingFactor * p.projCoords.x);
            int scrY = (int)(0.5 * (double)figSize.height - scalingFactor * p.projCoords.y);
            p.scrCoords = new Point(scrX, scrY);
        }
    }

    public void paintTransparent(Graphics2D g2d, GCamera camera, double scalingFactor, Dimension figSize, boolean labelled) {
        this.project(camera);
        this.toScreen(scalingFactor, figSize);
        LinkedHashMap<GStick, Boolean> sticks = new LinkedHashMap<GStick, Boolean>();
        for (GFace face : this.faces) {
            boolean faceVisible = camera.visible(face, this, this.gCenter);
            for (int i = 0; i < face.lineCount(); ++i) {
                GStick stick;
                GLine line = face.lineAt(i);
                boolean visible = Boolean.TRUE.equals(sticks.get(stick = new GStick(line)));
                sticks.put(stick, visible || faceVisible);
            }
        }
        g2d.setColor(TRANSPARENT_LINE_COLOR);
        for (GStick stick : sticks.keySet()) {
            Point p1 = this.points.get((Object)stick.label1).scrCoords;
            Point p2 = this.points.get((Object)stick.label2).scrCoords;
            boolean visible = (Boolean)sticks.get(stick);
            g2d.setStroke(visible ? SOLID_STROKE : DASH_STROKE);
            g2d.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
        for (GPoint3d p : this.points.values()) {
            g2d.setColor(this.selection.contains(p) ? SELECTION_COLOR : POINT_COLOR);
            g2d.fillOval(p.scrCoords.x - 3, p.scrCoords.y - 3, 6, 6);
            g2d.setColor(Color.black);
            if (!labelled) continue;
            GStar star = this.stars.get(p);
            String label = p.getLabel();
            int labelAscent = g2d.getFontMetrics().getAscent();
            int labelWidth = g2d.getFontMetrics().stringWidth(label);
            Point labelPos = star.fitLabel(labelWidth, labelAscent);
            g2d.drawString(label, labelPos.x, labelPos.y);
        }
        g2d.setColor(SELECTION_COLOR);
        for (GSelectable element : this.selection) {
            if (element instanceof GPoint3d) {
                Point p = ((GPoint3d)element).scrCoords;
                g2d.fillOval(p.x - 4, p.y - 4, 8, 8);
                continue;
            }
            if (!(element instanceof GStick)) continue;
            Point p1 = this.points.get((Object)((GStick)element).label1).scrCoords;
            Point p2 = this.points.get((Object)((GStick)element).label2).scrCoords;
            g2d.setStroke(SELECTION_STROKE);
            g2d.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
    }

    public void paintOpaque(Graphics2D g2d, GCamera camera, double scalingFactor, Dimension figSize, Color baseColor, boolean labelled) {
        this.project(camera);
        this.toScreen(scalingFactor, figSize);
        for (GFace face : this.faces) {
            if (!camera.visible(face, this, this.gCenter)) continue;
            face.paintOpaque(g2d, baseColor, camera, this.selection, this, this.gCenter);
        }
    }

    public GBoundingSphere getBoundingSphere() {
        return this.boundingSphere;
    }

    public GPoint3d getPoint(String label) {
        return this.points.get(label);
    }

    public int faceCount() {
        return this.faces.size();
    }

    public GFace faceAt(int index) {
        return this.faces.get(index);
    }

    public int pointCount() {
        return this.points.size();
    }

    public Iterator<GPoint3d> pointIterator() {
        return this.points.values().iterator();
    }

    public Collection<GFace> facesThroughPoints(String[] labels) {
        if (labels.length == 0) {
            return new LinkedHashSet<GFace>();
        }
        Collection<GFace> fs = this.facesThroughPoint(labels[0]);
        for (int i = 1; i < labels.length; ++i) {
            Collection<GFace> fss = this.facesThroughPoint(labels[i]);
            fs.retainAll(fss);
            if (!fs.isEmpty()) continue;
            return fs;
        }
        return fs;
    }

    public Collection<GFace> facesThroughPoint(String label) {
        GPoint3d p = this.getPoint(label);
        return p.getFaces();
    }

    public Collection<GLine> linesThroughPoints(String p1Label, String p2Label) {
        GPoint3d p1 = this.getPoint(p1Label);
        GPoint3d p2 = this.getPoint(p2Label);
        LinkedHashSet<GLine> lines1 = new LinkedHashSet<GLine>();
        for (int i = 0; i < p1.lineCount(); ++i) {
            GLine line = p1.lineAt(i);
            lines1.add(line);
        }
        LinkedHashSet<GLine> lines2 = new LinkedHashSet<GLine>();
        for (int i = 0; i < p2.lineCount(); ++i) {
            GLine line = p2.lineAt(i);
            lines2.add(line);
        }
        lines1.retainAll(lines2);
        return lines1;
    }

    public GPoint3d getPoint(Point3d coords) {
        double epsilon = this.getEpsilon();
        for (GPoint3d p : this.points.values()) {
            if (!p.coords.epsilonEquals((Tuple3d)coords, epsilon)) continue;
            return p;
        }
        return null;
    }

    public GPoint3d addPoint(Point3d coords) {
        logger.info((Object)coords);
        String label = GLabelFactory.getInstance().createLabel(this.points.keySet());
        GPoint3d p = new GPoint3d(coords, label);
        this.points.put(label, p);
        return p;
    }

    public void removePoint(String label) {
        logger.info((Object)label);
        this.points.remove(label);
    }

    public void undoRemovePoint(GPoint3d p) {
        this.points.put(p.getLabel(), p);
    }

    private GSelectable getSelectableAt(double xp, double yp, double scalingFactor, boolean transparent, GCamera camera) {
        double selectTolerance = 5.0 * Math.min(1.0, 1.0 / scalingFactor);
        if (transparent) {
            for (GPoint3d p : this.points.values()) {
                if (!(Point2D.distance(p.projCoords.x, p.projCoords.y, xp, yp) < selectTolerance)) continue;
                return p;
            }
            for (GFace face : this.faces) {
                GLine line = face.getLineAt(xp, yp, selectTolerance, this.points);
                if (line == null) continue;
                return new GStick(line);
            }
        } else {
            for (GFace face : this.faces) {
                if (!camera.visible(face, this, this.gCenter)) continue;
                Object element = face.getElementAt(xp, yp, selectTolerance, this.points);
                if (element instanceof GLine) {
                    return new GStick((GLine)element);
                }
                if (element instanceof GPoint3d) {
                    return (GPoint3d)element;
                }
                if (!(element instanceof GFace)) continue;
                return (GFace)element;
            }
        }
        return null;
    }

    public void select(double xp, double yp, double scalingFactor, boolean controlDown, boolean transparent, GCamera camera) {
        GSelectable element = this.getSelectableAt(xp, yp, scalingFactor, transparent, camera);
        if (element == null) {
            if (!controlDown) {
                this.clearSelection();
            }
        } else if (controlDown) {
            if (this.selection.contains(element)) {
                this.selection.remove(element);
            } else {
                this.selection.add(element);
            }
        } else if (this.selection.contains(element)) {
            this.clearSelection();
        } else {
            this.clearSelection();
            this.selection.add(element);
        }
    }

    public void clearSelection() {
        this.selection.clear();
    }

    public Set<GSelectable> getSelection() {
        return this.selection;
    }

    public void selectAll() {
        logger.info((Object)"");
        this.clearSelection();
        for (GPoint3d p : this.points.values()) {
            if (p.isVertex()) continue;
            this.selection.add(p);
        }
        for (GFace face : this.faces) {
            for (int i = face.sideCount(); i < face.lineCount(); ++i) {
                GLine line = face.lineAt(i);
                this.selection.add(new GStick(line));
            }
        }
    }

    public void selectLines(List<GPoint3d[]> lines) {
        logger.info((Object)"");
        this.clearSelection();
        for (GPoint3d[] ps : lines) {
            GLine line = this.linesThroughPoints(ps[0].getLabel(), ps[1].getLabel()).iterator().next();
            this.selection.add(new GStick(line));
        }
    }

    public double computeVolume() {
        logger.info((Object)"");
        double volume = 0.0;
        for (GFace face : this.faces) {
            Point3d p1 = this.points.get((Object)face.labelAt((int)0)).coords;
            Point3d p2 = this.points.get((Object)face.labelAt((int)1)).coords;
            Point3d p3 = this.points.get((Object)face.labelAt((int)2)).coords;
            volume += face.computeArea(this) * GMath.distanceToPlane(this.gCenter, p1, p2, p3);
        }
        return volume / 3.0;
    }

    public void scale(Point3d coords, Vector3d v, double factor) {
        logger.info((Object)(coords + ", " + v + ", " + factor));
        for (GPoint3d p : this.points.values()) {
            Point3d pCoords = GMath.scale(p.coords, new Point3d(0.0, 0.0, 0.0), v, factor);
            p.coords.set((Tuple3d)pCoords);
        }
        this.makeConfig();
        this.computeGCenter();
        this.computeBoundingSphere();
    }

    public void shear(Point3d p0, Vector3d v1, Vector3d v2) {
        logger.info((Object)(p0 + ", " + v1 + ", " + v2));
        for (GPoint3d p : this.points.values()) {
            Point3d pCoords = GMath.shear(p.coords, p0, v1, v2);
            p.coords.set((Tuple3d)pCoords);
        }
        this.makeConfig();
        this.computeGCenter();
        this.computeBoundingSphere();
    }

    public void undoShear(Point3d p0, Vector3d v1, Vector3d v2) {
        logger.info((Object)(p0 + ", " + v1 + ", " + v2));
        for (GPoint3d p : this.points.values()) {
            Point3d pCoords = GMath.undoShear(p.coords, p0, v1, v2);
            p.coords.set((Tuple3d)pCoords);
        }
        this.makeConfig();
        this.computeGCenter();
        this.computeBoundingSphere();
    }

    public GFace getFace(String[] labels) {
        for (GFace face : this.faces) {
            boolean match = true;
            for (int i = 0; i < 3; ++i) {
                if (face.contains(labels[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return face;
        }
        return null;
    }

    public double getEpsilon() {
        Iterator<GPoint3d> it = this.points.values().iterator();
        Point3d p1 = it.next().coords;
        Point3d p2 = it.next().coords;
        return 1.0E-7 * p1.distance(p2);
    }

    public Point3d getGCenter() {
        return this.gCenter;
    }

    public void cutOff(Point3d p0Coords, Vector3d n) throws Exception {
        logger.info((Object)(p0Coords + ", " + n));
        double epsilon = this.getEpsilon();
        Point3d cs = null;
        for (GFace face : this.faces) {
            if (!face.liesInPlane(p0Coords, n, this)) continue;
            logger.info((Object)("Plane does not intersect figure: " + p0Coords + ", " + n));
            throw new Exception(GDictionary.get("PlaneDoesNotIntersectFigure", new String[0]));
        }
        GFace face = null;
        for (int i = 0; i < this.faces.size(); ++i) {
            face = this.faces.get(i);
            List<Point3d> css = face.intersectPlane(p0Coords, n, this);
            if (css.size() <= 1) continue;
            cs = css.get(0);
            break;
        }
        if (cs == null) {
            logger.info((Object)"Plane does not intersect figure");
            throw new Exception(GDictionary.get("PlaneDoesNotIntersectFigure", new String[0]));
        }
        GPoint3d pInit = this.getPoint(cs);
        if (pInit == null) {
            pInit = this.addPoint(cs);
            for (int i = 0; i < face.sideCount(); ++i) {
                GLine line = face.lineAt(i);
                Point3d p1 = this.points.get((Object)line.firstLabel()).coords;
                Point3d p2 = this.points.get((Object)line.lastLabel()).coords;
                if (!GMath.isBetween(pInit.coords, p1, p2, epsilon)) continue;
                face.addPoint(pInit, this);
                pInit.addLine(line);
                GLine l = line.getTwin();
                GFace f = l.getFace();
                f.addPoint(pInit, this);
                pInit.addLine(l);
                break;
            }
        }
        GPoint3d pPrev = null;
        GPoint3d pCurr = pInit;
        GPoint3d pNext = null;
        GFace fCurr = null;
        LinkedHashMap<GLine, GFace> sectionMap = new LinkedHashMap<GLine, GFace>();
        while (true) {
            GLine line;
            Collection<GFace> fs = this.facesThroughPoint(pCurr.getLabel());
            Point3d coords = null;
            block4: for (GFace f : fs) {
                List<Point3d> ps = f.intersectPlane(p0Coords, n, this);
                if (ps.size() < 2) continue;
                GPoint3d p1 = this.getPoint(ps.get(0));
                GPoint3d p2 = this.getPoint(ps.get(1));
                if (p1 == pCurr) {
                    pNext = p2;
                    coords = ps.get(1);
                } else {
                    pNext = p1;
                    coords = ps.get(0);
                }
                if (pPrev != null && pNext == pPrev) continue;
                fCurr = f;
                if (pNext != null) break;
                pNext = this.addPoint(coords);
                for (int i = 0; i < fCurr.sideCount(); ++i) {
                    GLine line2 = fCurr.lineAt(i);
                    GPoint3d pp1 = this.points.get(line2.firstLabel());
                    GPoint3d pp2 = this.points.get(line2.lastLabel());
                    if (!GMath.isStrictlyBetween(pNext.coords, pp1.coords, pp2.coords, epsilon)) continue;
                    fCurr.addPoint(pNext, this);
                    GLine l = line2.getTwin();
                    GFace ff = l.getFace();
                    ff.addPoint(pNext, this);
                    pNext.addLine(line2);
                    pNext.addLine(l);
                    break block4;
                }
            }
            if ((line = fCurr.lineThroughPoints(pCurr.getLabel(), pNext.getLabel())) == null) {
                ArrayList<GLine> removedLines = new ArrayList<GLine>();
                line = fCurr.addLine(pCurr, pNext, removedLines, this);
                for (GLine l : removedLines) {
                    fCurr.removeLine(l, new ArrayList<String>());
                }
            }
            if (fCurr.containsSide(line)) {
                sectionMap.put(line, null);
            } else {
                sectionMap.put(line, fCurr);
            }
            if (pNext == pInit) break;
            pPrev = pCurr;
            pCurr = pNext;
        }
        ArrayList<GFace> toBeRemovedFaces = new ArrayList<GFace>();
        LinkedHashSet<GPoint3d> toBeRemovedPoints = new LinkedHashSet<GPoint3d>();
        for (GFace f : this.faces) {
            if (sectionMap.containsValue(f)) continue;
            Point3d fCenter = f.computeGCenter(this);
            Vector3d v = new Vector3d((Tuple3d)fCenter);
            v.sub((Tuple3d)p0Coords);
            if (v.dot(n) < 0.0) continue;
            toBeRemovedFaces.add(f);
            for (int i = 0; i < f.lineCount(); ++i) {
                GLine line = f.lineAt(i);
                for (int j = 0; j < line.labelCount(); ++j) {
                    GPoint3d p = this.points.get(line.labelAt(j));
                    if (GMath.isInPlane(p.coords, p0Coords, n)) continue;
                    toBeRemovedPoints.add(p);
                }
            }
        }
        String prevEndLabel = null;
        ArrayList<GLine> ls = new ArrayList<GLine>();
        for (GLine line : sectionMap.keySet()) {
            GFace ff = (GFace)sectionMap.get(line);
            if (ff != null) {
                LinkedHashSet<GPoint3d> tbrPs = new LinkedHashSet<GPoint3d>();
                ff.cutOff(line, n, tbrPs, this);
                toBeRemovedPoints.addAll(tbrPs);
            }
            GLine l = line.clone();
            if (prevEndLabel != null && !line.firstLabel().equals(prevEndLabel)) {
                l.reverse();
            }
            prevEndLabel = l.lastLabel();
            if (ff != null) {
                l.setTwin(line);
            } else {
                GFace f = line.getFace();
                if (!toBeRemovedFaces.contains(f)) {
                    l.setTwin(line);
                } else {
                    l.setTwin(line.getTwin());
                }
            }
            ls.add(l);
        }
        GFace section = new GFace(ls.size(), ls);
        section.chainSides();
        for (GPoint3d p : toBeRemovedPoints) {
            this.points.remove(p.getLabel());
        }
        this.faces.removeAll(toBeRemovedFaces);
        this.faces.add(section);
        this.makeConfig();
        this.computeGCenter();
        this.computeBoundingSphere();
    }

    public void cutOff(String p0Label, Vector3d n) throws Exception {
        logger.info((Object)(p0Label + ", " + n));
        Point3d p0Coords = this.getPoint((String)p0Label).coords;
        this.cutOff(p0Coords, n);
    }

    private SortedMap<Integer, Set<GFace>> groupFacesBySize() {
        logger.info((Object)"");
        TreeMap<Integer, Set<GFace>> facesBySize = new TreeMap<Integer, Set<GFace>>();
        for (GFace face : this.faces) {
            int sideCount = face.sideCount();
            if (!facesBySize.containsKey(sideCount)) {
                facesBySize.put(sideCount, new LinkedHashSet());
            }
            Set faceGroup = (Set)facesBySize.get(sideCount);
            faceGroup.add(face);
        }
        return facesBySize;
    }

    public Map<GFace, Map<GFace, List<Integer>>> getJoinMatches(GSolid solid) {
        logger.info((Object)"");
        LinkedHashMap<GFace, Map<GFace, List<Integer>>> joinMatches = new LinkedHashMap<GFace, Map<GFace, List<Integer>>>();
        SortedMap<Integer, Set<GFace>> facesBySize1 = this.groupFacesBySize();
        SortedMap<Integer, Set<GFace>> facesBySize2 = solid.groupFacesBySize();
        LinkedHashSet<Integer> unmatchedSizes = new LinkedHashSet<Integer>();
        for (int size : facesBySize1.keySet()) {
            if (facesBySize2.containsKey(size)) continue;
            unmatchedSizes.add(size);
        }
        for (int size : facesBySize2.keySet()) {
            if (facesBySize1.containsKey(size)) continue;
            unmatchedSizes.add(size);
        }
        for (int size : unmatchedSizes) {
            facesBySize1.remove(size);
            facesBySize2.remove(size);
        }
        Iterator<Set<GFace>> it1 = facesBySize1.values().iterator();
        Iterator<Set<GFace>> it2 = facesBySize2.values().iterator();
        while (it1.hasNext()) {
            Set<GFace> fs1 = it1.next();
            Set<GFace> fs2 = it2.next();
            for (GFace face1 : fs1) {
                for (GFace face2 : fs2) {
                    boolean flipFace2;
                    List<Integer> indexes = face1.match(face2, flipFace2 = face1.getOrientation(this, this.gCenter) == face2.getOrientation(solid, solid.gCenter), this, solid);
                    if (indexes.isEmpty()) continue;
                    LinkedHashMap<GFace, List<Integer>> face1Matches = (LinkedHashMap<GFace, List<Integer>>)joinMatches.get(face1);
                    if (face1Matches == null) {
                        face1Matches = new LinkedHashMap<GFace, List<Integer>>();
                        joinMatches.put(face1, face1Matches);
                    }
                    face1Matches.put(face2, indexes);
                }
            }
        }
        return joinMatches;
    }

    public GSolid join(GSolid solid1, GFace face, GFace face1, int matchIndex) throws Exception {
        logger.info((Object)(this + ", " + solid1 + ", " + face + ", " + face1 + ", " + matchIndex));
        double epsilon = this.getEpsilon();
        try {
            GLine line;
            int i;
            Vector3d outerNormal;
            boolean flipFace1 = face.getOrientation(this, this.gCenter) == face1.getOrientation(solid1, solid1.gCenter);
            GSolid solid1Clone = solid1.clone();
            String[] labels1 = new String[]{face1.labelAt(0), face1.labelAt(1), face1.labelAt(2)};
            GFace face1Clone = solid1Clone.facesThroughPoints(labels1).iterator().next();
            if (flipFace1) {
                face1Clone.reverse();
            }
            face1Clone.anchorAt(face1Clone.sideCount() - matchIndex);
            double factor = face.lineAt(0).length(this) / face1Clone.lineAt(0).length(solid1Clone);
            for (GPoint3d p : solid1Clone.points.values()) {
                p.coords.scale(factor);
            }
            Vector3d v1 = face.lineAt(0).toVector(this);
            Vector3d v2 = face.lineAt(face.sideCount() - 1).toVector(this);
            v2.scale(-1.0);
            GMath.orthize(v1, v2);
            Matrix3d matrix = new Matrix3d();
            matrix.setColumn(0, v1);
            matrix.setColumn(1, v2);
            matrix.setColumn(2, face.getNormal(this));
            Vector3d v11 = face1Clone.lineAt(0).toVector(solid1Clone);
            Vector3d v12 = face1Clone.lineAt(face1Clone.sideCount() - 1).toVector(solid1Clone);
            v12.scale(-1.0);
            GMath.orthize(v11, v12);
            Matrix3d matrix1 = new Matrix3d();
            matrix1.setColumn(0, v11);
            matrix1.setColumn(1, v12);
            matrix1.setColumn(2, face1Clone.getNormal(solid1Clone));
            matrix1.invert();
            matrix.mul(matrix1);
            Point3d pivot = solid1Clone.getPoint((String)face1Clone.labelAt((int)0)).coords;
            for (GPoint3d p : solid1Clone.points.values()) {
                Vector3d v = new Vector3d((Tuple3d)p.coords);
                v.sub((Tuple3d)pivot);
                matrix.transform((Tuple3d)v);
                p.coords.add((Tuple3d)pivot, (Tuple3d)v);
            }
            Vector3d v = new Vector3d((Tuple3d)this.getPoint((String)face.labelAt((int)0)).coords);
            v.sub((Tuple3d)solid1Clone.getPoint((String)face1Clone.labelAt((int)0)).coords);
            for (GPoint3d p1 : solid1Clone.points.values()) {
                p1.coords.add((Tuple3d)v);
            }
            solid1Clone.computeGCenter();
            for (GFace f : this.faces) {
                if (f == face) continue;
                outerNormal = f.getNormal(this, this.gCenter);
                Point3d p = this.getPoint((String)f.labelAt((int)0)).coords;
                for (GPoint3d p1 : solid1Clone.points.values()) {
                    v = new Vector3d((Tuple3d)p1.coords);
                    v.sub((Tuple3d)p);
                    if (!(v.dot(outerNormal) > epsilon)) continue;
                    return null;
                }
            }
            for (GFace f1 : solid1Clone.faces) {
                if (f1 == face1Clone) continue;
                outerNormal = f1.getNormal(solid1Clone, solid1Clone.gCenter);
                Point3d p1 = solid1Clone.getPoint((String)f1.labelAt((int)0)).coords;
                for (GPoint3d p : this.points.values()) {
                    v = new Vector3d((Tuple3d)p.coords);
                    v.sub((Tuple3d)p1);
                    if (!(v.dot(outerNormal) > epsilon)) continue;
                    return null;
                }
            }
            GSolid thisClone = this.clone();
            String[] labels = new String[]{face.labelAt(0), face.labelAt(1), face.labelAt(2)};
            GFace faceClone = thisClone.facesThroughPoints(labels).iterator().next();
            LinkedHashMap<GPoint3d, GPoint3d> p1ToP = new LinkedHashMap<GPoint3d, GPoint3d>();
            LinkedHashSet<GFace> faces1 = new LinkedHashSet<GFace>();
            LinkedHashSet<GFace> newFaces = new LinkedHashSet<GFace>();
            for (int i2 = 0; i2 < faceClone.sideCount(); ++i2) {
                GLine l;
                int j;
                int j2;
                GLine line2 = faceClone.lineAt(i2).getTwin();
                GLine line1 = face1Clone.lineAt(i2).getTwin();
                for (int j3 = 0; j3 < line1.labelCount(); ++j3) {
                    GPoint3d p1 = solid1Clone.getPoint(line1.labelAt(j3));
                    GPoint3d p = line2.getPoint(p1.coords, thisClone);
                    if (p == null) {
                        p = thisClone.addPoint(p1.coords);
                        line2.insert(p, thisClone);
                    }
                    p1ToP.put(p1, p);
                }
                GFace f = line2.getFace();
                GFace f1 = line1.getFace();
                int index1 = f1.indexOf(line1);
                f1.anchorAt(index1);
                ArrayList<GLine> ls = new ArrayList<GLine>();
                GLine newL1 = new GLine(line2);
                ls.add(newL1);
                for (int j4 = 1; j4 < f1.lineCount(); ++j4) {
                    GLine l1 = f1.lineAt(j4);
                    ArrayList<String> ps = new ArrayList<String>();
                    for (int k = 0; k < l1.labelCount(); ++k) {
                        GPoint3d p1 = solid1Clone.getPoint(l1.labelAt(k));
                        GPoint3d p = (GPoint3d)p1ToP.get(p1);
                        if (p == null) {
                            p = thisClone.addPoint(p1.coords);
                            p1ToP.put(p1, p);
                        }
                        ps.add(p.getLabel());
                    }
                    newL1 = new GLine(ps);
                    ls.add(newL1);
                }
                faces1.add(f1);
                GFace newFace = new GFace(f1.sideCount(), ls);
                newFace.chainSides();
                if (f1.getNormal(solid1Clone, solid1Clone.gCenter).dot(f.getNormal(thisClone, thisClone.gCenter)) < 0.9999999) {
                    newFaces.add(newFace);
                    continue;
                }
                int index = f.indexOf(line2);
                f.anchorAt(index);
                if (f.labelAt(0).equals(newFace.labelAt(0))) {
                    newFace.reverse();
                    newFace.anchorAt(newFace.sideCount() - 1);
                }
                int sc = f.sideCount();
                int sc1 = newFace.sideCount();
                ls = new ArrayList();
                for (j2 = 1; j2 < sc; ++j2) {
                    GLine l2 = f.lineAt(j2);
                    ls.add(l2);
                }
                for (j2 = 1; j2 < sc1; ++j2) {
                    GLine newL = newFace.lineAt(j2);
                    ls.add(newL);
                }
                GLine lBegin = (GLine)ls.get(0);
                GLine lEnd = (GLine)ls.get(sc - 2);
                GLine newLBegin = (GLine)ls.get(sc - 1);
                GLine newLEnd = (GLine)ls.get(sc + sc1 - 3);
                if (lBegin.acquire(newLEnd, thisClone)) {
                    ls.remove(newLEnd);
                }
                if (lEnd.acquire(newLBegin, thisClone)) {
                    ls.remove(newLBegin);
                }
                int newSideCount = ls.size();
                GFace nf = new GFace(newSideCount, ls);
                nf.chainSides();
                for (j = sc; j < f.lineCount(); ++j) {
                    l = f.lineAt(j);
                    nf.addLine(l);
                }
                for (j = sc1; j < newFace.lineCount(); ++j) {
                    l = newFace.lineAt(j);
                    for (int k = sc; k < f.lineCount(); ++k) {
                        GLine ll = f.lineAt(k);
                        if (ll.acquire(l, thisClone)) continue;
                        nf.addLine(l);
                    }
                }
                nf.addLine(line2);
                thisClone.faces.remove(f);
                newFaces.add(nf);
            }
            faces1.add(face1Clone);
            for (GFace f1 : solid1Clone.faces) {
                if (faces1.contains(f1)) continue;
                ArrayList<GLine> ls = new ArrayList<GLine>();
                for (int j = 0; j < f1.lineCount(); ++j) {
                    GLine l1 = f1.lineAt(j);
                    ArrayList<String> ps = new ArrayList<String>();
                    for (int k = 0; k < l1.labelCount(); ++k) {
                        GPoint3d p1 = solid1Clone.getPoint(l1.labelAt(k));
                        GPoint3d p = (GPoint3d)p1ToP.get(p1);
                        if (p == null) {
                            p = thisClone.addPoint(p1.coords);
                            p1ToP.put(p1, p);
                        }
                        ps.add(p.getLabel());
                    }
                    GLine newLine = new GLine(ps);
                    ls.add(newLine);
                }
                faces1.add(f1);
                GFace newFace = new GFace(f1.sideCount(), ls);
                newFace.chainSides();
                newFaces.add(newFace);
            }
            thisClone.faces.remove(faceClone);
            LinkedHashSet<String> ls = new LinkedHashSet<String>();
            for (i = 0; i < faceClone.sideCount(); ++i) {
                line = faceClone.lineAt(i);
                for (int j = 0; j < line.labelCount(); ++j) {
                    ls.add(line.labelAt(j));
                }
            }
            for (i = faceClone.sideCount(); i < faceClone.lineCount(); ++i) {
                line = faceClone.lineAt(i);
                for (int j = 0; j < line.labelCount(); ++j) {
                    String label = line.labelAt(j);
                    if (ls.contains(label)) continue;
                    thisClone.removePoint(label);
                }
            }
            thisClone.faces.addAll(newFaces);
            thisClone.makeConfig();
            thisClone.computeGCenter();
            thisClone.makeConfig();
            thisClone.computeBoundingSphere();
            return thisClone;
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            return null;
        }
    }

    private void buildFaces(Map<String, GPoint3d> pointMap, List<GLine> lineList) throws Exception {
        logger.info((Object)"");
        Point3d o = new Point3d(0.0, 0.0, 0.0);
        double maxDist = 0.0;
        for (GPoint3d p : pointMap.values()) {
            double dist = p.coords.distance(o);
            if (!(dist > maxDist)) continue;
            maxDist = dist;
        }
        double epsilon = maxDist * 1.0E-7;
        ArrayList<GPoint3d> toBeRemovedPoints = new ArrayList<GPoint3d>();
        for (GPoint3d p : pointMap.values()) {
            Iterator<GPoint3d> it;
            if (this.points.isEmpty()) {
                this.points.put(p.getLabel(), p);
                toBeRemovedPoints.add(p);
                continue;
            }
            if (this.points.size() == 1) {
                it = this.points.values().iterator();
                if (it.next().coords.epsilonEquals((Tuple3d)p.coords, epsilon)) {
                    logger.error((Object)("Points " + p.getLabel() + ", " + this.points.keySet().iterator().next() + " virtually equal"));
                    throw new Exception();
                }
                this.points.put(p.getLabel(), p);
                toBeRemovedPoints.add(p);
                continue;
            }
            if (this.points.size() == 2) {
                it = this.points.values().iterator();
                Point3d[] ps = new Point3d[]{it.next().coords, it.next().coords, p.coords};
                if (GMath.areCollinear(ps, epsilon)) continue;
                this.points.put(p.getLabel(), p);
                toBeRemovedPoints.add(p);
                continue;
            }
            if (this.points.size() != 3) continue;
            it = this.points.values().iterator();
            Vector3d n = GMath.cross(it.next().coords, it.next().coords, it.next().coords);
            n.normalize();
            Vector3d v = new Vector3d((Tuple3d)p.coords);
            it = this.points.values().iterator();
            v.sub((Tuple3d)it.next().coords);
            if (Math.abs(v.dot(n)) < epsilon) continue;
            this.points.put(p.getLabel(), p);
            toBeRemovedPoints.add(p);
            break;
        }
        Point3d refPoint = new Point3d();
        for (GPoint3d p : this.points.values()) {
            refPoint.add((Tuple3d)p.coords);
        }
        refPoint.scale(1.0 / (double)this.points.size());
        this.faces = new ArrayList<GFace>();
        Iterator<GPoint3d> it = this.points.values().iterator();
        GPoint3d[] ps = new GPoint3d[]{it.next(), it.next(), it.next(), it.next()};
        GPoint3d[] ps1 = new GPoint3d[]{ps[0], ps[1], ps[2]};
        this.faces.add(this.makeTriangle(ps1, refPoint));
        GPoint3d[] ps2 = new GPoint3d[]{ps[1], ps[2], ps[3]};
        this.faces.add(this.makeTriangle(ps2, refPoint));
        GPoint3d[] ps3 = new GPoint3d[]{ps[2], ps[3], ps[0]};
        this.faces.add(this.makeTriangle(ps3, refPoint));
        GPoint3d[] ps4 = new GPoint3d[]{ps[3], ps[0], ps[1]};
        this.faces.add(this.makeTriangle(ps4, refPoint));
        this.makeConfig();
        for (GPoint3d p : pointMap.values()) {
            if (this.points.containsKey(p.getLabel())) continue;
            this.addPoint(p, refPoint);
            this.points.put(p.getLabel(), p);
            this.makeConfig();
        }
        LinkedHashSet<String> vertexLabels = new LinkedHashSet<String>();
        for (GFace face : this.faces) {
            for (int i = 0; i < face.sideCount(); ++i) {
                String label = face.labelAt(i);
                vertexLabels.add(label);
            }
        }
        this.points.keySet().retainAll(vertexLabels);
        this.makeConfig();
        for (GPoint3d p : pointMap.values()) {
            if (this.points.containsKey(p.getLabel())) continue;
            boolean added = false;
            for (GFace face : this.faces) {
                if (!face.addPoint(p, this)) continue;
                added = true;
            }
            if (!added) continue;
            this.points.put(p.getLabel(), p);
        }
        this.makeConfig();
        for (GLine line : lineList) {
            boolean lineAdded = false;
            for (GFace face : this.faces) {
                GLine l;
                GPoint3d p1 = pointMap.get(line.firstLabel());
                GPoint3d p2 = pointMap.get(line.lastLabel());
                if (!face.covers(p1.coords, this) || !face.covers(p2.coords, this)) continue;
                if (!this.points.containsKey(p1.getLabel())) {
                    this.points.put(p1.getLabel(), p1);
                }
                if (!this.points.containsKey(p2.getLabel())) {
                    this.points.put(p2.getLabel(), p2);
                }
                if ((l = face.addLine(p1, p2, new ArrayList<GLine>(), this)) == null) continue;
                lineAdded = true;
                break;
            }
            if (lineAdded) continue;
            logger.error((Object)("Line " + line.toString() + " is contained in no face"));
            throw new Exception();
        }
        for (GPoint3d p : pointMap.values()) {
            if (this.points.containsKey(p.getLabel())) continue;
            boolean pointAdded = false;
            for (GFace face : this.faces) {
                if (!face.addPoint(p, this)) continue;
                pointAdded = true;
            }
            if (!pointAdded) {
                logger.error((Object)("Point " + p.getLabel() + " is contained in no face"));
                throw new Exception();
            }
            this.points.put(p.getLabel(), p);
        }
        this.makeConfig();
    }

    private boolean addPoint(GPoint3d p, Point3d refPoint) throws Exception {
        LinkedHashSet<GFace> front = new LinkedHashSet<GFace>();
        LinkedHashSet<GFace> rear = new LinkedHashSet<GFace>();
        LinkedHashSet<GFace> rim = new LinkedHashSet<GFace>();
        for (GFace face : this.faces) {
            int orientation = face.getOrientation(this, p.coords);
            if (orientation == 0) {
                rear.add(face);
                continue;
            }
            if (orientation == 1) {
                front.add(face);
                continue;
            }
            rim.add(face);
        }
        if (front.isEmpty()) {
            return false;
        }
        ArrayList<GFace> fs = new ArrayList<GFace>();
        for (GFace face : rim) {
            face.addExternalPoint(p, this);
            fs.add(face);
        }
        for (GFace face : rear) {
            for (int i = 0; i < face.sideCount(); ++i) {
                GLine line = face.lineAt(i);
                GFace f = line.getTwin().getFace();
                if (!front.contains(f)) continue;
                GPoint3d[] ps = new GPoint3d[]{this.getPoint(line.firstLabel()), this.getPoint(line.lastLabel()), p};
                GFace ff = this.makeTriangle(ps, refPoint);
                fs.add(ff);
            }
            fs.add(face);
        }
        this.faces = fs;
        return true;
    }

    private GFace makeTriangle(GPoint3d[] ps, Point3d refPoint) {
        ArrayList<GLine> lines = new ArrayList<GLine>();
        lines.add(new GLine(ps[0].getLabel(), ps[1].getLabel()));
        lines.add(new GLine(ps[1].getLabel(), ps[2].getLabel()));
        lines.add(new GLine(ps[2].getLabel(), ps[0].getLabel()));
        GFace face = new GFace(3, lines);
        if (GMath.getOrientation(ps[0].coords, ps[1].coords, ps[2].coords, refPoint) == 1) {
            face.reverse();
        }
        return face;
    }

    public void toOff(StringBuffer buf) {
        LinkedHashMap<String, Integer> vertices = new LinkedHashMap<String, Integer>();
        int index = 0;
        for (GPoint3d p : this.points.values()) {
            if (!p.isVertex()) continue;
            vertices.put(p.getLabel(), index++);
        }
        int vertexCount = vertices.size();
        int faceCount = this.faces.size();
        buf.append("OFF").append("\n").append(vertexCount).append(" ").append(faceCount).append(" ").append(0);
        for (String label : vertices.keySet()) {
            Point3d coords = this.getPoint((String)label).coords;
            buf.append("\n").append(coords.x).append(" ").append(coords.y).append(" ").append(coords.z);
        }
        for (GFace face : this.faces) {
            int sideCount = face.sideCount();
            buf.append("\n").append(sideCount);
            for (int i = 0; i < sideCount; ++i) {
                String label = face.labelAt(i);
                int ind = (Integer)vertices.get(label);
                buf.append(" ").append(ind);
            }
        }
    }

    public boolean isSimilar(GSolid solid) {
        if (solid.points.size() != this.points.size()) {
            return false;
        }
        if (solid.faces.size() != this.faces.size()) {
            return false;
        }
        List<Double> angles = this.getDihedralAngles();
        List<Double> solidAngles = solid.getDihedralAngles();
        for (int i = 0; i < angles.size(); ++i) {
            double solidAngle;
            double angle = angles.get(i);
            if (!(Math.abs(angle - (solidAngle = solidAngles.get(i).doubleValue())) >= 1.0E-7)) continue;
            return false;
        }
        List<Double> areas = this.getFaceAreas();
        List<Double> solidAreas = solid.getFaceAreas();
        double factor = areas.get(0) / solidAreas.get(0);
        for (int i = 0; i < areas.size(); ++i) {
            double area = areas.get(i);
            double solidArea = solidAreas.get(i);
            if (!(Math.abs(solidArea * factor / area - 1.0) >= 1.0E-7)) continue;
            return false;
        }
        return true;
    }

    List<Double> getDihedralAngles() {
        ArrayList<Double> angles = new ArrayList<Double>();
        for (GFace face1 : this.faces) {
            Vector3d n1 = face1.getNormal(this);
            for (int i = 0; i < face1.sideCount(); ++i) {
                GLine line = face1.lineAt(i);
                GFace face2 = line.getTwin().getFace();
                Vector3d n2 = face2.getNormal(this);
                double angle = n1.angle(n2);
                angles.add(angle);
            }
        }
        Collections.sort(angles);
        ArrayList<Double> nonDuplicatedAngles = new ArrayList<Double>();
        for (int i = 0; i < angles.size(); i += 2) {
            double angle = (Double)angles.get(i);
            nonDuplicatedAngles.add(angle);
        }
        return nonDuplicatedAngles;
    }

    List<Double> getFaceAreas() {
        ArrayList<Double> areas = new ArrayList<Double>();
        for (GFace face : this.faces) {
            double area = face.computeArea(this);
            areas.add(area);
        }
        Collections.sort(areas);
        return areas;
    }

    public void RenamePoint(String oldLabel, String newLabel) {
        GPoint3d point = this.points.get(oldLabel);
        point.setLabel(newLabel);
        this.points.remove(oldLabel);
        this.points.put(newLabel, point);
        for (GFace face : this.faces) {
            face.pointRenamed(oldLabel, newLabel);
        }
    }

    @Override
    public String getSchemaFile(String version) {
        return GVersionManager.getInstance().getSolidSchema(version);
    }

    @Override
    public void serialize(StringBuffer buf) {
        this.serialize(buf, false);
    }

    @Override
    public void serialize(StringBuffer buf, boolean preamble) {
        logger.info((Object)preamble);
        if (preamble) {
            buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n<solid xmlns=\"").append("http://geocentral.net").append("\">").append("\n<version>").append(GVersionManager.getInstance().getApplicationVersion()).append("</version>");
        } else {
            buf.append("\n<solid>");
        }
        buf.append("\n<points>");
        double epsilon = this.getEpsilon();
        for (GPoint3d p : this.points.values()) {
            p.trimCoords(epsilon);
            p.serialize(buf);
        }
        buf.append("\n</points>").append("\n<lines>");
        for (GFace face : this.faces) {
            for (int i = face.sideCount(); i < face.lineCount(); ++i) {
                GLine line = face.lineAt(i);
                line.serialize(buf);
            }
        }
        buf.append("\n</lines>").append("\n</solid>");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        for (GPoint3d p : this.points.values()) {
            if (!p.isVertex()) continue;
            buf.append(p.getLabel());
        }
        buf.append("]");
        return String.valueOf(buf);
    }
}

