/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model.answer;

import java.util.List;
import net.geocentral.geometria.action.GRenameFigureAction;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.model.answer.condition.GCondition;
import net.geocentral.geometria.model.answer.condition.GFigureCondition;
import net.geocentral.geometria.model.answer.condition.GHamiltonianCycleCondition;
import net.geocentral.geometria.model.answer.condition.GLineSetCondition;
import net.geocentral.geometria.util.GLineSetUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GLineSetAnswer
implements GAnswer {
    private GLineSetCondition[] conditions;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GLineSetAnswer() {
        this.conditions = new GLineSetCondition[1];
    }

    public GLineSetAnswer(GLineSetCondition[] conditions) {
        logger.info((Object)conditions.length);
        this.conditions = conditions;
    }

    @Override
    public void make(Element node, GProblem document) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("condition");
        if (ns.getLength() != 1) {
            logger.error((Object)ns.getLength());
            throw new Exception();
        }
        for (int i = 0; i < ns.getLength(); ++i) {
            Element n = (Element)ns.item(i);
            NodeList nns = n.getElementsByTagName("type");
            if (nns.getLength() <= 0) continue;
            String type = nns.item(0).getTextContent();
            if (!type.equals("hamiltonianCycle")) {
                logger.error((Object)type);
                throw new Exception();
            }
            this.conditions[i] = new GHamiltonianCycleCondition();
            this.conditions[i].make(n, document);
        }
    }

    @Override
    public boolean validate(String valueString, String figureName, GDocument document) {
        List<GPoint3d[]> lines;
        try {
            lines = GLineSetUtils.fromString(valueString, figureName, document);
        }
        catch (Exception exception) {
            return false;
        }
        return this.verify(lines, document);
    }

    public boolean verify(List<GPoint3d[]> lines, GDocument document) {
        logger.info(lines);
        for (GLineSetCondition condition : this.conditions) {
            if (condition == null || condition.verify(lines, document)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(StringBuffer buf, boolean lock) {
        logger.info((Object)"");
        buf.append("\n<answer>");
        buf.append("\n<type>lineSet</type>");
        for (int i = 0; i < this.conditions.length; ++i) {
            if (this.conditions[i] == null) {
                buf.append("\n<condition/>");
                continue;
            }
            this.conditions[i].serialize(buf);
        }
        buf.append("\n</answer>");
    }

    public void figureRenamed(GRenameFigureAction action) {
        logger.info((Object)"");
        for (GLineSetCondition condition : this.conditions) {
            if (!(condition instanceof GFigureCondition)) continue;
            ((GFigureCondition)((Object)condition)).figureRenamed(action);
        }
    }

    public void renameFigureUndone(GRenameFigureAction action) {
        logger.info((Object)"");
        for (GLineSetCondition condition : this.conditions) {
            if (!(condition instanceof GFigureCondition)) continue;
            ((GFigureCondition)((Object)condition)).renameFigureUndone(action);
        }
    }

    public GCondition[] getConditions() {
        return this.conditions;
    }

    public String toString() {
        return "Not implemented";
    }

    public boolean isFigureReferenced(String figureName) {
        for (GLineSetCondition condition : this.conditions) {
            if (!(condition instanceof GFigureCondition) || !((GFigureCondition)((Object)condition)).getFigureName().equals(figureName)) continue;
            return true;
        }
        return false;
    }
}

