/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import net.geocentral.geometria.model.GOptions;
import net.geocentral.geometria.util.GOptionsManager;
import org.apache.log4j.Logger;

public class GDictionary {
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    private static Map<String, String> dictionary;
    private static Logger logger;

    public static void init() throws Exception {
        String line;
        logger.info((Object)"");
        dictionary = new TreeMap<String, String>();
        GOptions options = GOptionsManager.getInstance().getOptions();
        String file = String.format("/dictionary/%s/dictionary.txt", options.getLanguage());
        BufferedReader in = new BufferedReader(new InputStreamReader(GDictionary.class.getResourceAsStream(file), "UTF-8"));
        while ((line = in.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            int pos = line.indexOf(61);
            String key = line.substring(0, pos).trim();
            String value = line.substring(pos + 1).trim();
            dictionary.put(key, value);
        }
        GDictionary.initUIManager();
    }

    public static String get(String key, String ... parameters) {
        String value;
        Matcher keyMatcher = PLACEHOLDER_PATTERN.matcher(key);
        if (keyMatcher.matches()) {
            key = keyMatcher.group(1);
        }
        if ((value = dictionary.get(key)) == null) {
            return "${" + key + "}";
        }
        if ((value = value.trim()).length() == 0 || parameters.length == 0) {
            return value;
        }
        StringBuffer buf = new StringBuffer();
        Matcher valueMatcher = PLACEHOLDER_PATTERN.matcher(value);
        for (int parameterIndex = 0; valueMatcher.find() && parameterIndex != parameters.length; ++parameterIndex) {
            int replacementIndex = Integer.valueOf(valueMatcher.group(1)) - 1;
            valueMatcher.appendReplacement(buf, parameters[replacementIndex]);
        }
        valueMatcher.appendTail(buf);
        return String.valueOf(buf);
    }

    private static void initUIManager() {
        logger.info((Object)"");
        String prefix = "UIManager.";
        for (String key : dictionary.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String value = dictionary.get(key);
            key = key.substring(prefix.length());
            UIManager.put(key, value);
        }
    }

    static {
        logger = Logger.getLogger((String)"net.geocentral.geometria");
    }
}

