/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Frame;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.geocentral.geometria.action.GSolutionAnswerAction;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.model.answer.GLineSetAnswer;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GLineSetUtils;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GSolutionLineSetAnswerDialog
extends JDialog
implements GHelpOkCancelDialog {
    private int option = 1;
    private GSolution document;
    private GSolutionAnswerAction action;
    private GLineSetAnswer problemAnswer;
    private JTextField inputTextField;
    private boolean result = false;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GSolutionLineSetAnswerDialog(Frame ownerFrame, GSolution document, GSolutionAnswerAction action, GLineSetAnswer problemAnswer) {
        super(ownerFrame, true);
        logger.info((Object)"");
        this.document = document;
        this.action = action;
        this.problemAnswer = problemAnswer;
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("Answer", new String[0]));
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new BoxLayout(inputPane, 0));
        inputPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        inputPane.add(new JLabel(GDictionary.get("Answer", new String[0])));
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.inputTextField = GGraphicsFactory.getInstance().createVariableInput(null);
        inputPane.add(this.inputTextField);
        this.getContentPane().add(inputPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
        String[] selectedLines = GLineSetUtils.fromSelection(this.document);
        if (selectedLines.length > 0) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < selectedLines.length; ++i) {
                buf.append(selectedLines[i]);
                if (i >= selectedLines.length - 1) continue;
                buf.append(",");
            }
            this.inputTextField.setText(String.valueOf(buf));
        }
    }

    @Override
    public void ok() {
        List<GPoint3d[]> lines;
        logger.info((Object)"");
        GFigure figure = this.document.getSelectedFigure();
        try {
            lines = GLineSetUtils.fromString(this.inputTextField.getText().trim(), figure);
        }
        catch (Exception exception) {
            GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
            return;
        }
        String figureName = figure.getName();
        this.action.setInput(this.inputTextField.getText().trim(), figureName);
        if (!this.problemAnswer.verify(lines, this.document)) {
            this.dispose();
            GGraphicsFactory.getInstance().showAnswerEvaluation(false);
            return;
        }
        this.option = 0;
        this.result = true;
        this.dispose();
        GGraphicsFactory.getInstance().showAnswerEvaluation(true);
    }

    @Override
    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    @Override
    public int getOption() {
        return this.option;
    }

    public boolean getResult() {
        return this.result;
    }
}

