/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.geocentral.geometria.action.GDocumentHandler;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GToolBarHandler {
    public static final String FILE = "/conf/toolBars.xml";
    private static GToolBarHandler instance;
    private Map<String, JToolBar> toolBars;
    private static Logger logger;

    private GToolBarHandler() {
    }

    public static GToolBarHandler getInstance() {
        if (instance == null) {
            instance = new GToolBarHandler();
        }
        return instance;
    }

    public void init() throws Exception {
        this.loadToolBars();
    }

    public void loadToolBars() throws Exception {
        logger.info((Object)"");
        InputStream in = GToolBarHandler.class.getResourceAsStream(FILE);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Element node = builder.parse(in).getDocumentElement();
        in.close();
        this.toolBars = new LinkedHashMap<String, JToolBar>();
        NodeList ns = node.getElementsByTagName("toolBar");
        for (int i = 0; i < ns.getLength(); ++i) {
            Element n = (Element)ns.item(i);
            String name = n.getElementsByTagName("name").item(0).getTextContent();
            JToolBar toolBar = new JToolBar();
            NodeList nns = n.getElementsByTagName("toolBarButton");
            for (int j = 0; j < nns.getLength(); ++j) {
                Element nn = (Element)nns.item(j);
                String actionName = nn.getElementsByTagName("action").item(0).getTextContent();
                AbstractAction actionHandler = GDocumentHandler.getInstance().getActionHandler(actionName);
                JButton button = new JButton(actionHandler);
                button.setText(null);
                toolBar.add(button);
            }
            this.toolBars.put(name, toolBar);
        }
    }

    public JToolBar getToolBar(String name) {
        return this.toolBars.get(name);
    }

    static {
        logger = Logger.getLogger((String)"net.geocentral.geometria");
    }
}

