/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jtides.BrowserData;
import jtides.JTides;
import jtides.LinkFollower;
import jtides.MyJButton;

public final class HelpBrowser
extends JPanel {
    JTides main;
    Stack outStack;
    Stack backStack;
    String initialURL;
    String initialPath;
    int searchPosition = 0;
    boolean needScroll = false;
    int scrollValue = 0;
    String currentFile = "";
    private JButton BackButton;
    private JButton FindButton;
    private JButton FindNextButton;
    private JButton ForwardButton;
    private JTextArea SearchString;
    public JEditorPane browserWindow;
    private JMenuItem closeMenuItem;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPopupMenu popupMenu;
    public JScrollPane scrollPane;

    public HelpBrowser(JTides jTides) {
        this.main = jTides;
        this.initialURL = "index.html";
        this.outStack = new Stack();
        this.backStack = new Stack();
        this.setLayout(new BorderLayout());
        this.initComponents();
        this.setFocusTraversalKeys(0, new HashSet());
        this.setFocusTraversalKeys(1, new HashSet());
        this.browserWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                HelpBrowser.this.browserKeyHandler(keyEvent);
            }
        });
        this.scrollPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                HelpBrowser.this.scrollKeyHandler(keyEvent);
            }
        });
        this.browserWindow.addHyperlinkListener(new LinkFollower(this));
        this.browserWindow.setEditable(false);
        this.enableButtons();
        this.setPage(this.initialURL);
    }

    @Override
    public void paintComponents(Graphics graphics) {
        super.paintComponents(graphics);
        System.out.println(this.getSize());
    }

    public void setPage(String string) {
        try {
            this.currentFile = string;
            this.browserWindow.setPage(this.main.getClass().getResource("/docs/" + string));
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.processTags(this.browserWindow);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void toPage(String string) {
        if (!this.backStack.empty()) {
            this.backStack.pop();
        }
        this.pushStack(this.outStack);
        this.setPage(string);
    }

    private void pushStack(Stack stack) {
        BrowserData browserData = new BrowserData(this.currentFile, this.scrollPane.getVerticalScrollBar().getValue());
        stack.push(browserData);
        this.enableButtons();
    }

    private void popStack(Stack stack) {
        if (!stack.empty()) {
            BrowserData browserData = (BrowserData)stack.pop();
            this.enableButtons();
            this.setPage(browserData.path);
            this.scrollValue = browserData.scrollPos;
            this.needScroll = true;
            this.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void goBack() {
        if (!this.outStack.empty()) {
            this.pushStack(this.backStack);
            this.popStack(this.outStack);
        }
    }

    private void goForward() {
        if (!this.backStack.empty()) {
            this.pushStack(this.outStack);
            this.popStack(this.backStack);
        }
    }

    private JPanel getContentPane() {
        return this;
    }

    public JEditorPane getBrowserWindow() {
        return this.browserWindow;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.needScroll) {
            this.needScroll = false;
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollValue);
        }
    }

    private void processTags(JEditorPane jEditorPane) {
        this.searchReplaceEditor(jEditorPane, "[basePath]", this.main.basePath);
        String string = System.getProperty("user.home");
        this.searchReplaceEditor(jEditorPane, "[user.home]", string);
        String string2 = "" + this.main.tideComp.siteIndex.size();
        this.searchReplaceEditor(jEditorPane, "[totalSites]", string2);
    }

    private void replaceText(JEditorPane jEditorPane, int n, int n2, String string) {
        jEditorPane.setSelectionStart(n);
        jEditorPane.setSelectionEnd(n2);
        jEditorPane.setEditable(true);
        jEditorPane.replaceSelection(string);
        jEditorPane.setEditable(false);
    }

    private void searchReplaceEditor(JEditorPane jEditorPane, String string, String string2) {
        int n = -1;
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = jEditorPane.getDocument().getLength();
        do {
            ++n;
            try {
                String string3 = jEditorPane.getText(n, n2);
                if (!string3.equals(string)) continue;
                this.replaceText(jEditorPane, n, n + n2, string2);
                n += n3 - n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (n < n4);
        jEditorPane.setCaretPosition(0);
    }

    public void scrollKeyHandler(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 36) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
        } else if (n == 35) {
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
        } else {
            this.main.tabbedPaneManager.handleKey(keyEvent);
        }
    }

    public void browserKeyHandler(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n != 10) {
            this.scrollPane.requestFocusInWindow();
        } else {
            this.main.tabbedPaneManager.handleKey(keyEvent);
        }
    }

    private void enableButtons() {
        this.BackButton.setEnabled(this.outStack.size() > 0);
        this.ForwardButton.setEnabled(this.backStack.size() > 0);
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.closeMenuItem = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.browserWindow = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.BackButton = new MyJButton();
        this.ForwardButton = new MyJButton();
        this.jLabel1 = new JLabel();
        this.SearchString = new JTextArea();
        this.FindButton = new MyJButton();
        this.FindNextButton = new MyJButton();
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.setToolTipText("Close the help browser");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.closeMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.closeMenuItem);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                HelpBrowser.this.formFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                HelpBrowser.this.formFocusLost(focusEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                HelpBrowser.this.formKeyPressed(keyEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.browserWindow.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                HelpBrowser.this.browserWindowFocusLost(focusEvent);
            }
        });
        this.browserWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                HelpBrowser.this.browserWindowKeyPressed(keyEvent);
            }
        });
        this.browserWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                HelpBrowser.this.browserWindowMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                HelpBrowser.this.browserWindowMouseReleased(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.browserWindow);
        this.add((Component)this.scrollPane, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.BackButton.setText("Back");
        this.BackButton.setToolTipText("Go Back");
        this.BackButton.setHorizontalTextPosition(4);
        this.BackButton.setMaximumSize(new Dimension(120, 27));
        this.BackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.BackButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.BackButton, gridBagConstraints);
        this.ForwardButton.setText("Forward");
        this.ForwardButton.setToolTipText("Go Forward");
        this.ForwardButton.setHorizontalTextPosition(4);
        this.ForwardButton.setMaximumSize(new Dimension(35, 27));
        this.ForwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.ForwardButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.ForwardButton, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Search:");
        this.jLabel1.setMinimumSize(new Dimension(60, 16));
        this.jLabel1.setPreferredSize(new Dimension(60, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.SearchString.setBorder(BorderFactory.createEtchedBorder());
        this.SearchString.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                HelpBrowser.this.searchStringKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.SearchString, gridBagConstraints);
        this.FindButton.setText("Find");
        this.FindButton.setToolTipText("Find first case");
        this.FindButton.setHorizontalTextPosition(4);
        this.FindButton.setMaximumSize(new Dimension(35, 27));
        this.FindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.FindButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.FindButton, gridBagConstraints);
        this.FindNextButton.setText("Find Next");
        this.FindNextButton.setToolTipText("Find next case");
        this.FindNextButton.setHorizontalTextPosition(4);
        this.FindNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.FindNextButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.FindNextButton, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
    }

    private void browserWindowFocusLost(FocusEvent focusEvent) {
    }

    private void formFocusLost(FocusEvent focusEvent) {
    }

    private void closeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.main.tabbedPaneManager.close();
    }

    private void browserWindowMouseReleased(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void browserWindowMousePressed(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        this.main.tabbedPaneManager.handleKey(keyEvent);
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.browserWindow.requestFocusInWindow();
    }

    private void searchStringKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            keyEvent.consume();
            this.findText(true);
        } else if (n == 40 || n == 38 || n == 33 || n == 34) {
            this.scrollPane.grabFocus();
        } else {
            this.main.tabbedPaneManager.handleKey(keyEvent);
        }
    }

    private void browserWindowKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.findText(false);
            keyEvent.consume();
        } else {
            this.main.tabbedPaneManager.handleKey(keyEvent);
        }
    }

    private void FindNextButtonActionPerformed(ActionEvent actionEvent) {
        this.findText(false);
    }

    private void FindButtonActionPerformed(ActionEvent actionEvent) {
        this.findText(true);
    }

    private void ForwardButtonActionPerformed(ActionEvent actionEvent) {
        this.goForward();
    }

    private void BackButtonActionPerformed(ActionEvent actionEvent) {
        this.goBack();
    }

    private void handleMouse(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.isVisible()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void findText(boolean bl) {
        String string = this.browserWindow.getText();
        String string2 = this.SearchString.getText();
        if (string2.length() > 0) {
            boolean bl2;
            if (bl) {
                this.searchPosition = 0;
            }
            int n = this.searchPosition - 1;
            int n2 = string2.length();
            int n3 = this.browserWindow.getDocument().getLength();
            do {
                ++n;
                String string3 = "";
                try {
                    string3 = this.browserWindow.getText(n, n2);
                    bl2 = string3.equals(string2);
                }
                catch (Exception exception) {
                    bl2 = false;
                }
            } while (!bl2 && n < n3);
            if (bl2) {
                int n4 = n + string2.length();
                this.browserWindow.setCaretPosition(n);
                this.browserWindow.moveCaretPosition(n4);
                this.browserWindow.requestFocusInWindow();
                this.searchPosition = n4;
            } else {
                this.searchPosition = 0;
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

