/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import jtides.ExampleFileFilter;
import jtides.JTides;
import jtides.MyJButton;
import jtides.ThreadStopper;
import jtides.TideConstants;
import jtides.TideEvent;
import jtides.TidesDoc;

public final class TidesDatabase
extends JPanel {
    JTides main;
    TidesDoc theDoc;
    GregorianCalendar startTime = null;
    GregorianCalendar endTime = null;
    boolean useInterval = false;
    boolean includeSun = false;
    boolean writingDatabase = false;
    long timeInterval = 1L;
    Thread workThread = null;
    ThreadStopper threadStopper;
    BoxData[] timeSpec = new BoxData[]{new BoxData("1 Second", 1L), new BoxData("2 Seconds", 2L), new BoxData("5 Seconds", 5L), new BoxData("10 Seconds", 10L), new BoxData("30 Seconds", 30L), new BoxData("1 Minute", 60L), new BoxData("2 Minutes", 120L), new BoxData("5 Minutes", 300L), new BoxData("10 Minutes", 600L), new BoxData("15 Minutes", 900L), new BoxData("30 Minutes", 1800L), new BoxData("1 Hour", 3600L), new BoxData("2 Hours", 7200L), new BoxData("4 Hours", 14400L), new BoxData("8 Hours", 28800L), new BoxData("1 Day", 86400L), new BoxData("2 Days", 172800L), new BoxData("4 Days", 345600L), new BoxData("7 Days", 604800L), new BoxData("10 Days", 864000L)};
    private JButton CancelButton;
    private JButton CreateButton;
    private JComboBox EndDayBox;
    private JComboBox EndMonthBox;
    private JComboBox EndYearBox;
    private JCheckBox IncludeSunDataButton;
    private JComboBox IntervalBox;
    private JComboBox StartDayBox;
    private JComboBox StartMonthBox;
    private JComboBox StartYearBox;
    private JLabel StatusBar;
    private JRadioButton TideHighsLowsButton;
    private JRadioButton TideIntervalsButton;
    private JPanel controlPanel;
    private JPanel dataTypePanel;
    private JComboBox delimComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JProgressBar jProgressBar1;
    private JPanel timeIntervalPanel;

    public TidesDatabase(JTides jTides) {
        this.main = jTides;
        this.initComponents();
        this.threadStopper = new ThreadStopper();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.TideHighsLowsButton);
        buttonGroup.add(this.TideIntervalsButton);
        this.theDoc = this.getCurrentDoc();
        this.initFields();
        this.presetFields();
    }

    public TidesDoc getCurrentDoc() {
        return this.main.tabbedPaneManager.getSelectedDoc();
    }

    private void initFields() {
        int n;
        this.delimComboBox.addItem("Tab");
        this.delimComboBox.addItem("Comma");
        for (n = 0; n < TideConstants.monthNames.length; ++n) {
            this.StartMonthBox.addItem(TideConstants.monthNames[n]);
            this.EndMonthBox.addItem(TideConstants.monthNames[n]);
        }
        for (n = 1; n <= 31; ++n) {
            this.StartDayBox.addItem("" + n);
            this.EndDayBox.addItem("" + n);
        }
        if (this.theDoc != null && this.theDoc.type == 0) {
            for (n = 0; n < this.theDoc.siteSet.equMax; ++n) {
                this.StartYearBox.addItem("" + (this.theDoc.siteSet.startYear + n));
                this.EndYearBox.addItem("" + (this.theDoc.siteSet.startYear + n));
            }
        }
    }

    private void presetFields() {
        if (this.theDoc != null && this.theDoc.type == 0) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(this.theDoc.panel.getCurrentCal().getTime());
            this.StartMonthBox.setSelectedIndex(gregorianCalendar.get(2));
            this.StartDayBox.setSelectedIndex(gregorianCalendar.get(5) - 1);
            this.StartYearBox.setSelectedIndex(gregorianCalendar.get(1) - this.theDoc.siteSet.startYear);
            gregorianCalendar.add(2, 1);
            this.EndMonthBox.setSelectedIndex(gregorianCalendar.get(2));
            this.EndDayBox.setSelectedIndex(gregorianCalendar.get(5) - 1);
            this.EndYearBox.setSelectedIndex(gregorianCalendar.get(1) - this.theDoc.siteSet.startYear);
        }
        for (int i = 0; i < this.timeSpec.length; ++i) {
            this.IntervalBox.addItem(this.timeSpec[i].name);
        }
        this.IntervalBox.setSelectedIndex(10);
        this.TideHighsLowsButton.setSelected(true);
        this.IncludeSunDataButton.setSelected(false);
    }

    private void createDatabase() {
        String string = this.delimComboBox.getSelectedItem().equals("Tab") ? "\t" : ",";
        this.theDoc = this.getCurrentDoc();
        if (this.theDoc != null && this.theDoc.type == 0) {
            this.startTime = new GregorianCalendar(this.StartYearBox.getSelectedIndex() + this.theDoc.siteSet.startYear, this.StartMonthBox.getSelectedIndex(), this.StartDayBox.getSelectedIndex() + 1);
            this.endTime = new GregorianCalendar(this.EndYearBox.getSelectedIndex() + this.theDoc.siteSet.startYear, this.EndMonthBox.getSelectedIndex(), this.EndDayBox.getSelectedIndex() + 1);
            this.endTime.add(6, 1);
            this.useInterval = this.TideIntervalsButton.isSelected();
            this.timeInterval = this.timeSpec[this.IntervalBox.getSelectedIndex()].value;
            this.includeSun = this.IncludeSunDataButton.isSelected();
            JFileChooser jFileChooser = new JFileChooser();
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
            exampleFileFilter.addExtension("csv");
            exampleFileFilter.addExtension("tsv");
            exampleFileFilter.addExtension("txt");
            exampleFileFilter.setDescription("CSV database Files");
            jFileChooser.setFileFilter(exampleFileFilter);
            jFileChooser.setDialogTitle("Save Database File");
            if (this.main.configValues.defaultDatabaseDirectory.length() > 0) {
                jFileChooser.setCurrentDirectory(new File(this.main.configValues.defaultDatabaseDirectory));
            }
            String string2 = this.theDoc.siteSet.name;
            string2 = this.main.tideComp.srchRplc(string2, " ", "_");
            string2 = this.main.tideComp.srchRplc(string2, ",", "_");
            string2 = this.main.tideComp.srchRplc(string2, "__", "_");
            String string3 = string.equals("\t") ? ".tsv" : ".csv";
            jFileChooser.setSelectedFile(new File(string2 + string3));
            int n = jFileChooser.showSaveDialog(this.main);
            if (n == 0) {
                try {
                    this.main.configValues.defaultDatabaseDirectory = jFileChooser.getCurrentDirectory().getCanonicalPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                File file = jFileChooser.getSelectedFile();
                this.writeDatabase(this.theDoc, file.getPath(), string);
            }
        }
    }

    private void writeDatabase(final TidesDoc tidesDoc, final String string, final String string2) {
        if (!this.writingDatabase) {
            this.writingDatabase = true;
            this.threadStopper.stop = false;
            this.workThread = new Thread(){

                @Override
                public void run() {
                    TidesDatabase.this.writeDatabaseThread(tidesDoc, string, string2);
                }
            };
            this.workThread.start();
        }
    }

    private void writeDatabaseThread(TidesDoc tidesDoc, String string, String string2) {
        try {
            long l;
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            Vector vector = new Vector();
            long l2 = this.startTime.getTime().getTime() / 1000L;
            long l3 = this.endTime.getTime().getTime() / 1000L;
            String string3 = tidesDoc.siteSet.current ? "Current" : "Tide";
            String string4 = this.main.tideComp.getUnitsTag(tidesDoc.siteSet);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UTCDate");
            stringBuffer.append(string2);
            stringBuffer.append("UTCTime");
            stringBuffer.append(string2);
            stringBuffer.append("Date");
            stringBuffer.append(string2);
            stringBuffer.append("Time");
            stringBuffer.append(string2);
            stringBuffer.append(string3);
            if (!this.useInterval) {
                stringBuffer.append(string2);
                stringBuffer.append("Type");
            }
            stringBuffer.append(string2);
            stringBuffer.append("Units");
            if (this.includeSun) {
                stringBuffer.append(string2);
                stringBuffer.append("TwilightBegin");
                stringBuffer.append(string2);
                stringBuffer.append("Sunrise");
                stringBuffer.append(string2);
                stringBuffer.append("Transit");
                stringBuffer.append(string2);
                stringBuffer.append("Sunset");
                stringBuffer.append(string2);
                stringBuffer.append("TwilightEnd");
                stringBuffer.append(string2);
                stringBuffer.append("DaylightTime");
            }
            this.writeLine(stringBuffer.toString(), dataOutputStream);
            this.startProgressBar(l2, l3, 0L, "Creating Tidal Data");
            if (!this.useInterval) {
                l = this.main.tideComp.getNextEventTime(tidesDoc.siteSet, l2, false);
                long l4 = this.main.tideComp.getNextEventTime(tidesDoc.siteSet, l3, true);
                vector = this.main.tideComp.predictTideEvents(tidesDoc.siteSet, l, l4, l2, l3, this.jProgressBar1, this.threadStopper);
            } else {
                for (l = l2; l <= l3 && !this.threadStopper.stop; l += this.timeInterval) {
                    this.updateProgressBar(l);
                    TideEvent tideEvent = new TideEvent();
                    tideEvent.height = this.main.tideComp.timeToTide(tidesDoc.siteSet, l, true);
                    tideEvent.t = l;
                    vector.add(tideEvent);
                }
                this.stopProgressBar();
            }
            this.startProgressBar(0L, vector.size(), 0L, "Formatting and Writing Database");
            for (int i = 0; i < vector.size() && !this.threadStopper.stop; ++i) {
                this.updateProgressBar(i);
                String string5 = this.main.tideComp.formatDataString(tidesDoc, i, vector, true, false, string4, true, this.includeSun, !this.useInterval, string2);
                this.writeLine(string5, dataOutputStream);
            }
            dataOutputStream.close();
            this.stopProgressBar();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.writingDatabase = false;
        this.threadStopper.stop = false;
        this.stopProgressBar();
    }

    public void writeLine(String string, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeBytes(string + TideConstants.SYSTEM_EOL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startProgressBar(long l, long l2, long l3, String string) {
        this.jProgressBar1.setMinimum((int)l);
        this.jProgressBar1.setMaximum((int)l2);
        this.jProgressBar1.setValue((int)l2);
        this.StatusBar.setText(string);
    }

    public void updateProgressBar(long l) {
        this.jProgressBar1.setValue((int)l);
    }

    public void stopProgressBar() {
        this.jProgressBar1.setValue(this.jProgressBar1.getMinimum());
        this.StatusBar.setText("Done");
    }

    private void initComponents() {
        this.timeIntervalPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.StartMonthBox = new JComboBox();
        this.StartDayBox = new JComboBox();
        this.StartYearBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.EndMonthBox = new JComboBox();
        this.EndDayBox = new JComboBox();
        this.EndYearBox = new JComboBox();
        this.jLabel8 = new JLabel();
        this.dataTypePanel = new JPanel();
        this.TideHighsLowsButton = new JRadioButton();
        this.TideIntervalsButton = new JRadioButton();
        this.IntervalBox = new JComboBox();
        this.IncludeSunDataButton = new JCheckBox();
        this.delimComboBox = new JComboBox();
        this.jLabel7 = new JLabel();
        this.controlPanel = new JPanel();
        this.CreateButton = new MyJButton();
        this.CancelButton = new MyJButton();
        this.jProgressBar1 = new JProgressBar();
        this.StatusBar = new JLabel();
        this.setLayout(new GridBagLayout());
        this.timeIntervalPanel.setBorder(BorderFactory.createTitledBorder("Choose Time Interval"));
        this.timeIntervalPanel.setLayout(new GridLayout(3, 4));
        this.timeIntervalPanel.add(this.jLabel1);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Month");
        this.timeIntervalPanel.add(this.jLabel2);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Day");
        this.timeIntervalPanel.add(this.jLabel3);
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Year");
        this.timeIntervalPanel.add(this.jLabel4);
        this.jLabel5.setText("Start");
        this.timeIntervalPanel.add(this.jLabel5);
        this.timeIntervalPanel.add(this.StartMonthBox);
        this.timeIntervalPanel.add(this.StartDayBox);
        this.timeIntervalPanel.add(this.StartYearBox);
        this.jLabel6.setText("End");
        this.timeIntervalPanel.add(this.jLabel6);
        this.timeIntervalPanel.add(this.EndMonthBox);
        this.timeIntervalPanel.add(this.EndDayBox);
        this.timeIntervalPanel.add(this.EndYearBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.timeIntervalPanel, gridBagConstraints);
        this.jLabel8.setFont(new Font("Dialog", 1, 11));
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText("Create Database");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.dataTypePanel.setBorder(BorderFactory.createTitledBorder(null, "Choose Data Type", 1, 0));
        this.dataTypePanel.setLayout(new GridBagLayout());
        this.TideHighsLowsButton.setText("Tide/current maxima/minima/slacks only");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dataTypePanel.add((Component)this.TideHighsLowsButton, gridBagConstraints);
        this.TideIntervalsButton.setText("Tide/current at intervals of:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dataTypePanel.add((Component)this.TideIntervalsButton, gridBagConstraints);
        this.IntervalBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TidesDatabase.this.IntervalBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dataTypePanel.add((Component)this.IntervalBox, gridBagConstraints);
        this.IncludeSunDataButton.setText("Include sun rise/set/twilight data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dataTypePanel.add((Component)this.IncludeSunDataButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dataTypePanel.add((Component)this.delimComboBox, gridBagConstraints);
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("Choose database delimiter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dataTypePanel.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.dataTypePanel, gridBagConstraints);
        this.controlPanel.setLayout(new GridBagLayout());
        this.CreateButton.setText("Create");
        this.CreateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidesDatabase.this.CreateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.controlPanel.add((Component)this.CreateButton, gridBagConstraints);
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidesDatabase.this.CancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.controlPanel.add((Component)this.CancelButton, gridBagConstraints);
        this.jProgressBar1.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.controlPanel.add((Component)this.jProgressBar1, gridBagConstraints);
        this.StatusBar.setText("Done");
        this.StatusBar.setToolTipText("The current operation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.controlPanel.add((Component)this.StatusBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.controlPanel, gridBagConstraints);
    }

    private void IntervalBoxItemStateChanged(ItemEvent itemEvent) {
        this.TideIntervalsButton.setSelected(true);
    }

    private void CancelButtonActionPerformed(ActionEvent actionEvent) {
        if (this.workThread != null) {
            this.threadStopper.stop = true;
        }
    }

    private void CreateButtonActionPerformed(ActionEvent actionEvent) {
        this.createDatabase();
    }

    final class BoxData {
        String name;
        long value;

        BoxData(String string, long l) {
            this.name = string;
            this.value = l;
        }
    }
}

