/*
 * 01/09/2002 - 20:43:57
 *
 * PluginDownloader.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.pluginstuff;


import info.jdictionary.JDictionary;
import info.jdictionary.IconBank;
import info.jdictionary.ImageBank;
import info.jdictionary.FileDownloader;
import info.jdictionary.gui.NetworkErrorPanel;
import info.jdictionary.gui.PluginInfoSheetPanel;
import info.jdictionary.events.PluginStructureChangeEvent;
import info.jdictionary.listeners.PluginStructureChangeListener;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;


public class PluginDownloader extends JPanel implements Runnable {
    JDictionary jDictionary;
    PluginManager pluginManager;
    ArrayList pluginInfoPanels = new ArrayList();
    PluginInfoAndDownloadPanel highlightedPluginInfoPanel;
    HashSet downloadQuene = new HashSet();
    JPanel availablePluginsPanel = new JPanel();
    JPanel pluginInfoOutputPanel = new JPanel();
    JPanel tipsPanel = new JPanel();
    JPanel informationPanel = new JPanel();
    JLabel headerLabel = new JLabel();
    JLabel messageLabel;
    ImageIcon spacerLine = ImageBank.getImageByName("Spacer.jpg");
    ImageIcon headerImage = ImageBank.getImageByName("DownloadHeader.png");
    JScrollPane pluginInfoOutputScrollPane = new JScrollPane();
    JScrollPane informationScrollPane = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BoxLayout boxLayout1 = new BoxLayout(this, BoxLayout.Y_AXIS);
    BoxLayout boxLayout2 = new BoxLayout(pluginInfoOutputPanel, BoxLayout.Y_AXIS);
    BoxLayout boxLayout3 = new BoxLayout(informationPanel, BoxLayout.Y_AXIS);
    boolean success;

    public PluginDownloader(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        this.pluginManager = jDictionary.getPluginManager();
        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        setLayout(boxLayout1);
        setBackground(Color.white);
        setAlignmentX((float) 0.0);
        setMinimumSize(new Dimension(400, 300));
        setPreferredSize(new Dimension(400, 300));

        availablePluginsPanel.setLayout(borderLayout1);
        availablePluginsPanel.setBackground(Color.white);
        availablePluginsPanel.setAlignmentX((float) 0.0);
        availablePluginsPanel.setMinimumSize(new Dimension(300, 100));
        availablePluginsPanel.setPreferredSize(new Dimension(1000, 1000));
        availablePluginsPanel.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("AvailPlugins")));
        availablePluginsPanel.add(pluginInfoOutputScrollPane, BorderLayout.CENTER);

        tipsPanel.setBackground(Color.white);
        tipsPanel.setAlignmentX((float) 0.0);
        tipsPanel.setMinimumSize(new Dimension(0, 80));
        tipsPanel.setPreferredSize(new Dimension(0, 160));
        tipsPanel.setLayout(borderLayout3);
        tipsPanel.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("Tips")));
        tipsPanel.add(informationScrollPane);

        headerLabel.setBackground(Color.white);
        headerLabel.setMinimumSize(new Dimension(300, 65));
        headerLabel.setPreferredSize(new Dimension(500, 65));
        headerLabel.setIcon(headerImage);

        pluginInfoOutputScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        pluginInfoOutputScrollPane.getViewport().setBackground(Color.white);
        informationScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        informationScrollPane.getViewport().add(informationPanel, null);
        pluginInfoOutputScrollPane.getViewport().add(pluginInfoOutputPanel, null);

        pluginInfoOutputPanel.setBackground(Color.white);
        pluginInfoOutputPanel.setLayout(borderLayout2);

        informationPanel.setLayout(boxLayout3);
        informationPanel.setBackground(Color.white);

        addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip1"), IconBank.bulb, 0));
        addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip2"), IconBank.bulb, 0));

        add(headerLabel, null);
        add(availablePluginsPanel, null);
        add(Box.createRigidArea(new Dimension(0, 10)));
        add(tipsPanel, null);
    }


    public void run() {
        addToOutputPanel(JDictionary.getString("DownloadingInfo"), IconBank.hourGlass);
        //Object[] sheets = null; for testing
        Object[] sheets = downloadPluginInfoSheets();
        if (sheets != null) {
            showPluginInfoPanels(sheets);
            addToInformationPanel(new JLabel(JDictionary.getString("AvailPluginsPref") + sheets.length + JDictionary.getString("AvailPluginsPostf"), IconBank.info, 0));
            success = true;
            checkDownloadQuene();
        } else {
            addToOutputPanel(JDictionary.getString("NetError"), IconBank.caution);
            addToInformationPanel(new NetworkErrorPanel(jDictionary));
            addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip3"), IconBank.bulb, 0));
            }
    }


    Object[] downloadPluginInfoSheets() {
        URL url = null;
        Object[] sheets = null;
        try {
            url = new URL(JDictionary.getString("SourceforgeDownloadServerURL") + "/" + JDictionary.getString("InfoSheetsFile") + "_" + JDictionary.getLanguage());
            sheets = PluginInfoSheet.CreateInfoSheets(url);
            if (sheets != null)
                return sheets;

            url = new URL(JDictionary.getString("SourceforgeDownloadServerURL") + "/" + JDictionary.getString("InfoSheetsFile"));
            sheets = PluginInfoSheet.CreateInfoSheets(url);
            if (sheets != null)
                return sheets;

            url = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("InfoSheetsFile") + "_" + JDictionary.getLanguage());
            sheets = PluginInfoSheet.CreateInfoSheets(url);
            if (sheets != null)
                return sheets;

            url = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("InfoSheetsFile"));
            sheets = PluginInfoSheet.CreateInfoSheets(url);
            if (sheets != null)
                return sheets;


        }
        catch(java.net.MalformedURLException e) {}
        return sheets;
    }


    void showPluginInfoPanels(final Object[] sheets) {
        //making the panels
        for (int n = 0; n < sheets.length; n++) {
            PluginInfoAndDownloadPanel pluginInfoAndDownloadPanel = new PluginInfoAndDownloadPanel(jDictionary, (PluginInfoSheet) sheets[n]);
            pluginInfoPanels.add(pluginInfoAndDownloadPanel);
        }
        //showing the panels
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                pluginInfoOutputPanel.removeAll();
                pluginInfoOutputPanel.setLayout(boxLayout2);

                for (int n = 0; n < pluginInfoPanels.size(); n++) {
                    pluginInfoOutputPanel.add((PluginInfoAndDownloadPanel)pluginInfoPanels.get(n));
                    if (n < sheets.length - 1) {
                        JLabel spacer = new JLabel(spacerLine);
                        spacer.setPreferredSize(new Dimension(200, 1));
                        pluginInfoOutputPanel.add(spacer);
                    }
                }
                pluginInfoOutputPanel.validate();
                pluginInfoOutputScrollPane.validate();
                pluginInfoOutputPanel.repaint();
            }
        });
    }


    void addToInformationPanel(final JComponent label) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                label.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
                informationPanel.add(label);
                informationScrollPane.validate();
                informationScrollPane.repaint();
                showComponentOnScrollPane(informationScrollPane, label, false);
            }
        });
    }


    public void updateInfoPanelsState() {
        for (int n = 0; n < pluginInfoPanels.size(); n++)
            ((PluginInfoAndDownloadPanel) pluginInfoPanels.get(n)).updateState();
    }


    public void addToOutputPanel(String message, ImageIcon icon) {
        messageLabel = new JLabel(message, icon, 0);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                pluginInfoOutputPanel.removeAll();
                pluginInfoOutputPanel.add(messageLabel);
                pluginInfoOutputPanel.validate();
            }
        });
    }


    public void addToOutputPanel(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                pluginInfoOutputPanel.removeAll();
                pluginInfoOutputPanel.add(component);
                pluginInfoOutputPanel.validate();
            }
        });
    }


    public void download(String fileName) {
        if(!success) {
            downloadQuene.add(fileName);
            return;
        }

        Iterator it;
        if(pluginInfoPanels != null && pluginInfoPanels.size() > 0) {
            it = pluginInfoPanels.iterator();
            while(it.hasNext()) {
                PluginInfoAndDownloadPanel p = (PluginInfoAndDownloadPanel)it.next();
                if(p.getSheet().getFileName().equals(fileName)) {
                    if(!p.downloading)
                        p.startDownload();
                    showComponentOnScrollPane(pluginInfoOutputScrollPane, p, true);
                    p.highlight(10000);
                    return;
                }
            }
        }
    }


    void checkDownloadQuene() {
        if(downloadQuene.size() > 0) {
            Iterator it = downloadQuene.iterator();
            while(it.hasNext())
                download((String)it.next());
        downloadQuene.clear();
        }
    }


    void showComponentOnScrollPane(final JScrollPane scrollPane, final JComponent component, final boolean highlight) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                Point point = new Point(component.getX(), component.getY());
                scrollPane.getViewport().setViewPosition(point);
                scrollPane.validate();
                scrollPane.repaint();
            }
        });
    }


    public boolean isSuccess() {
      return success;
    }


//--------------------------------------------------------------------------------------------


    class PluginInfoAndDownloadPanel extends JPanel {
        JDictionary jDictionary;
        boolean downloading = false;
        boolean activated = true;
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        BoxLayout boxLayout1 = new BoxLayout(this, BoxLayout.X_AXIS);
        BoxLayout boxLayout2 = new BoxLayout(jPanel1, BoxLayout.Y_AXIS);
        BoxLayout boxLayout3 = new BoxLayout(jPanel3, BoxLayout.Y_AXIS);
        JButton button = new JButton();
        int highlightCounter = 0;
        PluginInfoSheet sheet;
        PluginInfoSheetPanel sheetPanel;
        Downloader downloader;
        JProgressBar progressBar;


        public PluginInfoAndDownloadPanel(JDictionary jDictionary, PluginInfoSheet sheet) {



            this.jDictionary = jDictionary;
            this.sheet = sheet;
            sheetPanel = new PluginInfoSheetPanel(sheet);

            pluginManager.addPluginStructureChangeListener(new PluginStructureChangeListener() {
                public void pluginAdded(PluginStructureChangeEvent e) {
                    updateState();
                }
                public void pluginRemoved(PluginStructureChangeEvent e) {
                    updateState();
                }
            });

            try {
                jbInit();
            } catch (Exception e) {
                e.printStackTrace();
            }
            updateState();
        }


        private void jbInit() throws Exception {
            setBackground(Color.white);
            setPreferredSize(new Dimension(370, 85));
            setMinimumSize(new Dimension(300, 85));
            setLayout(boxLayout1);
            setBorder(BorderFactory.createEmptyBorder(10, 3, 10, 3));
            setAlignmentX((float) 0.0);

            jPanel1.setBackground(new Color(255, 255, 255));
            jPanel1.setPreferredSize(new Dimension(160, 55));
            jPanel1.setLayout(boxLayout2);

            jPanel2.setBackground(new Color(255, 255, 255));

            jPanel3.setBackground(new Color(255, 255, 255));
            jPanel3.setAlignmentX((float)0.0);
            jPanel3.setLayout(boxLayout3);

            jScrollPane1.setPreferredSize(new Dimension(300, 70));
            jScrollPane1.setMinimumSize(new Dimension(100, 70));

            button.setAlignmentX((float)0.0);
            button.setMargin(new Insets(0, 3, 0, 3));
            button.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    button_actionPerformed(e);
                }
            });

            jPanel1.add(jPanel3);
            jPanel1.add(Box.createVerticalGlue());
            jPanel1.add(button);
            jPanel2.add(jPanel1);
            add(jScrollPane1);
            add(jPanel2);
            jScrollPane1.getViewport().add(sheetPanel, 0);
        }


        PluginInfoSheet getSheet() {
            return sheet;
        }


        void startDownload() {
            if(activated == false) {
                jDictionary.getPluginManager().setActive(sheet.getFileName());
                    pluginManager.scanPlugins();
                return;
            }
            if (downloading) {
                downloading = false;
                downloader.terminate();
                return;
            }
            if (jDictionary.getPluginManager().isItAvailable(sheet.getFileName(), true))
                return;
            addToInformationPanel(new JLabel(JDictionary.getString("DownloadingFile") + sheet.getName(), IconBank.FolderIn, 0));
            downloading = true;
            showProgressBar();
            downloader = new Downloader();
            downloader.start();
            updateState();
        }


        void showProgressBar() {
            progressBar = new JProgressBar();
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    progressBar.setPreferredSize(new Dimension(button.getWidth(), button.getHeight()));
                    progressBar.setStringPainted(true);
                    jPanel3.removeAll();
                    jPanel3.add(progressBar);
                    jPanel1.validate();
                    jPanel1.repaint();
                }
            });
        }


        synchronized void updateState() {
            SwingUtilities.invokeLater(new Runnable() {
                                           public void run() {
                                              if (downloading) {
                                                   button.setIcon(IconBank.stop);
                                                   button.setText(JDictionary.getString("StopDownloading"));
                                                   //jPanel1.validate();
                                                   //jPanel1.repaint();
                                                   return;
                                               }
                                              jPanel3.removeAll();
                                              JLabel label;
                                              activated = true;
                                           if (sheet.getMinJDictionaryVersion() != null && (Float.parseFloat(sheet.getMinJDictionaryVersion()) > JDictionary.getJDictionaryVersion())) {
                                                  label = new JLabel(JDictionary.getString("JDict") + sheet.getMinJDictionaryVersion() + JDictionary.getString("Needed"), IconBank.info, 0);
                                                  label.setToolTipText(JDictionary.getString("PleseUpgr") + sheet.getMinJDictionaryVersion());
                                                  jPanel3.add(label);
                                                  button.setToolTipText(JDictionary.getString("PleseUpgr") + sheet.getMinJDictionaryVersion());
                                                  button.setText(JDictionary.getString("DownInst"));
                                                  button.setIcon(IconBank.FolderIn);
                                                  button.setEnabled(false);
                                          }
                                          else
                                              if (pluginManager.isPluginFileLoadedWithName(sheet.getFileName())) {
                                                  label = new JLabel(JDictionary.getString("AlreadyInstalled"), IconBank.info, 0);
                                                  jPanel3.add(label);
                                                  button.setText(JDictionary.getString("DownInst"));
                                                  button.setIcon(IconBank.FolderIn);
                                                  button.setEnabled(false);
                                              }
                                              else
                                                  if(pluginManager.isItAvailable(sheet.getFileName(), true)) {
                                                      activated = false;
                                                      label = new JLabel(JDictionary.getString("InstalledButDeactivated"), IconBank.info, 0);
                                                      jPanel3.add(label);
                                                      button.setText(JDictionary.getString("Activate"));
                                                      button.setIcon(IconBank.plug);
                                                      button.setEnabled(true);
                                                  }
                                              else
                                                  if(pluginManager.isItAvailable(sheet.getFileName(), false) && pluginManager.isThereNewerPluginFileAvailable(sheet.getFileName())) {
                                                      label = new JLabel(JDictionary.getString("YouHaveNewerVersion"), IconBank.info, 0);
                                                      jPanel3.add(label);
                                                      button.setText(JDictionary.getString("DownInst"));
                                                      button.setIcon(IconBank.FolderIn);
                                                      button.setEnabled(false);
                                                    }
                                              else {

                                                  if (pluginManager.isItAvailable(sheet.getFileName(), false) && pluginManager.isThereNewerPluginFileAvailable(sheet.getFileName()) == false) {
                                                      label = new JLabel(JDictionary.getString("NewerAvailable"), IconBank.FingerUp, 0);
                                                      button.setText(JDictionary.getString("DownUpgr"));
                                                  }
                                                  else {
                                                      label = new JLabel(JDictionary.getString("NotInstalled"), IconBank.info, 0);
                                                      button.setText(JDictionary.getString("DownInst"));
                                                  }
                                                  jPanel3.add(label);
                                                  button.setIcon(IconBank.FolderIn);
                                                  button.setEnabled(true);
                                               }
                                               jPanel1.validate();
                                               jPanel1.repaint();
                                           }
                                       }
                                      );
        }


         void button_actionPerformed(ActionEvent e) {
            startDownload();
        }

        void highlight(boolean highlight) {
            if(highlight)
                highlightCounter++;
            else
                highlightCounter--;
            if(highlightCounter > 0) {
                if(!getBackground().equals(Color.orange))
                    setBackground(Color.orange);
                return;
            }
            if(highlightCounter <= 0) {
                if(!getBackground().equals(Color.white))
                    setBackground(Color.white);
                return;
            }
    }

        void highlight(final int time) {
            highlight(true);
            new Thread() {
                public void run() {
                    try {
                        Thread.sleep(time);
                    }
                    catch(java.lang.InterruptedException e) {}
                    highlight(false);
                }
            }.start();
        }




//--------------------------------------------------------------------------------------------


        class Downloader extends Thread {

            FileDownloader fileDownloader = new FileDownloader();
            PluginDeployer deployer = new PluginDeployer(jDictionary);
            byte[] b;
            boolean stop = false;
            URL url = null;


            public void terminate() {
                fileDownloader.terminate();
                addToInformationPanel(new JLabel(JDictionary.getString("DownStopPref") + sheet.getName() + JDictionary.getString("DownStopPost"), IconBank.stop, 0));
                stop = true;
                updateState();
            }


            public void run() {
                try {
                    url = new URL(sheet.getURL());
                }
                catch (java.net.MalformedURLException ex) {}
                catch (java.io.IOException ex) {}

                b = fileDownloader.download(url, progressBar);
                if(!stop)
                    if (b != null) { //this means that the download process was successfull.
                        addToInformationPanel(new JLabel(JDictionary.getString("Installing") + sheet.getName(), IconBank.info, 0));
                        button.setEnabled(false);
                        deployer.deploy(b, sheet.getFileName());
                        pluginManager.setActive(sheet.getFileName());

                        pluginManager.addPluginStructureChangeListener(new PluginStructureChangeListener() {
                            public void pluginRemoved(PluginStructureChangeEvent e) {}
                            public void pluginAdded(PluginStructureChangeEvent e) {
                                if (pluginManager.isItInstalled(sheet))
                                    addToInformationPanel(new JLabel(sheet.getName() + JDictionary.getString("ReadyToUse"), IconBank.ThumbUp, 0));
                                else
                                    addToInformationPanel(new JLabel(JDictionary.getString("ErrorAtInstall") + sheet.getName(), IconBank.caution, 0));
                                pluginManager.removePluginStructureChangeListener(this);
                                updateState();
                            }
                        });
                        pluginManager.scanPlugins();
                    }
                    else
                        addToInformationPanel(new JLabel(JDictionary.getString("ErrorAtDownload") + sheet.getName(), IconBank.caution, 0));
                    downloading = false;
            }
        }
    }
}