/*
 * Decompiled with CFR 0.152.
 */
package csheets.core;

import csheets.core.IllegalValueTypeException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Value
implements Comparable<Value>,
Serializable {
    private static final long serialVersionUID = 7140236908025236588L;
    private Serializable value;
    private Type type = Type.UNDEFINED;

    public Value() {
    }

    public Value(Number number) {
        this.type = Type.NUMERIC;
        this.value = (number instanceof Float || number instanceof Double) && number.doubleValue() == (double)number.longValue() ? (Number)number.longValue() : (Number)number;
    }

    public Value(String string) {
        this.type = Type.TEXT;
        this.value = string;
    }

    public Value(Boolean bl) {
        this.type = Type.BOOLEAN;
        this.value = bl;
    }

    public Value(Date date) {
        this.type = Type.DATE;
        this.value = date;
    }

    public Value(Value[] valueArray) {
        this(new Value[][]{valueArray});
    }

    public Value(Value[][] valueArray) {
        this.type = Type.MATRIX;
        this.value = valueArray;
    }

    public Value(Throwable throwable) {
        this.type = Type.ERROR;
        this.value = throwable;
    }

    public final Object toAny() {
        return this.value;
    }

    public final Type getType() {
        return this.type;
    }

    public final boolean isOfType(Type type) {
        return this.type == type;
    }

    public Number toNumber() throws IllegalValueTypeException {
        if (this.type == Type.NUMERIC) {
            return (Number)this.value;
        }
        throw new IllegalValueTypeException(this, Type.NUMERIC);
    }

    public double toDouble() throws IllegalValueTypeException {
        return this.toNumber().doubleValue();
    }

    public String toText() throws IllegalValueTypeException {
        if (this.type == Type.TEXT) {
            return (String)((Object)this.value);
        }
        throw new IllegalValueTypeException(this, Type.TEXT);
    }

    public Boolean toBoolean() throws IllegalValueTypeException {
        if (this.type == Type.BOOLEAN) {
            return (Boolean)this.value;
        }
        throw new IllegalValueTypeException(this, Type.BOOLEAN);
    }

    public Date toDate() throws IllegalValueTypeException {
        if (this.type == Type.DATE) {
            return (Date)this.value;
        }
        throw new IllegalValueTypeException(this, Type.DATE);
    }

    public Value[][] toMatrix() throws IllegalValueTypeException {
        if (this.type == Type.MATRIX) {
            return (Value[][])this.value;
        }
        throw new IllegalValueTypeException(this, Type.MATRIX);
    }

    public Throwable toError() throws IllegalValueTypeException {
        if (this.type == Type.ERROR) {
            return (Throwable)this.value;
        }
        throw new IllegalValueTypeException(this, Type.ERROR);
    }

    @Override
    public int compareTo(Value value) {
        if (this.type == value.getType()) {
            try {
                switch (this.type) {
                    case NUMERIC: {
                        return Double.valueOf(this.toDouble()).compareTo(value.toDouble());
                    }
                    case TEXT: {
                        return this.toText().compareTo(value.toText());
                    }
                    case BOOLEAN: {
                        return this.toBoolean().compareTo(value.toBoolean());
                    }
                    case DATE: {
                        return this.toDate().compareTo(value.toDate());
                    }
                    case MATRIX: {
                        return Arrays.hashCode((Object[])value.toAny()) - Arrays.hashCode((Object[])this.value);
                    }
                }
                return 0;
            }
            catch (IllegalValueTypeException illegalValueTypeException) {
                return -1;
            }
        }
        return this.type.compareTo(value.getType());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Value) || object == null) {
            return false;
        }
        Value value = (Value)object;
        boolean bl = this.value == null && value.value == null;
        return this.type == value.type && (bl || !bl && this.value.equals(value.value));
    }

    public String toString() {
        if (this.value != null) {
            switch (this.type) {
                case BOOLEAN: {
                    return this.value.toString().toUpperCase();
                }
                case DATE: {
                    return DateFormat.getDateTimeInstance(3, 3).format((Date)this.value);
                }
                case MATRIX: {
                    Value[][] valueArray = (Value[][])this.value;
                    String string = "{";
                    for (int i = 0; i < valueArray.length; ++i) {
                        for (int j = 0; j < valueArray[i].length; ++j) {
                            string = string + valueArray[i][j];
                            if (j + 1 >= valueArray[i].length) continue;
                            string = string + ";";
                        }
                        if (i + 1 >= valueArray.length) continue;
                        string = string + ";\n";
                    }
                    string = string + "}";
                    return string;
                }
            }
            return this.value.toString();
        }
        return "";
    }

    public String toString(Format format) {
        if (this.value != null) {
            switch (this.type) {
                case NUMERIC: {
                    if (format instanceof NumberFormat) {
                        return format.format((Number)this.value);
                    }
                    return this.value.toString();
                }
                case DATE: {
                    if (!(format instanceof DateFormat)) break;
                    return format.format((Date)this.value);
                }
            }
            return this.value.toString();
        }
        return "";
    }

    public static Value parseValue(String string, Type ... typeArray) {
        if (typeArray.length == 0) {
            typeArray = new Type[]{Type.BOOLEAN, Type.DATE, Type.NUMERIC};
        }
        block11: for (int i = 0; i < typeArray.length; ++i) {
            switch (typeArray[i]) {
                case BOOLEAN: {
                    try {
                        return Value.parseBooleanValue(string);
                    }
                    catch (ParseException parseException) {
                        continue block11;
                    }
                }
                case DATE: {
                    try {
                        return Value.parseDateValue(string);
                    }
                    catch (ParseException parseException) {
                        continue block11;
                    }
                }
                case NUMERIC: {
                    try {
                        return Value.parseNumericValue(string);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
        return new Value(string);
    }

    public static Value parseNumericValue(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = NumberFormat.getInstance().parse(string, parsePosition);
        if (parsePosition.getIndex() == string.length()) {
            return new Value(number);
        }
        throw new ParseException(string, parsePosition.getErrorIndex());
    }

    public static Value parseBooleanValue(String string) throws ParseException {
        if (string.equalsIgnoreCase("true")) {
            return new Value(true);
        }
        if (string.equalsIgnoreCase("false")) {
            return new Value(false);
        }
        throw new ParseException(string, 0);
    }

    public static Value parseDateValue(String string) throws ParseException {
        Comparable<Date> comparable;
        DateFormat[] dateFormatArray;
        ParsePosition parsePosition = new ParsePosition(0);
        for (Cloneable cloneable : dateFormatArray = new DateFormat[]{DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(2, 2)}) {
            comparable = cloneable.parse(string, parsePosition);
            if (parsePosition.getIndex() == string.length()) {
                return new Value((Date)comparable);
            }
            if (parsePosition.getIndex() <= 0) continue;
            parsePosition.setIndex(0);
        }
        DateFormat[] dateFormatArray2 = new DateFormat[]{DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(2), DateFormat.getTimeInstance(1)};
        for (int i = 0; i < dateFormatArray2.length; ++i) {
            Cloneable cloneable;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            cloneable = dateFormatArray2[i].parse(string, parsePosition);
            if (parsePosition.getIndex() == string.length()) {
                gregorianCalendar.setTime((Date)cloneable);
                comparable = new GregorianCalendar();
                gregorianCalendar.set(((Calendar)comparable).get(1), ((Calendar)comparable).get(2), ((Calendar)comparable).get(5));
                return new Value(gregorianCalendar.getTime());
            }
            if (parsePosition.getIndex() <= 0) continue;
            parsePosition.setIndex(0);
        }
        throw new ParseException(string, parsePosition.getErrorIndex());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNDEFINED,
        NUMERIC,
        TEXT,
        BOOLEAN,
        DATE,
        MATRIX,
        ERROR;

    }
}

