/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.compiler;

import csheets.core.formula.Expression;
import csheets.core.formula.Function;
import csheets.core.formula.FunctionParameter;
import csheets.core.formula.compiler.FormulaCompilationException;

public class IllegalFunctionCallException
extends FormulaCompilationException {
    private static final long serialVersionUID = 1960534028676316836L;
    private Function function;
    private FunctionParameter parameter;
    private Expression argument;

    public IllegalFunctionCallException(Function function, FunctionParameter functionParameter, Expression expression) {
        this.function = function;
        this.parameter = functionParameter;
        this.argument = expression;
    }

    public Function getFunction() {
        return this.function;
    }

    public FunctionParameter getParameter() {
        return this.parameter;
    }

    public Expression getArgument() {
        return this.argument;
    }

    public String getMessage() {
        String string = "Illegal function call: ";
        if (this.parameter == null) {
            string = string + "too many arguments (" + this.argument + " did not match).";
        } else if (this.argument == null) {
            string = string + "missing argument " + this.parameter.getName() + ".";
        }
        return string;
    }

    public String toString() {
        return this.getMessage();
    }
}

