/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.BinaryOperator;
import csheets.core.formula.Expression;
import csheets.core.formula.Function;
import csheets.core.formula.FunctionParameter;
import csheets.core.formula.Literal;
import csheets.core.formula.lang.Language;
import csheets.core.formula.lang.UnknownElementException;
import java.util.LinkedList;

public class Do
implements Function {
    public static final FunctionParameter[] parameters = new FunctionParameter[]{new FunctionParameter(Value.Type.TEXT, "Function", false, "The name of the function to which arguments are to be passed."), new FunctionParameter(Value.Type.MATRIX, "Function Range", false, "The range from which to select arguments"), new FunctionParameter(Value.Type.TEXT, "Conditional Operator", false, "The binary operator to use in the condition when selecting arguments."), new FunctionParameter(Value.Type.UNDEFINED, "Conditional Argument", false, "The right operand to use in the condition when selecting arguments."), new FunctionParameter(Value.Type.MATRIX, "Condition Range", true, "The range to use when checking conditions.")};

    public String getIdentifier() {
        return "DO";
    }

    public Value applyTo(Expression[] expressionArray) throws IllegalValueTypeException {
        Value[][] valueArray;
        Function function = null;
        BinaryOperator binaryOperator = null;
        try {
            function = Language.getInstance().getFunction(expressionArray[0].evaluate().toText());
            binaryOperator = Language.getInstance().getBinaryOperator(expressionArray[2].evaluate().toText());
        }
        catch (UnknownElementException unknownElementException) {
            return new Value(unknownElementException);
        }
        Value[][] valueArray2 = valueArray = expressionArray[1].evaluate().toMatrix();
        if (expressionArray.length == 5 && (valueArray.length != (valueArray2 = expressionArray[4].evaluate().toMatrix()).length || valueArray[0].length != valueArray2[0].length)) {
            return new Value(new IllegalArgumentException("Range dimensions must be equal"));
        }
        Literal literal = new Literal(expressionArray[3].evaluate());
        LinkedList<Literal> linkedList = new LinkedList<Literal>();
        for (int i = 0; i < valueArray2.length; ++i) {
            for (int j = 0; j < valueArray2[i].length; ++j) {
                if (!binaryOperator.applyTo(new Literal(valueArray2[i][j]), literal).toBoolean().booleanValue()) continue;
                linkedList.add(new Literal(valueArray[i][j]));
            }
        }
        if (linkedList.size() > 0) {
            return function.applyTo(linkedList.toArray(new Expression[linkedList.size()]));
        }
        return new Value();
    }

    public FunctionParameter[] getParameters() {
        return parameters;
    }

    public boolean isVarArg() {
        return false;
    }
}

