/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.core.Cell;
import csheets.core.Value;
import csheets.core.formula.BinaryOperation;
import csheets.core.formula.Reference;
import csheets.core.formula.lang.CellReference;
import csheets.core.formula.lang.RangeReference;
import csheets.core.formula.util.ExpressionVisitor;
import csheets.core.formula.util.ExpressionVisitorException;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceOperation
extends BinaryOperation
implements Reference {
    private static final long serialVersionUID = 1767227655524985408L;
    private SortedSet<Cell> cells;

    public ReferenceOperation(Reference reference, RangeReference rangeReference, Reference reference2) {
        super(reference, rangeReference, reference2);
    }

    @Override
    public SortedSet<Cell> getCells() {
        if (this.cells == null) {
            this.cells = new TreeSet<Cell>();
            Cell[][] cellArray = this.getOperator().getCells(this.getLeftOperand(), this.getRightOperand());
            for (int i = 0; i < cellArray.length; ++i) {
                for (int j = 0; j < cellArray[i].length; ++j) {
                    this.cells.add(cellArray[i][j]);
                }
            }
        }
        return this.cells;
    }

    @Override
    public RangeReference getOperator() {
        return (RangeReference)this.operator;
    }

    @Override
    public Reference getLeftOperand() {
        return (Reference)super.getLeftOperand();
    }

    @Override
    public Reference getRightOperand() {
        return (Reference)super.getRightOperand();
    }

    @Override
    public Value evaluate() {
        return this.getOperator().applyTo(this.getLeftOperand(), this.getRightOperand());
    }

    @Override
    public Object accept(ExpressionVisitor expressionVisitor) throws ExpressionVisitorException {
        return expressionVisitor.visitReference(this);
    }

    @Override
    public int compareTo(Reference reference) {
        Cell cell = reference.getCells().first();
        int n = this.getCells().first().compareTo(cell);
        if (n != 0) {
            return n;
        }
        if (reference instanceof CellReference) {
            return 1;
        }
        return this.getCells().last().compareTo(reference.getCells().last());
    }
}

