/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext;

import csheets.core.Address;
import csheets.core.Cell;
import csheets.core.CellListener;
import csheets.core.Spreadsheet;
import csheets.core.Workbook;
import java.util.Iterator;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpreadsheetExtension
implements Spreadsheet {
    private Spreadsheet delegate;
    private String name;

    public SpreadsheetExtension(Spreadsheet spreadsheet, String string) {
        this.delegate = spreadsheet;
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final String getTitle() {
        return this.delegate.getTitle();
    }

    @Override
    public final void setTitle(String string) {
        this.delegate.setTitle(string);
    }

    @Override
    public final Workbook getWorkbook() {
        return this.delegate.getWorkbook();
    }

    @Override
    public final int getColumnCount() {
        return this.delegate.getColumnCount();
    }

    @Override
    public final int getRowCount() {
        return this.delegate.getRowCount();
    }

    @Override
    public final Cell getCell(Address address) {
        Cell cell = this.delegate.getCell(address);
        Cell cell2 = (Cell)cell.getExtension(this.name);
        if (cell2 != null) {
            return cell2;
        }
        return cell;
    }

    @Override
    public final Cell getCell(int n, int n2) {
        return this.getCell(new Address(n, n2));
    }

    @Override
    public final SortedSet<Cell> getCells(Address address, Address address2) {
        return this.delegate.getCells(address, address2);
    }

    @Override
    public final Cell[] getColumn(int n) {
        return this.delegate.getColumn(n);
    }

    @Override
    public final Cell[] getRow(int n) {
        return this.delegate.getRow(n);
    }

    @Override
    public final Iterator<Cell> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public void addCellListener(CellListener cellListener) {
        this.delegate.addCellListener(cellListener);
    }

    @Override
    public void removeCellListener(CellListener cellListener) {
        this.delegate.removeCellListener(cellListener);
    }

    @Override
    public CellListener[] getCellListeners() {
        return this.delegate.getCellListeners();
    }

    @Override
    public final Spreadsheet getExtension(String string) {
        return (Spreadsheet)this.delegate.getExtension(string);
    }
}

