/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion.ui;

import csheets.core.Cell;
import csheets.ext.assertion.AssertableCell;
import csheets.ext.assertion.AssertableCellListener;
import csheets.ext.assertion.Assertion;
import csheets.ext.assertion.ui.AssertionController;
import csheets.ui.ctrl.FocusOwnerAction;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import csheets.ui.ctrl.UIController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AssertionPanel
extends JPanel
implements SelectionListener,
AssertableCellListener {
    private AssertionController controller;
    private AssertableCell cell;
    private JLabel statusLabel = new JLabel();
    private JTextField usField = new JTextField();
    private JLabel sgLabel = new JLabel();

    public AssertionPanel(UIController uIController) {
        super(new BorderLayout());
        this.setName("Assertions");
        this.controller = new AssertionController(uIController);
        uIController.addSelectionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(130, 60));
        jPanel.add(this.sgLabel);
        ApplyAction applyAction = new ApplyAction();
        JButton jButton = new JButton(applyAction);
        this.usField.setPreferredSize(new Dimension(120, 24));
        this.usField.setMaximumSize(new Dimension(1000, 24));
        this.usField.addActionListener(applyAction);
        this.usField.setAlignmentX(0.5f);
        jButton.setAlignmentX(0.5f);
        this.statusLabel.setAlignmentX(0.5f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.setPreferredSize(new Dimension(130, 120));
        jPanel2.add(this.usField);
        jPanel2.add(Box.createRigidArea(new Dimension(120, 4)));
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(120, 12)));
        jPanel2.add(this.statusLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(120, 12)));
        JPanel jPanel3 = new JPanel();
        JTextArea jTextArea = new JTextArea("");
        jTextArea.setPreferredSize(new Dimension(120, 100));
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setBackground(this.getBackground());
        jPanel3.add(jTextArea);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("System-generated");
        titledBorder.setTitleJustification(2);
        jPanel.setBorder(titledBorder);
        titledBorder = BorderFactory.createTitledBorder("User-specified");
        titledBorder.setTitleJustification(2);
        jPanel2.setBorder(titledBorder);
        titledBorder = BorderFactory.createTitledBorder("Syntax");
        titledBorder.setTitleJustification(2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel, "North");
        jPanel4.add((Component)jPanel2, "South");
        this.add((Component)jPanel4, "North");
        this.add((Component)jPanel3, "Center");
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        Cell cell = selectionEvent.getCell();
        if (cell != null) {
            AssertableCell assertableCell = (AssertableCell)cell.getExtension("Assertions");
            assertableCell.addAssertableCellListener(this);
            this.assertionsChanged(assertableCell);
        } else {
            this.usField.setText("");
            this.statusLabel.setText("");
            this.sgLabel.setText("");
        }
        if (selectionEvent.getPreviousCell() != null) {
            ((AssertableCell)selectionEvent.getPreviousCell().getExtension("Assertions")).removeAssertableCellListener(this);
        }
    }

    public void assertionsChanged(AssertableCell assertableCell) {
        this.cell = assertableCell;
        Color color = Color.BLACK;
        Color color2 = Color.BLACK;
        String string = "";
        if (assertableCell.isSGAsserted()) {
            this.sgLabel.setText(assertableCell.getSGAssertion().toString());
            color2 = AssertionController.getAssertionResultColor(assertableCell.assertSG());
        } else {
            this.sgLabel.setText("No assertion");
        }
        if (assertableCell.isUSAsserted()) {
            this.usField.setText(assertableCell.getUSAssertion().toString());
            Assertion.Result result = assertableCell.assertUS();
            color = AssertionController.getAssertionResultColor(result);
            switch (result) {
                case OK: {
                    string = string + "Valid";
                    break;
                }
                case NAN: {
                    string = string + "Non-numeric value";
                    break;
                }
                case FAILED: {
                    string = string + "Illegal value";
                    break;
                }
                case NO_DATA: {
                    string = string + "No value";
                }
            }
            Assertion.ComparisonResult comparisonResult = assertableCell.assertAssertions();
            switch (comparisonResult) {
                case NON_EQUAL: {
                    color = new Color(0.7f, 0.0f, 0.0f);
                    string = "Conflicting assertions";
                    break;
                }
                case ILLEGAL_INTERVAL: {
                    this.sgLabel.setText(comparisonResult.getErrorMsg());
                }
            }
        } else {
            this.usField.setText("");
            string = "No assertion";
        }
        this.sgLabel.setForeground(color2);
        this.statusLabel.setForeground(color);
        this.statusLabel.setText(string);
    }

    protected class ApplyAction
    extends FocusOwnerAction {
        protected String getName() {
            return "Apply";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AssertionPanel.this.cell != null && AssertionPanel.this.controller.setAssertion(AssertionPanel.this.cell, AssertionPanel.this.usField.getText().trim())) {
                this.focusOwner.repaint();
            }
        }
    }
}

