/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.Formula;
import csheets.ext.test.TestCaseBuilder;
import csheets.ext.test.TestCaseParam;
import csheets.ext.test.TestableCell;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCase
extends Formula
implements Serializable {
    private static final long serialVersionUID = -6135481035045505755L;
    private ValidationState validationState = ValidationState.PENDING;
    private Set<TestCaseParam> params = new HashSet<TestCaseParam>();
    private Value value;

    public TestCase(TestableCell testableCell, Set<TestCaseParam> set) {
        super(testableCell, new TestCaseBuilder(set).getExpression(testableCell.getFormula()));
        this.params = set;
        try {
            this.value = super.evaluate();
        }
        catch (IllegalValueTypeException illegalValueTypeException) {
            this.value = new Value(illegalValueTypeException);
        }
    }

    @Override
    public TestableCell getCell() {
        return (TestableCell)super.getCell();
    }

    @Override
    public Value evaluate() {
        return this.value;
    }

    public Set<TestCaseParam> getParams() {
        return this.params;
    }

    public ValidationState getValidationState() {
        return this.validationState;
    }

    public void setValidationState(ValidationState validationState) {
        this.validationState = validationState;
    }

    public boolean hasParam(TestCaseParam testCaseParam) {
        Iterator<TestCaseParam> iterator = this.params.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(testCaseParam)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TestCase) || object == null) {
            return false;
        }
        TestCase testCase = (TestCase)object;
        return ((Object)this.params).equals(testCase.getParams()) && this.getCell().equals(testCase.getCell());
    }

    public int hashCode() {
        return this.getCell().hashCode() + ((Object)this.params).hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationState {
        VALID,
        REJECTED,
        PENDING;

    }
}

