/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test;

import csheets.core.Cell;
import csheets.core.Value;
import csheets.ext.CellExtension;
import csheets.ext.test.DuplicateUserTCPException;
import csheets.ext.test.TestCase;
import csheets.ext.test.TestCaseParam;
import csheets.ext.test.TestableCellListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestableCell
extends CellExtension {
    private static final long serialVersionUID = -2626239432851585308L;
    private Set<TestCaseParam> tcParams = new HashSet<TestCaseParam>();
    private Set<TestCase> testCases = new HashSet<TestCase>();
    private transient List<TestableCellListener> listeners = new ArrayList<TestableCellListener>();

    TestableCell(Cell cell) {
        super(cell, "Test Cases");
    }

    @Override
    public void contentChanged(Cell cell) {
        if (this.getFormula() != null) {
            this.resetTestCases();
        } else {
            this.removeAllTcpsOfType(TestCaseParam.Type.DERIVED);
            this.testCases.clear();
        }
    }

    public Set<TestCase> getTestCases() {
        return this.testCases;
    }

    public boolean hasTestCases() {
        return !this.testCases.isEmpty();
    }

    public boolean hasTestError() {
        for (TestCase testCase : this.testCases) {
            if (testCase.getValidationState() != TestCase.ValidationState.REJECTED) continue;
            return true;
        }
        return false;
    }

    public double getTestedness() {
        if (this.hasTestCases()) {
            double d = 0.0;
            for (TestCase testCase : this.testCases) {
                if (testCase.getValidationState() != TestCase.ValidationState.VALID) continue;
                d += 1.0;
            }
            return d / (double)this.testCases.size();
        }
        return 0.0;
    }

    public void resetTestCases() {
        boolean bl = false;
        if (!this.testCases.isEmpty()) {
            this.testCases.clear();
            this.removeAllTcpsOfType(TestCaseParam.Type.DERIVED);
            bl = true;
        }
        if (this.allPrecedentsHaveParams() && this.getPrecedents().size() > 0) {
            TestableCell testableCell = (TestableCell)this.getPrecedents().first();
            Iterator<TestCaseParam> iterator = testableCell.getTestCaseParams().iterator();
            while (iterator.hasNext()) {
                this.extendTestCases(testableCell, iterator.next());
            }
            bl = true;
        }
        if (bl) {
            this.fireTestCasesChanged();
        }
    }

    protected void extendTestCases(TestableCell testableCell, TestCaseParam testCaseParam) {
        SortedSet<Cell> sortedSet = this.getPrecedents();
        sortedSet.remove(testableCell);
        HashMap<Cell, Value> hashMap = new HashMap<Cell, Value>();
        hashMap.put(testableCell, testCaseParam.getValue());
        Set<Map<Cell, Value>> set = this.createCasesSet(sortedSet, hashMap);
        if (this.toTestCases(set)) {
            this.fireTestCasesChanged();
        }
    }

    private Set<Map<Cell, Value>> createCasesSet(Set<Cell> set, Map<Cell, Value> map) {
        HashSet<Map<Cell, Value>> hashSet = new HashSet<Map<Cell, Value>>();
        hashSet.add(map);
        for (Cell cell : set) {
            HashSet hashSet2 = new HashSet();
            for (TestCaseParam testCaseParam : ((TestableCell)cell).getTestCaseParams()) {
                for (Map map2 : hashSet) {
                    HashMap<TestableCell, Value> hashMap = new HashMap<TestableCell, Value>();
                    hashMap.putAll(map2);
                    hashMap.put(testCaseParam.getCell(), testCaseParam.getValue());
                    hashSet2.add(hashMap);
                }
            }
            hashSet = hashSet2;
        }
        return hashSet;
    }

    private boolean toTestCases(Set<Map<Cell, Value>> set) {
        boolean bl = false;
        for (Map<Cell, Value> map : set) {
            HashSet<TestCaseParam> hashSet = new HashSet<TestCaseParam>();
            Set<Map.Entry<Cell, Value>> set2 = map.entrySet();
            for (Map.Entry<Cell, Value> entry : set2) {
                hashSet.add(new TestCaseParam((TestableCell)entry.getKey().getExtension("Test Cases"), entry.getValue(), TestCaseParam.Type.DERIVED));
            }
            TestCase testCase = new TestCase(this, hashSet);
            this.testCases.add(testCase);
            bl = true;
        }
        return bl;
    }

    public Set<TestCaseParam> getTestCaseParams() {
        return this.tcParams;
    }

    public boolean hasTestCaseParams() {
        return !this.tcParams.isEmpty();
    }

    protected boolean allPrecedentsHaveParams() {
        for (Cell cell : this.getPrecedents()) {
            if (((TestableCell)cell).hasTestCaseParams()) continue;
            return false;
        }
        return true;
    }

    public TestCaseParam addTestCaseParam(Value value) throws DuplicateUserTCPException {
        TestCaseParam testCaseParam2 = null;
        for (TestCaseParam testCaseParam2 : this.tcParams) {
            if (!value.equals(testCaseParam2.getValue())) continue;
            if (testCaseParam2.isUserEntered()) {
                throw new DuplicateUserTCPException(value, "Cells cannot have duplicate user-entered test case parameters");
            }
            testCaseParam2.setType(TestCaseParam.Type.USER_ENTERED, true);
            return testCaseParam2;
        }
        return this.addTestCaseParam(value, TestCaseParam.Type.USER_ENTERED);
    }

    public TestCaseParam addTestCaseParam(Value value, TestCaseParam.Type type) {
        TestCaseParam testCaseParam2 = null;
        for (TestCaseParam testCaseParam2 : this.tcParams) {
            if (!value.equals(testCaseParam2.getValue())) continue;
            testCaseParam2.setType(type, true);
            return testCaseParam2;
        }
        testCaseParam2 = new TestCaseParam(this, value, type);
        this.tcParams.add(testCaseParam2);
        for (Cell cell : this.getDependents()) {
            ((TestableCell)cell).precedentAddedParam(this, testCaseParam2);
        }
        this.fireTestCaseParametersChanged();
        return testCaseParam2;
    }

    public void removeTestCaseParam(TestCaseParam testCaseParam) {
        this.removeTestCaseParam(testCaseParam, TestCaseParam.Type.USER_ENTERED);
    }

    public void removeTestCaseParam(TestCaseParam testCaseParam, TestCaseParam.Type type) {
        testCaseParam.setType(type, false);
        if (testCaseParam.hasNoType()) {
            this.tcParams.remove(testCaseParam);
            for (Cell cell : this.getDependents()) {
                ((TestableCell)cell).precedentRemovedParam(this, testCaseParam);
            }
            this.fireTestCaseParametersChanged();
        }
    }

    protected void removeAllTcpsOfType(TestCaseParam.Type type) {
        Iterator<TestCaseParam> iterator = this.tcParams.iterator();
        while (iterator.hasNext()) {
            TestCaseParam testCaseParam = iterator.next();
            testCaseParam.setType(type, false);
            if (!testCaseParam.hasNoType()) continue;
            iterator.remove();
            for (Cell cell : this.getDependents()) {
                ((TestableCell)cell).precedentRemovedParam(this, testCaseParam);
            }
            this.fireTestCaseParametersChanged();
        }
    }

    public void precedentAddedParam(TestableCell testableCell, TestCaseParam testCaseParam) {
        if (this.allPrecedentsHaveParams()) {
            if (this.testCases.isEmpty()) {
                this.resetTestCases();
            } else {
                this.extendTestCases(testableCell, testCaseParam);
            }
        }
    }

    public void precedentRemovedParam(TestableCell testableCell, TestCaseParam testCaseParam) {
        if (this.allPrecedentsHaveParams()) {
            Iterator<TestCase> iterator = this.testCases.iterator();
            while (iterator.hasNext()) {
                TestCase testCase = iterator.next();
                Set<TestCaseParam> set = testCase.getParams();
                if (!set.contains(testCaseParam)) continue;
                iterator.remove();
                TestCaseParam testCaseParam22 = null;
                for (TestCaseParam testCaseParam22 : this.tcParams) {
                    if (!testCase.evaluate().equals(testCaseParam22.getValue())) continue;
                }
                if (testCaseParam22 == null) continue;
                this.removeTestCaseParam(testCaseParam22, TestCaseParam.Type.DERIVED);
            }
            this.fireTestCasesChanged();
        } else if (!this.testCases.isEmpty()) {
            this.testCases.clear();
            this.removeAllTcpsOfType(TestCaseParam.Type.DERIVED);
            this.fireTestCasesChanged();
        }
    }

    @Override
    public void cellCleared(Cell cell) {
        if (this.getDelegate().equals(cell)) {
            this.tcParams.clear();
        }
    }

    @Override
    public void cellCopied(Cell cell, Cell cell2) {
        if (this.getDelegate().equals(cell)) {
            TestableCell testableCell = (TestableCell)cell2.getExtension("Test Cases");
            this.tcParams.clear();
            for (TestCaseParam testCaseParam : testableCell.getTestCaseParams()) {
                if (!testCaseParam.hasType(TestCaseParam.Type.USER_ENTERED)) continue;
                try {
                    this.addTestCaseParam(testCaseParam.getValue());
                }
                catch (DuplicateUserTCPException duplicateUserTCPException) {}
            }
        }
    }

    public void addTestableCellListener(TestableCellListener testableCellListener) {
        this.listeners.add(testableCellListener);
    }

    public void removeTestableCellListener(TestableCellListener testableCellListener) {
        this.listeners.remove(testableCellListener);
    }

    protected void fireTestCasesChanged() {
        for (TestableCellListener testableCellListener : this.listeners) {
            testableCellListener.testCasesChanged(this);
        }
    }

    protected void fireTestCaseParametersChanged() {
        for (TestableCellListener testableCellListener : this.listeners) {
            testableCellListener.testCaseParametersChanged(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new ArrayList<TestableCellListener>();
    }
}

