/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test.ui;

import csheets.core.Cell;
import csheets.ext.test.TestCaseParam;
import csheets.ext.test.TestableCell;
import csheets.ext.test.ui.TestCaseParamController;
import csheets.ext.test.ui.TestCaseParamTable;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import csheets.ui.ctrl.UIController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class TestCaseParamPanel
extends JPanel
implements SelectionListener {
    private static final String[] columnNames = new String[]{"Precedent", "", "", "", "", "", "", "", "", ""};
    private DefaultTableModel tableModel;
    private TestCaseParamTable table;
    private TestCaseParamController controller;
    private boolean listening = true;

    public TestCaseParamPanel(UIController uIController) {
        this.controller = new TestCaseParamController(uIController);
        this.tableModel = new DefaultTableModel(columnNames, 0);
        this.tableModel.addTableModelListener(new TestCaseParamSetter());
        this.table = new TestCaseParamTable(this.tableModel);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add((Component)jScrollPane, "Center");
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        this.listening = false;
        this.tableModel.setRowCount(0);
        Cell cell = selectionEvent.getCell();
        if (cell != null) {
            SortedSet<Cell> sortedSet = cell.getPrecedents();
            this.tableModel.setRowCount(sortedSet.size());
            int n = 0;
            for (Cell cell2 : sortedSet) {
                TestableCell testableCell = (TestableCell)cell2.getExtension("Test Cases");
                this.tableModel.setValueAt(testableCell, n, 0);
                int n2 = 1;
                for (TestCaseParam testCaseParam : testableCell.getTestCaseParams()) {
                    if (this.tableModel.getColumnCount() - 1 == n2) {
                        this.tableModel.addColumn("");
                    }
                    this.tableModel.setValueAt(testCaseParam, n, n2++);
                }
                ++n;
            }
            this.table.packColumns();
        }
        this.listening = true;
    }

    protected class TestCaseParamSetter
    implements TableModelListener {
        protected TestCaseParamSetter() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (TestCaseParamPanel.this.listening && tableModelEvent.getType() == 0 && tableModelEvent.getColumn() != 0 && TestCaseParamPanel.this.listening) {
                String string = TestCaseParamPanel.this.tableModel.getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn()).toString().trim();
                TestableCell testableCell = (TestableCell)TestCaseParamPanel.this.tableModel.getValueAt(tableModelEvent.getFirstRow(), 0);
                if (string.equals("")) {
                    string = null;
                }
                HashSet<TestCaseParam> hashSet = new HashSet<TestCaseParam>();
                Vector vector = TestCaseParamPanel.this.tableModel.getDataVector().elementAt(tableModelEvent.getFirstRow());
                for (Object e : vector) {
                    if (!(e instanceof TestCaseParam)) continue;
                    hashSet.add((TestCaseParam)e);
                }
                TestCaseParam testCaseParam = TestCaseParamPanel.this.controller.setTestCaseParams(testableCell, string, hashSet);
                TestCaseParamPanel.this.listening = false;
                if (testCaseParam != null) {
                    TestCaseParamPanel.this.tableModel.setValueAt(testCaseParam, tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                } else {
                    TestCaseParamPanel.this.tableModel.setValueAt("", tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                }
                TestCaseParamPanel.this.listening = true;
                TestCaseParamPanel.this.table.packColumn(tableModelEvent.getColumn());
            }
        }
    }
}

