/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test.ui;

import csheets.core.Value;
import csheets.ext.assertion.AssertableCell;
import csheets.ext.assertion.Assertion;
import csheets.ext.test.TestCaseParam;
import csheets.ext.test.TestableCell;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TestCaseParamRenderer
extends DefaultTableCellRenderer {
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof TestCaseParam) {
            AssertableCell assertableCell;
            TestCaseParam testCaseParam = (TestCaseParam)object;
            TestableCell testableCell = (TestableCell)jTable.getValueAt(n, 0);
            if (testCaseParam != null && testCaseParam.getValue().getType() == Value.Type.NUMERIC && (assertableCell = (AssertableCell)testableCell.getExtension("Assertions")) != null) {
                Assertion.Result result = assertableCell.assertAny(testCaseParam.getValue());
                if (testCaseParam.isUserEntered()) {
                    if (result == Assertion.Result.NAN || result == Assertion.Result.FAILED) {
                        this.setForeground(Color.RED);
                        this.setToolTipText("Entered test case param violates assertion");
                    } else {
                        this.setForeground(Color.BLACK);
                        this.setToolTipText(null);
                    }
                } else if (testCaseParam.isDerived() || testCaseParam.isSystemGenerated()) {
                    if (result == Assertion.Result.NAN || result == Assertion.Result.FAILED) {
                        this.setForeground(new Color(246, 126, 126));
                        this.setToolTipText("Derived test case param violates assertion");
                    } else {
                        this.setForeground(Color.LIGHT_GRAY);
                        this.setToolTipText(null);
                    }
                }
            }
        }
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }
}

