/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui;

import csheets.SpreadsheetAppEvent;
import csheets.SpreadsheetAppListener;
import csheets.io.FilenameExtensionFilter;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileChooser
extends JFileChooser
implements SpreadsheetAppListener {
    private Component parent;
    private List<Filter> filters = new ArrayList<Filter>();

    public FileChooser(Component component, Properties properties) {
        this.parent = component;
        this.setAcceptAllFileFilterUsed(false);
        if (properties != null) {
            String string;
            String string2;
            String string3;
            int n = 0;
            while ((string3 = properties.getProperty("filetype" + n + ".extension")) != null && (string2 = properties.getProperty("filetype" + n + ".description")) != null) {
                this.addChoosableFileFilter(new Filter(new FilenameExtensionFilter(string3), string2));
                ++n;
            }
            if (this.filters.size() > 0) {
                this.setFileFilter(this.filters.get(0));
            }
            if ((string = properties.getProperty("recentfile0")) != null) {
                this.setCurrentDirectory(new File(string));
            }
        }
    }

    public File getFileToOpen() {
        if (this.showOpenDialog(this.parent) == 0) {
            return this.getChosenFile();
        }
        return null;
    }

    public File getFileToSave() {
        if (this.showSaveDialog(this.parent) == 0) {
            return this.getChosenFile();
        }
        return null;
    }

    private File getChosenFile() {
        FilenameFilter filenameFilter;
        File file = this.getSelectedFile();
        String string = file.getName();
        if (string.lastIndexOf(46) != -1) {
            boolean bl = this.filters.isEmpty();
            for (Filter filter : this.filters) {
                if (!filter.getFilter().accept(file, string)) continue;
                bl = true;
                break;
            }
            return file.isDirectory() || bl ? file : null;
        }
        FileFilter fileFilter = this.getFileFilter();
        if (fileFilter instanceof Filter && (filenameFilter = ((Filter)fileFilter).getFilter()) instanceof FilenameExtensionFilter) {
            String[] stringArray = ((FilenameExtensionFilter)filenameFilter).getExtensions();
            return new File(file.getAbsolutePath() + "." + stringArray[0]);
        }
        return null;
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        super.addChoosableFileFilter(fileFilter);
        if (fileFilter instanceof Filter) {
            this.filters.add((Filter)fileFilter);
        }
    }

    public void workbookCreated(SpreadsheetAppEvent spreadsheetAppEvent) {
    }

    public void workbookLoaded(SpreadsheetAppEvent spreadsheetAppEvent) {
        this.setCurrentDirectory(spreadsheetAppEvent.getFile());
    }

    public void workbookUnloaded(SpreadsheetAppEvent spreadsheetAppEvent) {
    }

    public void workbookSaved(SpreadsheetAppEvent spreadsheetAppEvent) {
        this.setCurrentDirectory(spreadsheetAppEvent.getFile());
    }

    public static class Filter
    extends FileFilter {
        private FilenameFilter filter;
        private String description;

        public Filter(FilenameFilter filenameFilter, String string) {
            this.filter = filenameFilter;
            this.description = string;
        }

        public boolean accept(File file) {
            return file != null && (file.isDirectory() || this.filter.accept(file, file.getName()));
        }

        public FilenameFilter getFilter() {
            return this.filter;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

