/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.grid;

import csheets.ui.grid.HeaderRenderer;
import csheets.ui.grid.RowHeader;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public class Grid
extends JTable {
    public static final String RESUME_EDIT_COMMAND = "Edit active cell";
    private RowHeader rowHeader;

    public Grid() {
        this(null);
    }

    public Grid(TableModel tableModel) {
        super(tableModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(1);
        this.setGridColor(this.gridColor.brighter());
        UIManager.getDefaults().putDefaults(new Object[]{"TableHeader.selectionForeground", Color.black, "TableHeader.selectionBackground", Color.orange});
        this.getTableHeader().setDefaultRenderer(new HeaderRenderer(0));
        this.setSurrendersFocusOnKeystroke(true);
        this.getActionMap().put(RESUME_EDIT_COMMAND, new ResumeEditAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(113, 0), RESUME_EDIT_COMMAND);
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyCode() == 67 || keyEvent.getKeyCode() == 88 || keyEvent.getKeyCode() == 86 || !keyEvent.isAltDown() && !keyEvent.isControlDown()) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
        return false;
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        super.changeSelection(n, n2, bl, bl2);
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
        if (this.rowHeader != null) {
            this.rowHeader.repaint();
        }
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        if (this.rowHeader == null) {
            this.rowHeader = new RowHeader(this);
        }
        this.setEnclosingScrollPaneRowHeaderView(this.rowHeader);
    }

    protected void unconfigureEnclosingScrollPane() {
        super.unconfigureEnclosingScrollPane();
        this.setEnclosingScrollPaneRowHeaderView(null);
    }

    private void setEnclosingScrollPaneRowHeaderView(JComponent jComponent) {
        JScrollPane jScrollPane;
        JViewport jViewport;
        if (this.getParent() instanceof JViewport && this.getParent().getParent() instanceof JScrollPane && (jViewport = (jScrollPane = (JScrollPane)this.getParent().getParent()).getViewport()) != null && jViewport.getView() == this) {
            jScrollPane.setRowHeaderView(jComponent);
        }
    }

    protected class ResumeEditAction
    extends AbstractAction {
        public ResumeEditAction() {
            this.putValue("Name", Grid.RESUME_EDIT_COMMAND);
            this.putValue("ShortDescription", Grid.RESUME_EDIT_COMMAND);
            this.putValue("ActionCommandKey", Grid.RESUME_EDIT_COMMAND);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = Grid.this.getSelectionModel().getAnchorSelectionIndex();
            int n2 = Grid.this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n >= 0 && n2 >= 0) {
                Grid.this.editCellAt(n, n2, actionEvent);
            }
        }
    }
}

