/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.sheet;

import csheets.core.Cell;
import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.ext.style.StylableCell;
import csheets.ui.ctrl.UIController;
import csheets.ui.ext.CellDecorator;
import csheets.ui.ext.UIExtension;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.text.Format;
import java.util.LinkedList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class CellRenderer
extends DefaultTableCellRenderer {
    private LinkedList<CellDecorator> decorators = new LinkedList();
    private Cell cell;
    private boolean selected = false;
    private boolean hasFocus = false;

    public CellRenderer(UIController uIController) {
        for (UIExtension uIExtension : uIController.getExtensions()) {
            CellDecorator cellDecorator = uIExtension.getCellDecorator();
            if (cellDecorator == null) continue;
            this.decorators.add(cellDecorator);
        }
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.cell = (Cell)object;
        this.selected = bl;
        this.hasFocus = bl2;
        if (this.cell != null) {
            StylableCell stylableCell = (StylableCell)this.cell.getExtension("Style");
            Value value = this.cell.getValue();
            Format format = stylableCell.getFormat();
            this.setText(format == null ? value.toString() : value.toString(format));
            this.setHorizontalAlignment(stylableCell.getHorizontalAlignment());
            this.setVerticalAlignment(stylableCell.getVerticalAlignment());
            this.setFont(stylableCell.getFont());
            this.setBorder(stylableCell.getBorder());
            if (!bl) {
                this.setBackground(stylableCell.getBackgroundColor());
                if (value.getType() == Value.Type.ERROR) {
                    this.setForeground(Color.red);
                } else {
                    this.setForeground(stylableCell.getForegroundColor());
                }
            }
            if (value.getType() == Value.Type.ERROR) {
                try {
                    this.setToolTipText(value.toError().getMessage());
                }
                catch (IllegalValueTypeException illegalValueTypeException) {}
            } else {
                this.setToolTipText(null);
            }
        }
        return this;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.cell != null) {
            for (CellDecorator cellDecorator : this.decorators) {
                if (!cellDecorator.isEnabled()) continue;
                cellDecorator.decorate(this, graphics, this.cell, this.selected, this.hasFocus);
            }
        }
    }
}

