/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.sheet;

import csheets.core.Address;
import csheets.core.Cell;
import csheets.core.CellListener;
import csheets.core.Spreadsheet;
import csheets.ui.ctrl.UIController;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetTableModel
extends AbstractTableModel {
    private Spreadsheet spreadsheet;
    private UIController uiController;
    private CellListener cellListener = new CellChangeListener();

    public SpreadsheetTableModel(Spreadsheet spreadsheet, UIController uIController) {
        this.spreadsheet = spreadsheet;
        this.uiController = uIController;
        spreadsheet.addCellListener(this.cellListener);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Cell.class;
    }

    @Override
    public int getRowCount() {
        return Math.max(128, this.spreadsheet.getRowCount() + 1);
    }

    @Override
    public int getColumnCount() {
        return Math.max(52, this.spreadsheet.getRowCount() + 1);
    }

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 <= this.spreadsheet.getColumnCount() && n <= this.spreadsheet.getRowCount()) {
            return this.spreadsheet.getCell(new Address(n2, n));
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    private class CellChangeListener
    implements CellListener {
        public void valueChanged(Cell cell) {
            SpreadsheetTableModel.this.fireTableCellUpdated(cell.getAddress().getRow(), cell.getAddress().getColumn());
        }

        public void contentChanged(Cell cell) {
            SpreadsheetTableModel.this.uiController.setWorkbookModified(cell.getSpreadsheet().getWorkbook());
        }

        public void dependentsChanged(Cell cell) {
        }

        public void cellCleared(Cell cell) {
        }

        public void cellCopied(Cell cell, Cell cell2) {
        }
    }
}

