/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.jeks;

import com.eteks.jeks.JeksExpression;
import com.eteks.jeks.JeksExpressionSyntax;
import com.eteks.parser.Interpreter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class JeksCellRenderer
extends DefaultTableCellRenderer {
    private JeksExpressionSyntax syntax;
    private Interpreter interpreter;
    private static final Object DEFAULT_VALUE = new Long(0L);

    public JeksCellRenderer(JeksExpressionSyntax jeksExpressionSyntax, Interpreter interpreter) {
        this.syntax = jeksExpressionSyntax;
        this.interpreter = interpreter;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof JeksExpression) {
            object = this.getExpressionValue((JeksExpression)object);
            return jTable.getDefaultRenderer(object.getClass()).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    public Object getExpressionValue(JeksExpression jeksExpression) {
        Object object;
        block9: {
            try {
                object = jeksExpression.getValue(this.interpreter);
                if (object == null) {
                    object = DEFAULT_VALUE;
                } else if (object instanceof Double) {
                    Double d = (Double)object;
                    if (d.isNaN() || d.isInfinite()) {
                        object = this.syntax.getCellError(JeksExpressionSyntax.ERROR_INVALID_NUMBER);
                    } else if (d == Math.floor(d)) {
                        object = new Long(d.longValue());
                    }
                }
            }
            catch (Exception exception) {
                object = this.syntax.getCellError(exception);
            }
            catch (Error error) {
                object = this.syntax.getCellError(error);
                if (object != null) break block9;
                throw error;
            }
        }
        return object;
    }
}

