/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser.node;

import com.eteks.parser.Interpreter;
import com.eteks.parser.Syntax;
import com.eteks.parser.node.ConstantNode;
import com.eteks.parser.node.ExpressionNode;
import com.eteks.parser.node.ParameterizedNode;

public class CommonFunctionNode
extends ConstantNode
implements ParameterizedNode {
    private ExpressionNode parameter;

    public CommonFunctionNode(Object object) {
        super(object);
    }

    public void addParameter(ExpressionNode expressionNode) {
        this.parameter = expressionNode;
    }

    public int getParameterCount() {
        return this.parameter != null ? 1 : 0;
    }

    public ExpressionNode getParameter() {
        return this.parameter;
    }

    public Object computeExpression(Interpreter interpreter, Object[] objectArray) {
        Object object = this.parameter.computeExpression(interpreter, objectArray);
        return interpreter.getCommonFunctionValue(this.getKey(), object);
    }

    public double computeExpression(double[] dArray) {
        double d = this.parameter.computeExpression(dArray);
        Object object = this.getKey();
        if (object.equals(Syntax.FUNCTION_LN)) {
            return Math.log(d);
        }
        if (object.equals(Syntax.FUNCTION_LOG)) {
            return Math.log(d) / Math.log(10.0);
        }
        if (object.equals(Syntax.FUNCTION_EXP)) {
            return Math.exp(d);
        }
        if (object.equals(Syntax.FUNCTION_SQR)) {
            return d * d;
        }
        if (object.equals(Syntax.FUNCTION_SQRT)) {
            return Math.sqrt(d);
        }
        if (object.equals(Syntax.FUNCTION_COS)) {
            return Math.cos(d);
        }
        if (object.equals(Syntax.FUNCTION_SIN)) {
            return Math.sin(d);
        }
        if (object.equals(Syntax.FUNCTION_TAN)) {
            return Math.tan(d);
        }
        if (object.equals(Syntax.FUNCTION_ACOS)) {
            return Math.acos(d);
        }
        if (object.equals(Syntax.FUNCTION_ASIN)) {
            return Math.asin(d);
        }
        if (object.equals(Syntax.FUNCTION_ATAN)) {
            return Math.atan(d);
        }
        if (object.equals(Syntax.FUNCTION_COSH)) {
            return (Math.exp(d) + Math.exp(-d)) / 2.0;
        }
        if (object.equals(Syntax.FUNCTION_SINH)) {
            return (Math.exp(d) - Math.exp(-d)) / 2.0;
        }
        if (object.equals(Syntax.FUNCTION_TANH)) {
            return (Math.exp(d) - Math.exp(-d)) / (Math.exp(d) + Math.exp(-d));
        }
        if (object.equals(Syntax.FUNCTION_INTEGER)) {
            return (long)d;
        }
        if (object.equals(Syntax.FUNCTION_FLOOR)) {
            return Math.floor(d);
        }
        if (object.equals(Syntax.FUNCTION_CEIL)) {
            return Math.ceil(d);
        }
        if (object.equals(Syntax.FUNCTION_ROUND)) {
            return Math.rint(d);
        }
        if (object.equals(Syntax.FUNCTION_ABS)) {
            return Math.abs(d);
        }
        if (object.equals(Syntax.FUNCTION_OPPOSITE)) {
            return -d;
        }
        if (object.equals(Syntax.FUNCTION_NOT)) {
            return d != 0.0 ? 1 : 0;
        }
        throw new IllegalArgumentException("Common function key " + object + " not implemented");
    }
}

