/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.sax2dtm.SAX2RTFDTM;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.IntStack;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.ObjectStack;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.SourceTreeManager;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.OneStepIteratorForward;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.XMLReader;

public class XPathContext
extends DTMManager {
    IntStack m_last_pushed_rtfdtm = new IntStack();
    private Vector m_rtfdtm_stack = null;
    private int m_which_rtfdtm = -1;
    private SAX2RTFDTM m_global_rtfdtm = null;
    protected DTMManager m_dtmManager = DTMManager.newInstance(XMLStringFactoryImpl.getFactory());
    ObjectStack m_saxLocations = new ObjectStack(4096);
    private Object m_owner;
    private Method m_ownerGetErrorListener;
    private VariableStack m_variableStacks = new VariableStack();
    private SourceTreeManager m_sourceTreeManager = new SourceTreeManager();
    private ErrorListener m_errorListener;
    private ErrorListener m_defaultErrorListener;
    private URIResolver m_uriResolver;
    public XMLReader m_primaryReader;
    private static XSLMessages m_XSLMessages = new XSLMessages();
    private Stack m_contextNodeLists = new Stack();
    public static final int RECURSIONLIMIT = 4096;
    private IntStack m_currentNodes = new IntStack(4096);
    private NodeVector m_iteratorRoots = new NodeVector();
    private NodeVector m_predicateRoots = new NodeVector();
    private IntStack m_currentExpressionNodes = new IntStack(4096);
    private IntStack m_predicatePos = new IntStack();
    private ObjectStack m_prefixResolvers = new ObjectStack(4096);
    private Stack m_axesIteratorStack = new Stack();
    XPathExpressionContext expressionContext = new XPathExpressionContext();

    public DTMManager getDTMManager() {
        return this.m_dtmManager;
    }

    public DTM getDTM(Source source, boolean unique, DTMWSFilter wsfilter, boolean incremental, boolean doIndexing) {
        return this.m_dtmManager.getDTM(source, unique, wsfilter, incremental, doIndexing);
    }

    public DTM getDTM(int nodeHandle) {
        return this.m_dtmManager.getDTM(nodeHandle);
    }

    public int getDTMHandleFromNode(Node node) {
        return this.m_dtmManager.getDTMHandleFromNode(node);
    }

    public int getDTMIdentity(DTM dtm) {
        return this.m_dtmManager.getDTMIdentity(dtm);
    }

    public DTM createDocumentFragment() {
        return this.m_dtmManager.createDocumentFragment();
    }

    public boolean release(DTM dtm, boolean shouldHardDelete) {
        if (this.m_rtfdtm_stack != null && this.m_rtfdtm_stack.contains(dtm)) {
            return false;
        }
        return this.m_dtmManager.release(dtm, shouldHardDelete);
    }

    public DTMIterator createDTMIterator(Object xpathCompiler, int pos) {
        return this.m_dtmManager.createDTMIterator(xpathCompiler, pos);
    }

    public DTMIterator createDTMIterator(String xpathString, PrefixResolver presolver) {
        return this.m_dtmManager.createDTMIterator(xpathString, presolver);
    }

    public DTMIterator createDTMIterator(int whatToShow, DTMFilter filter, boolean entityReferenceExpansion) {
        return this.m_dtmManager.createDTMIterator(whatToShow, filter, entityReferenceExpansion);
    }

    public DTMIterator createDTMIterator(int node) {
        OneStepIteratorForward iter = new OneStepIteratorForward(13);
        iter.setRoot(node, this);
        return iter;
    }

    public XPathContext() {
        this.m_prefixResolvers.push(null);
        this.m_currentNodes.push(-1);
        this.m_currentExpressionNodes.push(-1);
        this.m_saxLocations.push(null);
    }

    public XPathContext(Object owner) {
        this.m_owner = owner;
        try {
            this.m_ownerGetErrorListener = this.m_owner.getClass().getMethod("getErrorListener", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.m_prefixResolvers.push(null);
        this.m_currentNodes.push(-1);
        this.m_currentExpressionNodes.push(-1);
        this.m_saxLocations.push(null);
    }

    public void reset() {
        if (this.m_rtfdtm_stack != null) {
            Enumeration e = this.m_rtfdtm_stack.elements();
            while (e.hasMoreElements()) {
                this.m_dtmManager.release((DTM)e.nextElement(), true);
            }
        }
        this.m_rtfdtm_stack = null;
        this.m_which_rtfdtm = -1;
        if (this.m_global_rtfdtm != null) {
            this.m_dtmManager.release(this.m_global_rtfdtm, true);
        }
        this.m_global_rtfdtm = null;
        this.m_dtmManager = DTMManager.newInstance(XMLStringFactoryImpl.getFactory());
        this.m_saxLocations.removeAllElements();
        this.m_axesIteratorStack.removeAllElements();
        this.m_contextNodeLists.removeAllElements();
        this.m_currentExpressionNodes.removeAllElements();
        this.m_currentNodes.removeAllElements();
        this.m_iteratorRoots.RemoveAllNoClear();
        this.m_predicatePos.removeAllElements();
        this.m_predicateRoots.RemoveAllNoClear();
        this.m_prefixResolvers.removeAllElements();
        this.m_prefixResolvers.push(null);
        this.m_currentNodes.push(-1);
        this.m_currentExpressionNodes.push(-1);
        this.m_saxLocations.push(null);
    }

    public void setSAXLocator(SourceLocator location) {
        this.m_saxLocations.setTop(location);
    }

    public void pushSAXLocator(SourceLocator location) {
        this.m_saxLocations.push(location);
    }

    public void pushSAXLocatorNull() {
        this.m_saxLocations.push(null);
    }

    public void popSAXLocator() {
        this.m_saxLocations.pop();
    }

    public SourceLocator getSAXLocator() {
        return (SourceLocator)this.m_saxLocations.peek();
    }

    public Object getOwnerObject() {
        return this.m_owner;
    }

    public final VariableStack getVarStack() {
        return this.m_variableStacks;
    }

    public final void setVarStack(VariableStack varStack) {
        this.m_variableStacks = varStack;
    }

    public final SourceTreeManager getSourceTreeManager() {
        return this.m_sourceTreeManager;
    }

    public void setSourceTreeManager(SourceTreeManager mgr) {
        this.m_sourceTreeManager = mgr;
    }

    public final ErrorListener getErrorListener() {
        if (null != this.m_errorListener) {
            return this.m_errorListener;
        }
        ErrorListener retval = null;
        try {
            if (null != this.m_ownerGetErrorListener) {
                retval = (ErrorListener)this.m_ownerGetErrorListener.invoke(this.m_owner, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == retval) {
            if (null == this.m_defaultErrorListener) {
                this.m_defaultErrorListener = new DefaultErrorHandler();
            }
            retval = this.m_defaultErrorListener;
        }
        return retval;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException(XSLMessages.createXPATHMessage(75, null));
        }
        this.m_errorListener = listener;
    }

    public final URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_uriResolver = resolver;
    }

    public final XMLReader getPrimaryReader() {
        return this.m_primaryReader;
    }

    public void setPrimaryReader(XMLReader reader) {
        this.m_primaryReader = reader;
    }

    private void assertion(boolean b, String msg) throws TransformerException {
        ErrorListener errorHandler = this.getErrorListener();
        if (errorHandler != null) {
            errorHandler.fatalError(new TransformerException(XSLMessages.createMessage(30, new Object[]{msg}), (SAXSourceLocator)this.getSAXLocator()));
        }
    }

    public Stack getContextNodeListsStack() {
        return this.m_contextNodeLists;
    }

    public void setContextNodeListsStack(Stack s) {
        this.m_contextNodeLists = s;
    }

    public final DTMIterator getContextNodeList() {
        if (this.m_contextNodeLists.size() > 0) {
            return (DTMIterator)this.m_contextNodeLists.peek();
        }
        return null;
    }

    public final void pushContextNodeList(DTMIterator nl) {
        this.m_contextNodeLists.push(nl);
    }

    public final void popContextNodeList() {
        if (this.m_contextNodeLists.isEmpty()) {
            System.err.println("Warning: popContextNodeList when stack is empty!");
        } else {
            this.m_contextNodeLists.pop();
        }
    }

    public IntStack getCurrentNodeStack() {
        return this.m_currentNodes;
    }

    public void setCurrentNodeStack(IntStack nv) {
        this.m_currentNodes = nv;
    }

    public final int getCurrentNode() {
        return this.m_currentNodes.peek();
    }

    public final void pushCurrentNodeAndExpression(int cn, int en) {
        this.m_currentNodes.push(cn);
        this.m_currentExpressionNodes.push(cn);
    }

    public final void popCurrentNodeAndExpression() {
        this.m_currentNodes.quickPop(1);
        this.m_currentExpressionNodes.quickPop(1);
    }

    public final void pushExpressionState(int cn, int en, PrefixResolver nc) {
        this.m_currentNodes.push(cn);
        this.m_currentExpressionNodes.push(cn);
        this.m_prefixResolvers.push(nc);
    }

    public final void popExpressionState() {
        this.m_currentNodes.quickPop(1);
        this.m_currentExpressionNodes.quickPop(1);
        this.m_prefixResolvers.pop();
    }

    public final void pushCurrentNode(int n) {
        this.m_currentNodes.push(n);
    }

    public final void popCurrentNode() {
        this.m_currentNodes.quickPop(1);
    }

    public final void pushPredicateRoot(int n) {
        this.m_predicateRoots.push(n);
    }

    public final void popPredicateRoot() {
        this.m_predicateRoots.popQuick();
    }

    public final int getPredicateRoot() {
        return this.m_predicateRoots.peepOrNull();
    }

    public final void pushIteratorRoot(int n) {
        this.m_iteratorRoots.push(n);
    }

    public final void popIteratorRoot() {
        this.m_iteratorRoots.popQuick();
    }

    public final int getIteratorRoot() {
        return this.m_iteratorRoots.peepOrNull();
    }

    public IntStack getCurrentExpressionNodeStack() {
        return this.m_currentExpressionNodes;
    }

    public void setCurrentExpressionNodeStack(IntStack nv) {
        this.m_currentExpressionNodes = nv;
    }

    public final int getPredicatePos() {
        return this.m_predicatePos.peek();
    }

    public final void pushPredicatePos(int n) {
        this.m_predicatePos.push(n);
    }

    public final void popPredicatePos() {
        this.m_predicatePos.pop();
    }

    public final int getCurrentExpressionNode() {
        return this.m_currentExpressionNodes.peek();
    }

    public final void pushCurrentExpressionNode(int n) {
        this.m_currentExpressionNodes.push(n);
    }

    public final void popCurrentExpressionNode() {
        this.m_currentExpressionNodes.quickPop(1);
    }

    public final PrefixResolver getNamespaceContext() {
        return (PrefixResolver)this.m_prefixResolvers.peek();
    }

    public final void setNamespaceContext(PrefixResolver pr) {
        this.m_prefixResolvers.setTop(pr);
    }

    public final void pushNamespaceContext(PrefixResolver pr) {
        this.m_prefixResolvers.push(pr);
    }

    public final void pushNamespaceContextNull() {
        this.m_prefixResolvers.push(null);
    }

    public final void popNamespaceContext() {
        this.m_prefixResolvers.pop();
    }

    public Stack getAxesIteratorStackStacks() {
        return this.m_axesIteratorStack;
    }

    public void setAxesIteratorStackStacks(Stack s) {
        this.m_axesIteratorStack = s;
    }

    public final void pushSubContextList(SubContextList iter) {
        this.m_axesIteratorStack.push(iter);
    }

    public final void popSubContextList() {
        this.m_axesIteratorStack.pop();
    }

    public SubContextList getSubContextList() {
        return this.m_axesIteratorStack.isEmpty() ? null : (SubContextList)this.m_axesIteratorStack.peek();
    }

    public LocPathIterator getCurrentNodeList() {
        int i = this.m_axesIteratorStack.size() - 1;
        while (i >= 0) {
            PredicatedNodeTest iter = (PredicatedNodeTest)this.m_axesIteratorStack.elementAt(i);
            LocPathIterator lpi = iter.getLocPathIterator();
            if (lpi.getIsTopLevel()) {
                return lpi;
            }
            --i;
        }
        return null;
    }

    public final int getContextNode() {
        return this.getCurrentNode();
    }

    public final DTMIterator getContextNodes() {
        try {
            DTMIterator cnl = this.getContextNodeList();
            if (null != cnl) {
                return cnl.cloneWithReset();
            }
            return null;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public DTM getGlobalRTFDTM() {
        if (this.m_global_rtfdtm == null || this.m_global_rtfdtm.isTreeIncomplete()) {
            this.m_global_rtfdtm = (SAX2RTFDTM)this.m_dtmManager.getDTM(null, true, null, false, false);
        }
        return this.m_global_rtfdtm;
    }

    public DTM getRTFDTM() {
        SAX2RTFDTM rtfdtm;
        if (this.m_rtfdtm_stack == null) {
            this.m_rtfdtm_stack = new Vector();
            rtfdtm = (SAX2RTFDTM)this.m_dtmManager.getDTM(null, true, null, false, false);
            this.m_rtfdtm_stack.addElement(rtfdtm);
            ++this.m_which_rtfdtm;
        } else if (this.m_which_rtfdtm < 0) {
            rtfdtm = (SAX2RTFDTM)this.m_rtfdtm_stack.elementAt(++this.m_which_rtfdtm);
        } else {
            rtfdtm = (SAX2RTFDTM)this.m_rtfdtm_stack.elementAt(this.m_which_rtfdtm);
            if (rtfdtm.isTreeIncomplete()) {
                if (++this.m_which_rtfdtm < this.m_rtfdtm_stack.size()) {
                    rtfdtm = (SAX2RTFDTM)this.m_rtfdtm_stack.elementAt(this.m_which_rtfdtm);
                } else {
                    rtfdtm = (SAX2RTFDTM)this.m_dtmManager.getDTM(null, true, null, false, false);
                    this.m_rtfdtm_stack.addElement(rtfdtm);
                }
            }
        }
        return rtfdtm;
    }

    public void pushRTFContext() {
        this.m_last_pushed_rtfdtm.push(this.m_which_rtfdtm);
        if (null != this.m_rtfdtm_stack) {
            ((SAX2RTFDTM)this.getRTFDTM()).pushRewindMark();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void popRTFContext() {
        block5: {
            previous = this.m_last_pushed_rtfdtm.pop();
            if (null == this.m_rtfdtm_stack) {
                return;
            }
            if (this.m_which_rtfdtm != previous) ** GOTO lbl10
            if (previous < 0) break block5;
            isEmpty = ((SAX2RTFDTM)this.m_rtfdtm_stack.elementAt(previous)).popRewindMark();
            break block5;
lbl-1000:
            // 1 sources

            {
                isEmpty = ((SAX2RTFDTM)this.m_rtfdtm_stack.elementAt(this.m_which_rtfdtm)).popRewindMark();
                --this.m_which_rtfdtm;
lbl10:
                // 2 sources

                ** while (this.m_which_rtfdtm != previous)
            }
        }
    }

    public class XPathExpressionContext
    implements ExpressionContext {
        public XPathContext getXPathContext() {
            return XPathContext.this;
        }

        public DTMManager getDTMManager() {
            return XPathContext.this.m_dtmManager;
        }

        public Node getContextNode() {
            int context = XPathContext.this.getCurrentNode();
            return XPathContext.this.getDTM(context).getNode(context);
        }

        public NodeIterator getContextNodes() {
            return new DTMNodeIterator(XPathContext.this.getContextNodeList());
        }

        public ErrorListener getErrorListener() {
            return XPathContext.this.getErrorListener();
        }

        public double toNumber(Node n) {
            int nodeHandle = XPathContext.this.getDTMHandleFromNode(n);
            DTM dtm = XPathContext.this.getDTM(nodeHandle);
            XString xobj = (XString)dtm.getStringValue(nodeHandle);
            return xobj.num();
        }

        public String toString(Node n) {
            int nodeHandle = XPathContext.this.getDTMHandleFromNode(n);
            DTM dtm = XPathContext.this.getDTM(nodeHandle);
            XMLString strVal = dtm.getStringValue(nodeHandle);
            return strVal.toString();
        }

        public final XObject getVariableOrParam(QName qname) throws TransformerException {
            return XPathContext.this.m_variableStacks.getVariableOrParam(XPathContext.this, qname);
        }
    }
}

