/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import org.jpedal.Display;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.MultiViewListener;
import org.jpedal.examples.simpleviewer.RecentDocuments;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.popups.AddHeaderFooterToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.CropPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.DeletePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.DownloadProgress;
import org.jpedal.examples.simpleviewer.gui.popups.EncryptPDFDocument;
import org.jpedal.examples.simpleviewer.gui.popups.ErrorDialog;
import org.jpedal.examples.simpleviewer.gui.popups.ExtractPDFPagesNup;
import org.jpedal.examples.simpleviewer.gui.popups.InsertBlankPDFPage;
import org.jpedal.examples.simpleviewer.gui.popups.RotatePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.SaveBitmap;
import org.jpedal.examples.simpleviewer.gui.popups.SaveImage;
import org.jpedal.examples.simpleviewer.gui.popups.SavePDF;
import org.jpedal.examples.simpleviewer.gui.popups.SaveText;
import org.jpedal.examples.simpleviewer.gui.popups.StampImageToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.StampTextToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.TipOfTheDay;
import org.jpedal.examples.simpleviewer.gui.popups.UpdateDialog;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMousePanning;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseSelection;
import org.jpedal.examples.simpleviewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.simpleviewer.utils.Exporter;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.examples.simpleviewer.utils.IconiseImage;
import org.jpedal.examples.simpleviewer.utils.ItextFunctions;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.external.JPedalActionHandler;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.JAITiffHelper;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.actions.DefaultActionHandler;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.SwingWorker;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class Commands {
    public static final int INFO = 1;
    public static final int BITMAP = 2;
    public static final int IMAGES = 3;
    public static final int TEXT = 4;
    public static final int SAVE = 5;
    public static final int PRINT = 6;
    public static final int EXIT = 7;
    public static final int AUTOSCROLL = 8;
    public static final int DOCINFO = 9;
    public static final int OPENFILE = 10;
    public static final int FIND = 12;
    public static final int SNAPSHOT = 13;
    public static final int OPENURL = 14;
    public static final int VISITWEBSITE = 15;
    public static final int PREVIOUSDOCUMENT = 16;
    public static final int NEXTDOCUMENT = 17;
    public static final int PREVIOUSRESULT = 18;
    public static final int NEXTRESULT = 19;
    public static final int TIP = 20;
    public static final int CASCADE = 21;
    public static final int TILE = 22;
    public static final int UPDATE = 23;
    public static final int PREFERENCES = 24;
    public static final int COPY = 25;
    public static final int SELECTALL = 26;
    public static final int DESELECTALL = 27;
    public static final int UPDATEGUILAYOUT = 28;
    public static final int MOUSEMODE = 29;
    public static final int PANMODE = 30;
    public static final int TEXTSELECT = 31;
    public static final int FIRSTPAGE = 50;
    public static final int FBACKPAGE = 51;
    public static final int BACKPAGE = 52;
    public static final int FORWARDPAGE = 53;
    public static final int FFORWARDPAGE = 54;
    public static final int LASTPAGE = 55;
    public static final int GOTO = 56;
    public static final int SINGLE = 57;
    public static final int CONTINUOUS = 58;
    public static final int CONTINUOUS_FACING = 59;
    public static final int FACING = 60;
    public static final int PAGEFLOW = 62;
    public static final int FULLSCREEN = 61;
    public static final int RSS = 997;
    public static final int HELP = 998;
    public static final int BUY = 999;
    public static final int QUALITY = 250;
    public static final int ROTATION = 251;
    public static final int SCALING = 252;
    public static final int SAVEFORM = 500;
    public static final int PDF = 501;
    public static final int ROTATE = 502;
    public static final int DELETE = 503;
    public static final int ADD = 504;
    public static final int SECURITY = 505;
    public static final int ADDHEADERFOOTER = 506;
    public static final int STAMPTEXT = 507;
    public static final int STAMPIMAGE = 508;
    public static final int SETCROP = 509;
    public static final int NUP = 510;
    public static final int HANDOUTS = 511;
    public static final int HIGHLIGHT = 600;
    public static final int SCROLL = 601;
    public static final int ADDVIEW = 700;
    public static final int FORWARD = 701;
    public static final int BACK = 702;
    public static final Integer FIRST_DOCUMENT_SEARCH_RESULT_NOW_SHOWN = new Integer(1);
    public static final Integer SEARCH_RETURNED_TO_START = new Integer(2);
    public static final Integer SEARCH_NOT_FOUND = new Integer(3);
    private boolean allHighlightsShown = false;
    private Values commonValues;
    private SwingGUI currentGUI;
    private PdfDecoder decode_pdf;
    private GUIThumbnailPanel thumbnails;
    Window win;
    private Point screenPosition = null;
    private int tiffImageToLoad = 0;
    private InputStream inputStream = null;
    private JAITiffHelper tiffHelper = null;
    private BufferedImage img = null;
    private int noOfRecentDocs;
    private RecentDocuments recent;
    private JMenuItem[] recentDocuments;
    private final Font headFont = new Font("SansSerif", 1, 10);
    private boolean display = true;
    private PropertiesFile properties;
    private final GUISearchWindow searchFrame;
    private SearchList results;
    private Printer currentPrinter;
    private boolean isOpening;
    private boolean fileIsURL;
    private int lastSearchIndex = 0;
    private boolean openingTransferedFile;
    int startX = 0;
    int startY = 0;
    private MultiViewListener multiViewListener;

    public Commands(Values values, SwingGUI swingGUI, PdfDecoder pdfDecoder, GUIThumbnailPanel gUIThumbnailPanel, PropertiesFile propertiesFile, GUISearchWindow gUISearchWindow, Printer printer) {
        this.commonValues = values;
        this.currentGUI = swingGUI;
        this.decode_pdf = pdfDecoder;
        this.thumbnails = gUIThumbnailPanel;
        this.properties = propertiesFile;
        this.currentPrinter = printer;
        this.noOfRecentDocs = propertiesFile.getNoRecentDocumentsToDisplay();
        this.recentDocuments = new JMenuItem[this.noOfRecentDocs];
        this.recent = new RecentDocuments(this.noOfRecentDocs, propertiesFile);
        this.searchFrame = gUISearchWindow;
    }

    public void addToRecentDocuments(String string) {
        this.recent.addToFileList(string);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object executeCommand(int var1_1, Object[] var2_2) {
        var3_3 = null;
        var5_4 = this.decode_pdf.getJPedalActionHandlers();
        if (var5_4 != null && (var6_5 = (JPedalActionHandler)var5_4.get(new Integer(var1_1))) != null) {
            var6_5.actionPerformed(this.currentGUI, this);
            return null;
        }
        switch (var1_1) {
            case 600: {
                if (var2_2 == null) return var3_3;
                this.decode_pdf.clearHighlights();
                var6_5 = (Rectangle[])var2_2[0];
                var7_8 = (Integer)var2_2[1];
                this.decode_pdf.clearHighlights();
                if (((Object)var6_5).length != 1 || var6_5[0] != null) {
                    this.decode_pdf.addHighlights(new Rectangle[]{var6_5[0]}, true, var7_8);
                }
                this.decode_pdf.invalidate();
                this.decode_pdf.repaint();
                return var3_3;
            }
            case 601: {
                if (var2_2 == null) return var3_3;
                var6_5 = (Rectangle)var2_2[0];
                var7_9 = this.commonValues.getCurrentPage();
                if (var2_2.length > 1 && var2_2[1] != null) {
                    var7_9 = (Integer)var2_2[1];
                }
                if (var6_5 == null) return var3_3;
                this.decode_pdf.scrollRectToHighlight((Rectangle)var6_5, var7_9);
                this.decode_pdf.invalidate();
                this.decode_pdf.repaint();
                return var3_3;
            }
            case 1: {
                if (var2_2 != null) return var3_3;
                this.currentGUI.getInfoBox();
                return var3_3;
            }
            case 2: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.OpenFile"));
                    return var3_3;
                }
                var6_5 = new SaveBitmap(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var7_10 = var6_5.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewer.SaveAsBitmap"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                    return var3_3;
                }
                if (var7_10 != 0) return var3_3;
            }
            case 3: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var6_5 = new SaveImage(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var7_11 = var6_5.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.SaveImagesFromPageRange"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                    return var3_3;
                }
                if (var7_11 != 0) return var3_3;
                var8_21 = new Exporter(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var8_21.extractImagesOnPages((SaveImage)var6_5);
                return var3_3;
            }
            case 4: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                if (!this.decode_pdf.isExtractionAllowed()) {
                    this.currentGUI.showMessageDialog("Not allowed");
                    return var3_3;
                }
                var6_5 = new SaveText(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var7_12 = var6_5.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.SaveTextFromPageRange"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                    return var3_3;
                }
                if (var7_12 != 0) return var3_3;
                var8_22 = new Exporter(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var8_22.extractTextOnPages((SaveText)var6_5);
                return var3_3;
            }
            case 5: {
                if (var2_2 != null) return var3_3;
                this.saveFile();
                return var3_3;
            }
            case 6: {
                this.currentGUI.showMessageDialog("OS version does not support printing");
                return var3_3;
            }
            case 7: {
                if (var2_2 != null) return var3_3;
                v0 = this;
                if (v0.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerStillPrinting.text"));
                    return var3_3;
                }
                this.exit();
                return var3_3;
            }
            case 8: {
                if (var2_2 != null) return var3_3;
                this.currentGUI.toogleAutoScrolling();
                return var3_3;
            }
            case 9: {
                if (var2_2 != null) return var3_3;
                if (!this.commonValues.isPDF()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
                    return var3_3;
                }
                this.currentGUI.showDocumentProperties(this.commonValues.getSelectedFile(), this.commonValues.getInputDir(), this.commonValues.getFileSize(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                return var3_3;
            }
            case 10: {
                this.inputStream = null;
                if (var2_2 == null) {
                    this.handleUnsaveForms();
                    v1 = this;
                    if (v1.currentPrinter.isPrinting()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                        return var3_3;
                    }
                    v2 = this;
                    if (v2.commonValues.isProcessing() || this.isOpening) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                        return var3_3;
                    }
                    if (this.commonValues.isContentExtractor()) {
                        this.currentGUI.setPDFOutlineVisible(false);
                    }
                    this.selectFile();
                    this.fileIsURL = false;
                    return var3_3;
                }
                if (var2_2.length == 2 && var2_2[0] instanceof byte[] && var2_2[1] instanceof String) {
                    var6_5 = (byte[])var2_2[0];
                    var7_13 = (String)var2_2[1];
                    this.commonValues.setFileSize(((Rectangle[])var6_5).length);
                    this.commonValues.setSelectedFile(var7_13);
                    this.currentGUI.setViewerTitle(null);
                    if (this.commonValues.getSelectedFile() == null) return var3_3;
                    v3 = this;
                    if (v3.commonValues.isProcessing() != false) return var3_3;
                    this.decode_pdf.resetViewableArea();
                    try {
                        this.decode_pdf.setPDF(true);
                        this.decode_pdf.setMultiPageTiff(false);
                        var8_23 = System.getProperty("org.jpedal.hires");
                        if (PdfDecoder.hires || var8_23 != null) {
                            this.commonValues.setUseHiresImage(true);
                        }
                        if ((var9_56 = System.getProperty("org.jpedal.memory")) != null) {
                            this.commonValues.setUseHiresImage(false);
                        }
                        this.thumbnails.resetToDefault();
                        this.currentGUI.setNoPagesDecoded();
                        if (this.searchFrame != null) {
                            this.searchFrame.removeSearchWindow(false);
                        }
                        this.commonValues.maxViewY = 0;
                        this.currentGUI.setQualityBoxVisible(this.commonValues.isPDF());
                        this.commonValues.setCurrentPage(1);
                        if (this.currentGUI.isSingle()) {
                            this.decode_pdf.closePdfFile();
                        }
                        this.decode_pdf.openPdfArray((byte[])var6_5);
                        this.currentGUI.updateStatusMessage("opening file");
                        var10_82 = true;
                        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
                            var10_82 = false;
                            var11_108 = System.getProperty("org.jpedal.password");
                            if (var11_108 == null) {
                                var11_108 = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                            }
                            if (var11_108 != null) {
                                this.decode_pdf.setEncryptionPassword(var11_108);
                                if (this.decode_pdf.isFileViewable()) {
                                    var10_82 = true;
                                }
                            }
                            if (!var10_82) {
                                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                            }
                        }
                        if (var10_82) {
                            if (this.properties.getValue("Recentdocuments").equals("true")) {
                                this.properties.addRecentDocument(this.commonValues.getSelectedFile());
                                this.updateRecentDocuments(this.properties.getRecentDocuments());
                            }
                            this.addToRecentDocuments(this.commonValues.getSelectedFile());
                            this.commonValues.setCurrentPage(1);
                        }
                        this.processPage();
                        return var3_3;
                    }
                    catch (PdfException var8_24) {}
                    return var3_3;
                }
                if (var2_2.length != 1) return var3_3;
                if (var2_2[0] instanceof InputStream) {
                    this.inputStream = (InputStream)var2_2[0];
                    this.currentGUI.resetNavBar();
                    var6_5 = "InputStream-" + System.currentTimeMillis() + ".pdf";
                    this.commonValues.setSelectedFile((String)var6_5);
                    this.fileIsURL = true;
                    if (this.inputStream != null) {
                        try {
                            this.commonValues.setFileSize(0L);
                            this.currentGUI.setViewerTitle(null);
                        }
                        catch (Exception var7_14) {
                            var7_14.printStackTrace();
                        }
                        v4 = this;
                        if (v4.commonValues.isProcessing() != false) return var3_3;
                        this.thumbnails.terminateDrawing();
                        this.decode_pdf.flushObjectValues(true);
                        this.decode_pdf.resetViewableArea();
                        this.currentGUI.stopThumbnails();
                        try {
                            this.currentGUI.setUseDownloadWindow(false);
                            this.openFile(this.commonValues.getSelectedFile());
                            while (true) {
                                v5 = this;
                                if (v5.commonValues.isProcessing() == false) return var3_3;
                                Thread.sleep(1000L);
                            }
                        }
                        catch (Exception var7_15) {
                            return var3_3;
                        }
                    }
                    this.decode_pdf.repaint();
                    return var3_3;
                }
                var6_5 = var2_2[0] instanceof File != false ? (File)var2_2[0] : (var2_2[0] instanceof String != false ? new File((String)var2_2[0]) : null);
                if (var6_5 != null) {
                    try {
                        this.commonValues.setInputDir(var6_5.getParentFile().getCanonicalPath());
                        this.open(var6_5.getAbsolutePath());
                        while (true) {
                            v6 = this;
                            if (v6.commonValues.isProcessing() == false) return var3_3;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException var7_16) {
                                var7_16.printStackTrace();
                            }
                        }
                    }
                    catch (IOException var7_17) {
                        return var3_3;
                    }
                }
                this.decode_pdf.repaint();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
                return var3_3;
            }
            case 13: {
                if (var2_2 != null) return var3_3;
                if (this.decode_pdf.getDisplayView() != 1) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
                    return var3_3;
                }
                this.decode_pdf.setExtractingAsImage(true);
                this.decode_pdf.setCursor(Cursor.getPredefinedCursor(1));
                return var3_3;
            }
            case 12: {
                if (var2_2 == null) {
                    if (this.commonValues.getSelectedFile() == null) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                        return var3_3;
                    }
                    if (!this.commonValues.isPDF()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
                        return var3_3;
                    }
                    if (this.decode_pdf.getDisplayView() != 1 && this.decode_pdf.getDisplayView() != 2 && this.decode_pdf.getDisplayView() != 4 && this.decode_pdf.getDisplayView() != 3) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SingleContfacingFacingPageOnly"));
                        return var3_3;
                    }
                    if (!this.searchFrame.isSearchVisible()) {
                        this.searchFrame.find(this.decode_pdf, this.commonValues);
                        return var3_3;
                    }
                    this.searchFrame.grabFocusInInput();
                    return var3_3;
                }
                var6_5 = (String)var2_2[0];
                var7_18 = (Integer)var2_2[1];
                var8_25 = (Boolean)var2_2[2];
                var9_57 = (Boolean)var2_2[3];
                this.allHighlightsShown = (var7_18 & 16) == 16;
                this.searchFrame.findWithoutWindow(this.decode_pdf, this.commonValues, var7_18, var8_25, var9_57, (String)var6_5);
                return var3_3;
            }
            case 14: {
                this.inputStream = null;
                if (var2_2 == null) {
                    this.handleUnsaveForms();
                    this.currentGUI.resetNavBar();
                    var6_5 = this.selectURL();
                    if (var6_5 == null) return var3_3;
                    this.commonValues.setSelectedFile((String)var6_5);
                    this.fileIsURL = true;
                    return var3_3;
                }
                this.currentGUI.resetNavBar();
                var6_5 = (String)var2_2[0];
                if (var6_5 == null) return var3_3;
                this.commonValues.setSelectedFile((String)var6_5);
                this.fileIsURL = true;
                var7_19 = false;
                try {
                    var8_26 = new URL((String)var6_5);
                    var9_58 = var8_26.openConnection();
                    if (var9_58.getContent() == null) {
                        var7_19 = true;
                    }
                }
                catch (Exception var8_27) {
                    var7_19 = true;
                }
                if (var7_19) {
                    var6_5 = null;
                }
                if (var6_5 != null) {
                    try {
                        this.commonValues.setFileSize(0L);
                        this.currentGUI.setViewerTitle(null);
                    }
                    catch (Exception var8_28) {
                        var8_28.printStackTrace();
                    }
                    if (var6_5 == null) return var3_3;
                    v7 = this;
                    if (v7.commonValues.isProcessing() != false) return var3_3;
                    this.thumbnails.terminateDrawing();
                    this.decode_pdf.flushObjectValues(true);
                    this.decode_pdf.resetViewableArea();
                    this.currentGUI.stopThumbnails();
                    if (!this.currentGUI.isSingle()) {
                        this.openNewMultiplePage(this.commonValues.getSelectedFile());
                    }
                    try {
                        this.currentGUI.setUseDownloadWindow(false);
                        this.openFile(this.commonValues.getSelectedFile());
                        while (true) {
                            v8 = this;
                            if (v8.commonValues.isProcessing() == false) return var3_3;
                            Thread.sleep(1000L);
                        }
                    }
                    catch (Exception var8_29) {
                        return var3_3;
                    }
                }
                this.decode_pdf.repaint();
                return var3_3;
            }
            case 998: {
                if (var2_2 != null) return var3_3;
                this.currentGUI.getHelpBox();
                return var3_3;
            }
            case 999: {
                if (var2_2 != null) return var3_3;
                try {
                    BrowserLauncher.openURL("http://www.jpedal.org/pricing.php");
                    return var3_3;
                }
                catch (IOException var6_6) {
                    this.currentGUI.showMessageDialog("Please visit http://www.jpedal.org/pricing.php");
                }
                return var3_3;
            }
            case 997: {
                if (var2_2 != null) return var3_3;
                this.currentGUI.getRSSBox();
                return var3_3;
            }
            case 15: {
                if (var2_2 != null) return var3_3;
                try {
                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                    return var3_3;
                }
                catch (IOException var6_7) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                }
                return var3_3;
            }
            case 20: {
                if (var2_2 != null) return var3_3;
                var6_5 = new TipOfTheDay(this.currentGUI.getFrame(), "/org/jpedal/examples/simpleviewer/res/tips", this.properties);
                var6_5.setVisible(true);
                return var3_3;
            }
            case 21: {
                if (var2_2 != null) return var3_3;
                this.cascade();
                return var3_3;
            }
            case 22: {
                if (var2_2 != null) return var3_3;
                this.tile();
                return var3_3;
            }
            case 23: {
                if (var2_2 != null) return var3_3;
                this.checkForUpdates(true);
                return var3_3;
            }
            case 24: {
                this.currentGUI.showMessageDialog("OS version does not support preferences");
                return var3_3;
            }
            case 25: {
                var6_5 = this.copySelectedText();
                var7_20 = new StringSelection((String)var6_5);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(var7_20, null);
                return var3_3;
            }
            case 26: {
                if (this.decode_pdf.getDisplayView() == 1) {
                    var8_30 = this.decode_pdf.getPdfPageData().getCropBoxHeight(this.commonValues.getCurrentPage());
                    var9_59 = this.decode_pdf.getPdfPageData().getCropBoxWidth(this.commonValues.getCurrentPage());
                    var10_83 = this.decode_pdf.getPdfPageData().getCropBoxX(this.commonValues.getCurrentPage());
                    var11_109 = this.decode_pdf.getPdfPageData().getCropBoxY(this.commonValues.getCurrentPage());
                    this.commonValues.m_x1 = var10_83;
                    this.commonValues.m_x2 = var10_83 + var9_59;
                    this.commonValues.m_y1 = var11_109;
                    this.commonValues.m_y2 = var11_109 + var8_30;
                    var12_129 = new Rectangle(var10_83, var11_109, var9_59, var8_30);
                    this.decode_pdf.updateCursorBoxOnScreen(null, null);
                    this.decode_pdf.clearHighlights();
                    this.decode_pdf.setHighlightedImage(null);
                    this.currentGUI.setRectangle(var12_129);
                    this.decode_pdf.updateCursorBoxOnScreen(var12_129, PdfDecoder.highlightColor);
                    this.decode_pdf.addHighlights(this.decode_pdf.getLineAreas(this.commonValues.getCurrentPage()), true, this.commonValues.getCurrentPage());
                    this.decode_pdf.repaint();
                    return var3_3;
                }
                this.currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
                return var3_3;
            }
            case 27: {
                this.currentGUI.setRectangle(null);
                this.decode_pdf.updateCursorBoxOnScreen(null, null);
                this.decode_pdf.clearHighlights();
                this.decode_pdf.setHighlightedImage(null);
                return var3_3;
            }
            case 28: {
                if (var2_2 == null) return var3_3;
                var8_31 = null;
                var9_60 = false;
                if (var2_2[0] instanceof String) {
                    var8_31 = (String)var2_2[0];
                }
                if (var2_2[1] instanceof Boolean) {
                    var9_60 = (Boolean)var2_2[1];
                }
                if (var8_31 == null) throw new RuntimeException("String input was null");
                this.currentGUI.alterProperty(var8_31, var9_60);
                return var3_3;
            }
            case 29: {
                if (var2_2 != null) return var3_3;
                var8_32 = this.decode_pdf.getMouseMotionListeners();
                var9_61 = this.decode_pdf.getMouseListeners();
                if (var8_32 != null && var8_32.length > 0) {
                    for (var10_84 = 0; var10_84 != var8_32.length; ++var10_84) {
                        if (!(var8_32[var10_84] instanceof SwingMousePanning) && !(var8_32[var10_84] instanceof SwingMouseSelection)) continue;
                        this.decode_pdf.removeMouseMotionListener(var8_32[var10_84]);
                    }
                }
                if (var9_61 != null && var9_61.length > 0) {
                    for (var10_84 = 0; var10_84 != var9_61.length; ++var10_84) {
                        if (!(var9_61[var10_84] instanceof SwingMousePanning) && !(var9_61[var10_84] instanceof SwingMouseSelection)) continue;
                        this.decode_pdf.removeMouseListener(var9_61[var10_84]);
                    }
                }
                if (this.decode_pdf.getMouseMode() == 0) {
                    var10_85 = new SwingMousePanning(this.decode_pdf);
                    var10_85.setupMouse();
                    this.decode_pdf.setMouseMode(1);
                    var11_110 = this.currentGUI.getURLForImage(this.currentGUI.getIconLocation() + "mouse_pan.png");
                    if (var11_110 != null) {
                        var12_130 = new ImageIcon(var11_110);
                        this.currentGUI.mouseMode.setIcon(var12_130);
                    }
                    this.currentGUI.snapshotButton.setEnabled(false);
                    return var3_3;
                }
                if (this.decode_pdf.getMouseMode() != 1) return var3_3;
                var10_86 = new SwingMouseSelection(this.decode_pdf, this.commonValues, ((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler());
                var10_86.setupMouse();
                this.decode_pdf.setMouseMode(0);
                this.decode_pdf.setCursor(Cursor.getDefaultCursor());
                var11_111 = this.currentGUI.getURLForImage(this.currentGUI.getIconLocation() + "mouse_select.png");
                if (var11_111 != null) {
                    var12_131 = new ImageIcon(var11_111);
                    this.currentGUI.mouseMode.setIcon(var12_131);
                }
                this.currentGUI.snapshotButton.setEnabled(true);
                return var3_3;
            }
            case 31: {
                if (var2_2 != null) return var3_3;
                var8_33 = this.decode_pdf.getMouseMotionListeners();
                var9_62 = this.decode_pdf.getMouseListeners();
                if (var8_33 != null && var8_33.length > 0) {
                    for (var10_87 = 0; var10_87 != var8_33.length; ++var10_87) {
                        if (!(var8_33[var10_87] instanceof SwingMousePanning)) continue;
                        this.decode_pdf.removeMouseMotionListener(var8_33[var10_87]);
                    }
                }
                if (var9_62 != null && var9_62.length > 0) {
                    for (var10_87 = 0; var10_87 != var9_62.length; ++var10_87) {
                        if (!(var9_62[var10_87] instanceof SwingMousePanning)) continue;
                        this.decode_pdf.removeMouseListener(var9_62[var10_87]);
                    }
                }
                var10_88 = new SwingMouseSelection(this.decode_pdf, this.commonValues, ((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler());
                var10_88.setupMouse();
                this.decode_pdf.setMouseMode(0);
                var11_112 = this.currentGUI.getURLForImage(this.currentGUI.getIconLocation() + "mouse_select.png");
                if (var11_112 == null) return var3_3;
                var12_132 = new ImageIcon(var11_112);
                this.currentGUI.mouseMode.setIcon(var12_132);
                return var3_3;
            }
            case 30: {
                if (var2_2 != null) return var3_3;
                var8_34 = this.decode_pdf.getMouseMotionListeners();
                var9_63 = this.decode_pdf.getMouseListeners();
                if (var8_34 != null && var8_34.length > 0) {
                    for (var10_89 = 0; var10_89 != var8_34.length; ++var10_89) {
                        if (!(var8_34[var10_89] instanceof SwingMouseSelection)) continue;
                        this.decode_pdf.removeMouseMotionListener(var8_34[var10_89]);
                    }
                }
                if (var9_63 != null && var9_63.length > 0) {
                    for (var10_89 = 0; var10_89 != var9_63.length; ++var10_89) {
                        if (!(var9_63[var10_89] instanceof SwingMouseSelection)) continue;
                        this.decode_pdf.removeMouseListener(var9_63[var10_89]);
                    }
                }
                var10_90 = new SwingMousePanning(this.decode_pdf);
                var10_90.setupMouse();
                this.decode_pdf.setMouseMode(1);
                var11_113 = this.currentGUI.getURLForImage(this.currentGUI.getIconLocation() + "mouse_pan.png");
                if (var11_113 == null) return var3_3;
                var12_133 = new ImageIcon(var11_113);
                this.currentGUI.mouseMode.setIcon(var12_133);
                return var3_3;
            }
            case 16: {
                if (var2_2 != null) return var3_3;
                v9 = this;
                if (v9.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                    return var3_3;
                }
                v10 = this;
                if (v10.commonValues.isProcessing() || this.isOpening) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                    return var3_3;
                }
                var4_137 = this.recent.getPreviousDocument();
                if (var4_137 == null) return var3_3;
                this.open(var4_137);
                return var3_3;
            }
            case 17: {
                if (var2_2 != null) return var3_3;
                v11 = this;
                if (v11.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                    return var3_3;
                }
                v12 = this;
                if (v12.commonValues.isProcessing() || this.isOpening) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                    return var3_3;
                }
                var4_138 = this.recent.getNextDocument();
                if (var4_138 == null) return var3_3;
                this.open(var4_138);
                return var3_3;
            }
            case 18: {
                if (var2_2 == null) {
                    var3_3 = null;
                    this.results = this.searchFrame.getResults(this.commonValues.getCurrentPage());
                    var8_35 = this.results.getSelectedIndex();
                    if (var8_35 < 0) {
                        var8_35 = 0;
                        this.results.setSelectedIndex(var8_35);
                    }
                    var9_64 = new Integer(this.commonValues.getCurrentPage());
                    if (var8_35 == 0) {
                        this.results = this.searchFrame.getResults(var10_91);
                        for (var10_91 = this.commonValues.getCurrentPage() - 1; this.results.getResultCount() < 1 && var10_91 > 0 && this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR; --var10_91) {
                            this.results = this.searchFrame.getResults(var10_91);
                        }
                        if (this.results.getResultCount() < 1 && var10_91 == 0) {
                            this.results = this.searchFrame.getResults(var10_91);
                            var3_3 = Commands.SEARCH_RETURNED_TO_START;
                            for (var10_91 = this.commonValues.getPageCount(); this.results.getResultCount() < 1 && var10_91 > this.commonValues.getCurrentPage() && this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR; --var10_91) {
                                this.results = this.searchFrame.getResults(var10_91);
                            }
                        }
                        var8_35 = this.results.getResultCount() - 1;
                        if (this.results.getResultCount() < 1) {
                            var3_3 = Commands.SEARCH_NOT_FOUND;
                        }
                    } else {
                        --var8_35;
                    }
                    this.results.setSelectedIndex(var8_35);
                    v13 = this;
                    if (!v13.commonValues.isProcessing()) {
                        var10_92 = this.currentGUI.getScaling();
                        var11_114 = this.results.getSelectedIndex();
                        if (!this.allHighlightsShown) {
                            this.decode_pdf.clearHighlights();
                        }
                        if (var11_114 != -1) {
                            var12_134 = new Integer(var11_114);
                            var13_139 = this.results.getTextPages().get(var12_134);
                            if (var13_139 != null) {
                                var14_143 = (Integer)var13_139;
                                if (this.commonValues.getCurrentPage() != var14_143) {
                                    this.commonValues.setCurrentPage(var14_143);
                                    this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + this.commonValues.getCurrentPage());
                                    this.decode_pdf.setPageParameters(var10_92, this.commonValues.getCurrentPage());
                                    this.currentGUI.decodePage(false);
                                    this.decode_pdf.invalidate();
                                }
                                do {
                                    v14 = this;
                                } while (v14.commonValues.isProcessing());
                                var15_146 = null;
                                var16_150 = (Rectangle)this.searchFrame.getTextRectangles().get(var12_134);
                                if (var9_64 != var14_143 && this.allHighlightsShown) {
                                    var17_153 = new Vector_Rectangle();
                                    for (var19_155 = 0; var19_155 != this.results.getModel().getSize(); ++var19_155) {
                                        var18_157 = new Integer(var19_155);
                                        if ((Integer)this.results.getTextPages().get(var18_157) != var14_143) continue;
                                        var20_159 = this.searchFrame.getTextRectangles().get(var18_157);
                                        if (var20_159 instanceof Rectangle) {
                                            var17_153.addElement((Rectangle)var20_159);
                                        }
                                        if (!(var20_159 instanceof Rectangle[])) continue;
                                        var21_161 = (Rectangle[])var20_159;
                                        for (var22_163 = 0; var22_163 != var21_161.length; ++var22_163) {
                                            var17_153.addElement(var21_161[var22_163]);
                                        }
                                    }
                                    var17_153.trim();
                                    var15_146 = var17_153.get();
                                    this.decode_pdf.addHighlights(var15_146, true, var14_143);
                                }
                                this.decode_pdf.scrollRectToHighlight(var16_150, this.commonValues.getCurrentPage());
                                if (!this.allHighlightsShown) {
                                    this.decode_pdf.addHighlights(new Rectangle[]{var16_150}, true, var14_143);
                                }
                                this.decode_pdf.invalidate();
                                this.decode_pdf.repaint();
                            }
                        }
                    }
                    this.currentGUI.hideRedundentNavButtons();
                }
                if (this.commonValues.getCurrentPage() != this.searchFrame.getFirstPageWithResults()) return var3_3;
                if (this.results.getSelectedIndex() != 0) return var3_3;
                return Commands.FIRST_DOCUMENT_SEARCH_RESULT_NOW_SHOWN;
            }
            case 19: {
                if (var2_2 == null) {
                    var3_3 = null;
                    this.results = this.searchFrame.getResults(this.commonValues.getCurrentPage());
                    var8_36 = this.results.getSelectedIndex();
                    if (var8_36 < 0) {
                        var8_36 = 0;
                        this.results.setSelectedIndex(var8_36);
                    }
                    var9_65 = new Integer(this.commonValues.getCurrentPage());
                    if (var8_36 == this.results.getResultCount() - 1 || this.results.getResultCount() == 0) {
                        var8_36 = 0;
                        this.results = this.searchFrame.getResults(var10_93);
                        for (var10_93 = this.commonValues.getCurrentPage() + 1; this.results.getResultCount() < 1 && var10_93 < this.commonValues.getPageCount() + 1 && this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR; ++var10_93) {
                            this.results = this.searchFrame.getResults(var10_93);
                        }
                        if (this.results.getResultCount() < 1 && var10_93 == this.commonValues.getPageCount() + 1) {
                            var3_3 = Commands.SEARCH_RETURNED_TO_START;
                            for (var10_93 = 1; this.results.getResultCount() < 1 && var10_93 < this.commonValues.getCurrentPage() && this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR; ++var10_93) {
                                this.results = this.searchFrame.getResults(var10_93);
                            }
                            if (this.results.getResultCount() < 1) {
                                var3_3 = Commands.SEARCH_NOT_FOUND;
                            }
                        }
                    } else {
                        ++var8_36;
                    }
                    this.results.setSelectedIndex(var8_36);
                    var10_94 = this.currentGUI.getScaling();
                    var11_115 = this.results.getSelectedIndex();
                    if (!this.allHighlightsShown) {
                        this.decode_pdf.clearHighlights();
                    }
                    if (var11_115 != -1) {
                        var12_135 = new Integer(var11_115);
                        var13_140 = this.results.getTextPages().get(var12_135);
                        if (var13_140 != null) {
                            var14_144 = (Integer)var13_140;
                            if (this.commonValues.getCurrentPage() != var14_144) {
                                this.commonValues.setCurrentPage(var14_144);
                                this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + this.commonValues.getCurrentPage());
                                this.decode_pdf.setPageParameters(var10_94, this.commonValues.getCurrentPage());
                                this.currentGUI.decodePage(false);
                                this.decode_pdf.invalidate();
                            }
                            while (true) {
                                v15 = this;
                                if (!v15.commonValues.isProcessing()) break;
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException var15_147) {
                                    var15_147.printStackTrace();
                                }
                            }
                            var15_148 = null;
                            var16_151 = (Rectangle)this.searchFrame.getTextRectangles().get(var12_135);
                            if (var9_65 != null && var9_65 != var14_144 && this.allHighlightsShown) {
                                var17_154 = new Vector_Rectangle();
                                for (var19_156 = 0; var19_156 != this.results.getModel().getSize(); ++var19_156) {
                                    var18_158 = new Integer(var19_156);
                                    if ((Integer)this.results.getTextPages().get(var18_158) != var14_144) continue;
                                    var20_160 = this.searchFrame.getTextRectangles().get(var18_158);
                                    if (var20_160 instanceof Rectangle) {
                                        var17_154.addElement((Rectangle)var20_160);
                                    }
                                    if (!(var20_160 instanceof Rectangle[])) continue;
                                    var21_162 = (Rectangle[])var20_160;
                                    for (var22_164 = 0; var22_164 != var21_162.length; ++var22_164) {
                                        var17_154.addElement(var21_162[var22_164]);
                                    }
                                }
                                var17_154.trim();
                                var15_148 = var17_154.get();
                                this.decode_pdf.addHighlights(var15_148, true, var14_144);
                            }
                            this.decode_pdf.scrollRectToHighlight(var16_151, this.commonValues.getCurrentPage());
                            if (!this.allHighlightsShown) {
                                this.decode_pdf.addHighlights(new Rectangle[]{var16_151}, true, var14_144);
                            }
                            this.decode_pdf.invalidate();
                            this.decode_pdf.repaint();
                        }
                    }
                    this.currentGUI.hideRedundentNavButtons();
                }
                if (this.commonValues.getCurrentPage() != this.searchFrame.getFirstPageWithResults()) return var3_3;
                if (this.results.getSelectedIndex() != 0) return var3_3;
                return Commands.FIRST_DOCUMENT_SEARCH_RESULT_NOW_SHOWN;
            }
            case 50: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) return var3_3;
                if (this.commonValues.getPageCount() <= 1) return var3_3;
                if (this.commonValues.getCurrentPage() == 1) return var3_3;
                this.navigatePages(-(this.commonValues.getCurrentPage() - 1));
                return var3_3;
            }
            case 51: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) return var3_3;
                if (this.commonValues.getCurrentPage() < 10) {
                    this.navigatePages(-(this.commonValues.getCurrentPage() - 1));
                    return var3_3;
                }
                this.navigatePages(-10);
                return var3_3;
            }
            case 52: {
                if (var2_2 == null) {
                    if (this.commonValues.getSelectedFile() == null) return var3_3;
                    this.navigatePages(-1);
                    return var3_3;
                }
                if (this.commonValues.getSelectedFile() != null) {
                    this.navigatePages(-Integer.parseInt((String)var2_2[0]));
                }
                while (true) {
                    v16 = this;
                    if (v16.commonValues.isProcessing() == false) return var3_3;
                }
            }
            case 53: {
                if (var2_2 == null) {
                    if (this.commonValues.getSelectedFile() == null) return var3_3;
                    this.navigatePages(1);
                    return var3_3;
                }
                if (this.commonValues.getSelectedFile() != null) {
                    this.navigatePages(Integer.parseInt((String)var2_2[0]));
                }
                while (true) {
                    v17 = this;
                    if (v17.commonValues.isProcessing() == false) return var3_3;
                }
            }
            case 54: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) return var3_3;
                if (this.commonValues.getPageCount() < this.commonValues.getCurrentPage() + 10) {
                    this.navigatePages(this.commonValues.getPageCount() - this.commonValues.getCurrentPage());
                    return var3_3;
                }
                this.navigatePages(10);
                return var3_3;
            }
            case 55: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) return var3_3;
                if (this.commonValues.getPageCount() <= 1) return var3_3;
                if (this.commonValues.getPageCount() - this.commonValues.getCurrentPage() <= 0) return var3_3;
                this.navigatePages(this.commonValues.getPageCount() - this.commonValues.getCurrentPage());
                return var3_3;
            }
            case 56: {
                if (var2_2 == null) {
                    var8_37 = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewer.EnterPageNumber"), Messages.getMessage("PdfViewer.GotoPage"), 3);
                    if (var8_37 == null) return var3_3;
                    this.gotoPage(var8_37);
                    return var3_3;
                }
                this.gotoPage((String)var2_2[0]);
                return var3_3;
            }
            case 57: {
                if (!this.decode_pdf.isOpen()) {
                    return null;
                }
                if (var2_2 != null) return var3_3;
                this.currentGUI.getCombo(252).setEnabled(true);
                this.currentGUI.alignLayoutMenuOption(1);
                this.decode_pdf.setDisplayView(1, 2);
                this.currentGUI.hideRedundentNavButtons();
                this.currentGUI.resetRotationBox();
                this.currentGUI.getFrame().setMinimumSize(new Dimension(0, 0));
                this.currentGUI.zoom(false);
                return var3_3;
            }
            case 58: {
                if (!this.decode_pdf.isOpen()) {
                    return null;
                }
                if (var2_2 != null) return var3_3;
                this.currentGUI.getCombo(252).setEnabled(true);
                this.currentGUI.alignLayoutMenuOption(2);
                this.decode_pdf.setDisplayView(2, 2);
                this.currentGUI.hideRedundentNavButtons();
                this.currentGUI.setSelectedComboIndex(251, 0);
                this.currentGUI.getFrame().setMinimumSize(new Dimension(0, 0));
                return var3_3;
            }
            case 59: {
                if (!this.decode_pdf.isOpen()) {
                    return null;
                }
                if (var2_2 != null) return var3_3;
                this.currentGUI.getCombo(252).setEnabled(true);
                this.currentGUI.getCombo(252).setID(-1);
                this.currentGUI.setSelectedComboIndex(252, 0);
                this.currentGUI.getCombo(252).setID(252);
                this.currentGUI.zoom(false);
                this.currentGUI.alignLayoutMenuOption(4);
                this.decode_pdf.setDisplayView(4, 2);
                var8_38 = this.commonValues.getCurrentPage();
                if ((var8_38 & 1) == 1 && var8_38 != 1) {
                    --var8_38;
                }
                this.commonValues.setCurrentPage(var8_38);
                this.currentGUI.setPage(var8_38);
                this.currentGUI.hideRedundentNavButtons();
                this.currentGUI.setSelectedComboIndex(251, 0);
                this.currentGUI.getFrame().setMinimumSize(new Dimension(0, 0));
                return var3_3;
            }
            case 60: {
                if (!this.decode_pdf.isOpen()) {
                    return null;
                }
                if (var2_2 != null) return var3_3;
                if (this.decode_pdf.turnoverOn && this.decode_pdf.getPdfPageData().hasMultipleSizes()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.PageDragIrregularSizes"));
                }
                this.currentGUI.getCombo(252).setEnabled(true);
                this.currentGUI.setSelectedComboIndex(252, 0);
                this.currentGUI.zoom(false);
                this.currentGUI.alignLayoutMenuOption(3);
                this.decode_pdf.setDisplayView(3, 2);
                var8_39 = this.commonValues.getCurrentPage();
                if ((var8_39 & 1) == 1 && var8_39 != 1) {
                    --var8_39;
                }
                this.commonValues.setCurrentPage(var8_39);
                this.currentGUI.setPage(var8_39);
                this.currentGUI.hideRedundentNavButtons();
                this.currentGUI.decodePage(false);
                this.currentGUI.setSelectedComboIndex(251, 0);
                this.currentGUI.getFrame().setMinimumSize(new Dimension(0, 0));
                return var3_3;
            }
            case 62: {
                if (!this.decode_pdf.isOpen()) {
                    return null;
                }
                this.searchFrame.removeSearchWindow(false);
                if (var2_2 != null) return var3_3;
                if (!this.decode_pdf.getPdfPageData().hasMultipleSizes()) ** GOTO lbl-1000
                if (PdfDecoder.usePageFlow3D && PdfDecoder.isJava3DAvailable()) lbl-1000:
                // 2 sources

                {
                    v18 = true;
                } else {
                    v18 = var8_40 = false;
                }
                if (!var8_40) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.PageFlow2DIrregularSizes"));
                    return var3_3;
                }
                this.currentGUI.getCombo(252).setEnabled(false);
                if (JAIHelper.isJAIOnClasspath()) ** GOTO lbl813
                if (!PdfDecoder.usePageFlow3D || !PdfDecoder.isJava3DAvailable()) ** GOTO lbl854
lbl813:
                // 2 sources

                if (!PdfDecoder.usePageFlow3D || !PdfDecoder.isJava3DAvailable()) {
                    var9_66 = System.getProperty("org.jpedal.suppressViewerPopups");
                    var10_95 = 0;
                    if (var9_66 != null && var9_66.toLowerCase().equals("true")) {
                        var10_95 = 1;
                    }
                    var11_116 = this.properties.getValue("showpageflow3dsmessage");
                    if (var10_95 == 0 && this.properties != null && var11_116.length() > 0 && var11_116.equals("true")) {
                        var12_136 = new JPanel();
                        var12_136.setLayout(new BoxLayout(var12_136, 1));
                        var13_141 = new JLabel(Messages.getMessage("PdfViewer.PageFlow3DJarsNeeded.Message"));
                        var13_141.setHorizontalTextPosition(0);
                        var12_136.add(var13_141);
                        var14_145 = new MouseAdapter(){

                            public void mouseEntered(MouseEvent mouseEvent) {
                                var12_136.setCursor(new Cursor(12));
                            }

                            public void mouseExited(MouseEvent mouseEvent) {
                                var12_136.setCursor(new Cursor(0));
                            }

                            public void mouseClicked(MouseEvent mouseEvent) {
                                try {
                                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.PageFlow3DJarsNeeded.Link"));
                                }
                                catch (IOException iOException) {
                                    Commands.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                                }
                            }
                        };
                        var15_149 = new JLabel("<html><u>" + Messages.getMessage("PdfViewer.PageFlow3DJarsNeeded.Download") + "</u></html>");
                        var15_149.setForeground(Color.BLUE);
                        var15_149.addMouseListener(var14_145);
                        var15_149.setHorizontalAlignment(0);
                        var12_136.add(var15_149);
                        var16_152 = new Object[]{Messages.getMessage("PdfViewer.PageFlow3DJarsNeeded.Continue")};
                        JOptionPane.showOptionDialog(this.currentGUI.getFrame(), var12_136, Messages.getMessage("PdfViewer.PageFlow3DJarsNeeded.Title"), -1, -1, null, var16_152, var16_152[0]);
                        this.properties.setValue("showpageflow3dsmessage", "false");
                    }
                }
                this.currentGUI.alignLayoutMenuOption(5);
                this.decode_pdf.setDisplayView(5, 2);
                this.currentGUI.hideRedundentNavButtons();
                this.currentGUI.decodePage(false);
                if (this.currentGUI.getSelectedComboIndex(252) != 0) {
                    this.currentGUI.setSelectedComboIndex(252, 0);
                    this.currentGUI.getSelectedComboItem(252);
                }
                if (this.currentGUI.getSelectedComboIndex(252) != 0) return var3_3;
                var9_67 = this.currentGUI.getPdfDecoder().getPdfPageData().getCropBoxWidth(this.currentGUI.getPageNumber()) / 2;
                var10_95 = this.currentGUI.getPdfDecoder().getPdfPageData().getCropBoxHeight(this.currentGUI.getPageNumber()) / 2;
                if (var9_67 > 800) {
                    var9_67 = 800;
                }
                if (var10_95 > 600) {
                    var10_95 = 600;
                }
                this.currentGUI.getFrame().setMinimumSize(new Dimension(var9_67, var10_95));
                return var3_3;
lbl854:
                // 1 sources

                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.PageFlow2DJaiRequired"));
                this.currentGUI.alignLayoutMenuOption(1);
                this.decode_pdf.setDisplayView(1, 2);
                this.currentGUI.hideRedundentNavButtons();
                this.currentGUI.setSelectedComboIndex(251, 0);
                return var3_3;
            }
            case 61: {
                if (var2_2 != null) return var3_3;
                var8_41 = GraphicsEnvironment.getLocalGraphicsEnvironment();
                var9_68 = var8_41.getDefaultScreenDevice();
                if (var9_68.isFullScreenSupported()) {
                    // empty if block
                }
                if (this.win == null) {
                    var10_96 = new Frame(var9_68.getDefaultConfiguration());
                    this.win = new Window((Frame)var10_96);
                } else if (var9_68.getFullScreenWindow() != null && var9_68.getFullScreenWindow().equals(this.win)) {
                    this.exitFullScreen();
                    return var3_3;
                }
                if (this.currentGUI.getFrame() instanceof JFrame) {
                    ((JFrame)this.currentGUI.getFrame()).getContentPane().remove(this.currentGUI.getDisplayPane());
                    this.currentGUI.getFrame().setVisible(false);
                } else {
                    this.currentGUI.getFrame().remove(this.currentGUI.getDisplayPane());
                }
                this.win.add((Component)this.currentGUI.getDisplayPane(), "Center");
                var10_96 = new Button("Return");
                this.win.add(var10_96, "North");
                var10_96.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Commands.this.exitFullScreen();
                    }
                });
                try {
                    this.screenPosition = this.currentGUI.getFrame().getLocation();
                    var9_68.setFullScreenWindow(this.win);
                    this.win.validate();
                    this.currentGUI.zoom(false);
                    return var3_3;
                }
                catch (Error var11_117) {
                    this.currentGUI.showMessageDialog("Full screen mode not supported on this machine.\nJPedal will now exit");
                    this.exit();
                }
                return var3_3;
            }
            case 252: {
                if (var2_2 == null) {
                    v19 = this;
                    if (v19.commonValues.isProcessing() != false) return var3_3;
                    if (this.commonValues.getSelectedFile() == null) return var3_3;
                    var8_42 = this.decode_pdf.getVisibleRect();
                    var9_69 = (var8_42.getX() + var8_42.getWidth() / 2.0) / this.decode_pdf.getBounds().getWidth();
                    var11_118 = (var8_42.getY() + var8_42.getHeight() / 2.0) / this.decode_pdf.getBounds().getHeight();
                    this.currentGUI.zoom(false);
                    var13_142 = new Thread(){

                        public void run() {
                            try {
                                Commands.this.decode_pdf.scrollRectToVisible(new Rectangle((int)(var9_69 * (double)Commands.this.decode_pdf.getWidth() - var8_42.getWidth() / 2.0), (int)(var11_118 * (double)Commands.this.decode_pdf.getHeight() - var8_42.getHeight() / 2.0), (int)Commands.this.decode_pdf.getVisibleRect().getWidth(), (int)Commands.this.decode_pdf.getVisibleRect().getHeight()));
                                Commands.this.decode_pdf.repaint();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    var13_142.start();
                    SwingUtilities.invokeLater(var13_142);
                    return var3_3;
                }
                this.currentGUI.setScalingFromExternal((String)var2_2[0]);
                this.currentGUI.zoom(true);
                while (true) {
                    v20 = this;
                    if (v20.commonValues.isProcessing() == false) return var3_3;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException var8_43) {
                        var8_43.printStackTrace();
                    }
                }
            }
            case 251: {
                if (var2_2 == null) {
                    if (this.commonValues.getSelectedFile() == null) return var3_3;
                    this.currentGUI.rotate();
                    return var3_3;
                }
                var8_44 = Integer.parseInt((String)var2_2[0]);
                while (true) {
                    v21 = this;
                    if (!v21.commonValues.isProcessing()) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException var9_70) {
                        var9_70.printStackTrace();
                    }
                }
                this.currentGUI.setRotationFromExternal(var8_44);
                this.currentGUI.zoom(true);
                return var3_3;
            }
            case 500: {
                if (var2_2 != null) return var3_3;
                this.saveChangedForm();
                return var3_3;
            }
            case 501: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var8_45 = new SavePDF(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var9_71 = var8_45.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.SavePagesAsPdf"));
                if (var9_71 != 0) return var3_3;
                var10_97 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var10_97.extractPagesToNewPDF(var8_45);
                return var3_3;
            }
            case 502: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var8_46 = new RotatePDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var9_72 = var8_46.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerRotation.text"));
                if (var9_72 != 0) return var3_3;
                var10_98 = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                var11_119 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var11_119.rotate(this.commonValues.getPageCount(), var10_98, var8_46);
                this.open(this.commonValues.getSelectedFile());
                return var3_3;
            }
            case 509: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var8_47 = new CropPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var9_73 = var8_47.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTooltip.PDFCropPages"));
                if (var9_73 != 0) return var3_3;
                var10_99 = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                var11_120 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var11_120.setCrop(this.commonValues.getPageCount(), var10_99, var8_47);
                this.open(this.commonValues.getSelectedFile());
                return var3_3;
            }
            case 510: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var8_48 = new ExtractPDFPagesNup(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var9_74 = var8_48.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerNUP.titlebar"));
                if (var9_74 != 0) return var3_3;
                var10_100 = this.decode_pdf.getPdfPageData();
                var11_121 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var11_121.nup(this.commonValues.getPageCount(), var10_100, var8_48);
                return var3_3;
            }
            case 511: {
                if (var2_2 != null) return var3_3;
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                }
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                if (this.fileIsURL != false) return var3_3;
                var8_49 = new JFileChooser();
                var8_49.setFileSelectionMode(0);
                var9_75 = var8_49.showSaveDialog(null);
                if (var9_75 != 0) return var3_3;
                var10_101 = var8_49.getSelectedFile();
                var11_122 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var11_122.handouts(var10_101.getAbsolutePath());
                return var3_3;
            }
            case 503: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var8_50 = new DeletePDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var9_76 = var8_50.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerDelete.text"));
                if (var9_76 != 0) return var3_3;
                var10_102 = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                var11_123 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var11_123.delete(this.commonValues.getPageCount(), var10_102, var8_50);
                this.open(this.commonValues.getSelectedFile());
                return var3_3;
            }
            case 506: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var8_51 = new AddHeaderFooterToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var9_77 = var8_51.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.AddHeaderAndFooters"));
                if (var9_77 != 0) return var3_3;
                var10_103 = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                var11_124 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var11_124.addHeaderFooter(this.commonValues.getPageCount(), var10_103, var8_51);
                this.open(this.commonValues.getSelectedFile());
                return var3_3;
            }
            case 507: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var8_52 = new StampTextToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var9_78 = var8_52.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerStampText.text"));
                if (var9_78 != 0) return var3_3;
                var10_104 = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                var11_125 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var11_125.stampText(this.commonValues.getPageCount(), var10_104, var8_52);
                this.open(this.commonValues.getSelectedFile());
                return var3_3;
            }
            case 508: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var8_53 = new StampImageToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var9_79 = var8_53.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerStampImage.text"));
                if (var9_79 != 0) return var3_3;
                var10_105 = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                var11_126 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var11_126.stampImage(this.commonValues.getPageCount(), var10_105, var8_53);
                this.open(this.commonValues.getSelectedFile());
                return var3_3;
            }
            case 504: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var8_54 = new InsertBlankPDFPage(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var9_80 = var8_54.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewer.BlankPage"));
                if (var9_80 != 0) return var3_3;
                var10_106 = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                var11_127 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var11_127.add(this.commonValues.getPageCount(), var10_106, var8_54);
                this.open(this.commonValues.getSelectedFile());
                return var3_3;
            }
            case 505: {
                if (var2_2 != null) return var3_3;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return var3_3;
                }
                var8_55 = new EncryptPDFDocument(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                var9_81 = var8_55.display(this.currentGUI.getFrame(), "Standard Security");
                if (var9_81 != 0) return var3_3;
                var10_107 = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                var11_128 = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                var11_128.encrypt(this.commonValues.getPageCount(), var10_107, var8_55);
                this.open(this.commonValues.getSelectedFile());
                return var3_3;
            }
            case 702: {
                this.decode_pdf.goBackAView();
                return var3_3;
            }
            case 701: {
                this.decode_pdf.goForwardAView();
                return var3_3;
            }
            case 700: {
                this.decode_pdf.addAView((Integer)var2_2[0], (Rectangle)var2_2[1], (Integer)var2_2[2]);
                return var3_3;
            }
            default: {
                System.out.println("No menu item set");
            }
        }
        return var3_3;
    }

    protected void exitFullScreen() {
        Runnable runnable = new Runnable(){

            public void run() {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                graphicsDevice.setFullScreenWindow(null);
                Commands.this.win.remove(Commands.this.currentGUI.getDisplayPane());
                if (Commands.this.currentGUI.getFrame() instanceof JFrame) {
                    ((JFrame)Commands.this.currentGUI.getFrame()).getContentPane().add((Component)Commands.this.currentGUI.getDisplayPane(), "Center");
                    Commands.this.currentGUI.getFrame().setVisible(true);
                    if (Commands.this.screenPosition != null) {
                        Commands.this.currentGUI.getFrame().setLocation(Commands.this.screenPosition);
                    }
                    Commands.this.screenPosition = null;
                } else {
                    Commands.this.currentGUI.getFrame().add((Component)Commands.this.currentGUI.getDisplayPane(), "Center");
                }
                Commands.this.currentGUI.getDisplayPane().invalidate();
                Commands.this.currentGUI.getDisplayPane().updateUI();
                if (Commands.this.currentGUI.getFrame() instanceof JFrame) {
                    ((JFrame)Commands.this.currentGUI.getFrame()).getContentPane().validate();
                } else {
                    Commands.this.currentGUI.getFrame().validate();
                }
                Commands.this.win.dispose();
                Commands.this.win = null;
                Commands.this.currentGUI.zoom(false);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void cascade() {
        int n;
        JDesktopPane jDesktopPane = this.currentGUI.getMultiViewerFrames();
        JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
        int n2 = 0;
        for (n = jInternalFrameArray.length - 1; n2 < n; ++n2, --n) {
            JInternalFrame jInternalFrame = jInternalFrameArray[n2];
            jInternalFrameArray[n2] = jInternalFrameArray[n];
            jInternalFrameArray[n] = jInternalFrame;
        }
        n2 = 0;
        n = 0;
        int n3 = jDesktopPane.getWidth() / 2;
        int n4 = jDesktopPane.getHeight() / 2;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (jInternalFrameArray[i].isIcon()) continue;
            try {
                jInternalFrameArray[i].setMaximum(false);
                jInternalFrameArray[i].reshape(n2, n, n3, n4);
                jInternalFrameArray[i].setSelected(true);
                n += 25;
                if ((n2 += 25) + n3 > jDesktopPane.getWidth()) {
                    n2 = 0;
                }
                if (n + n4 <= jDesktopPane.getHeight()) continue;
                n = 0;
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void tile() {
        int n;
        JDesktopPane jDesktopPane = this.currentGUI.getMultiViewerFrames();
        JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
        int n2 = 0;
        for (n = 0; n < jInternalFrameArray.length; ++n) {
            if (jInternalFrameArray[n].isIcon()) continue;
            ++n2;
        }
        n = (int)Math.sqrt(n2);
        int n3 = n2 / n;
        int n4 = n2 % n;
        int n5 = jDesktopPane.getWidth() / n3;
        int n6 = jDesktopPane.getHeight() / n;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (jInternalFrameArray[i].isIcon()) continue;
            try {
                jInternalFrameArray[i].setMaximum(false);
                jInternalFrameArray[i].reshape(n8 * n5, n7 * n6, n5, n6);
                if (++n7 != n) continue;
                n7 = 0;
                if (++n8 != n3 - n4) continue;
                n6 = jDesktopPane.getHeight() / ++n;
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private PdfDecoder openNewMultiplePage(String string) {
        PdfDecoder pdfDecoder;
        JDesktopPane jDesktopPane = this.currentGUI.getMultiViewerFrames();
        this.decode_pdf = pdfDecoder = new PdfDecoder(true);
        this.currentGUI.setPdfDecoder(this.decode_pdf);
        this.decode_pdf.setDisplayView(1, 2);
        PdfDecoder.init(true);
        this.decode_pdf.setExtractionMode(0, 72, 1.0f);
        Commands commands = this;
        int n = commands.currentGUI.getPDFDisplayInset();
        this.decode_pdf.setInset(n, n);
        if (this.decode_pdf.useNewGraphicsMode) {
            this.decode_pdf.setBackground(new Color(55, 55, 65));
        } else {
            this.decode_pdf.setBackground(new Color(190, 190, 190));
        }
        this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage(), this.currentGUI.getRotation());
        JInternalFrame jInternalFrame = new JInternalFrame(string, true, true, true, true);
        String string2 = String.valueOf(this.startX);
        jInternalFrame.setName(string2);
        jInternalFrame.setSize(250, 250);
        jInternalFrame.setVisible(true);
        jInternalFrame.setLocation(this.startX, this.startY);
        this.startX += 25;
        this.startY += 25;
        this.multiViewListener = new MultiViewListener(this.decode_pdf, this.currentGUI, this.commonValues, this);
        jInternalFrame.addInternalFrameListener(this.multiViewListener);
        jInternalFrame.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                Container container = component.getParent();
                if (component.getLocation().y < 0) {
                    component.setLocation(component.getLocation().x, 0);
                } else if (component.getLocation().y + component.getSize().height > container.getSize().height + component.getSize().height / 2) {
                    component.setLocation(component.getLocation().x, container.getSize().height - component.getSize().height / 2);
                }
                if (component.getLocation().x < -(component.getSize().width / 2)) {
                    component.setLocation(-(component.getSize().width / 2), component.getLocation().y);
                } else if (component.getLocation().x + component.getSize().width > container.getSize().width + component.getSize().width / 2) {
                    component.setLocation(container.getSize().width - component.getSize().width / 2, component.getLocation().y);
                }
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (Commands.this.decode_pdf.getParent() != null && Commands.this.currentGUI.getSelectedComboIndex(252) < 3) {
                    Commands.this.currentGUI.zoom(false);
                }
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(pdfDecoder);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(80);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        jInternalFrame.getContentPane().add(jScrollPane);
        jDesktopPane.add(string, jInternalFrame);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        jInternalFrame.toFront();
        jInternalFrame.requestFocusInWindow();
        return this.decode_pdf;
    }

    public void openTransferedFile(String string) throws PdfException {
        while (true) {
            if (!this.openingTransferedFile) {
                Commands commands = this;
                if (!commands.commonValues.isProcessing()) break;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.openingTransferedFile = true;
        this.currentGUI.resetNavBar();
        boolean bl = string.startsWith("http:") || string.startsWith("file:");
        try {
            if (!bl) {
                this.fileIsURL = false;
                this.commonValues.setFileSize(new File(string).length() >> 10);
            } else {
                this.fileIsURL = true;
            }
            this.commonValues.setSelectedFile(string);
            this.currentGUI.setViewerTitle(null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting paths");
        }
        File file = new File(this.commonValues.getSelectedFile());
        if (!bl && !file.exists()) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + this.commonValues.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (this.commonValues.getSelectedFile() != null) {
            Commands commands = this;
            if (!commands.commonValues.isProcessing()) {
                if (this.currentGUI.isSingle()) {
                    this.decode_pdf.flushObjectValues(true);
                } else {
                    this.decode_pdf = this.openNewMultiplePage(this.commonValues.getSelectedFile());
                }
                this.decode_pdf.resetViewableArea();
                try {
                    this.openFile(this.commonValues.getSelectedFile());
                }
                catch (PdfException pdfException) {
                    this.openingTransferedFile = false;
                    throw pdfException;
                }
                if (this.commonValues.isPDF()) {
                    this.openingTransferedFile = false;
                }
            }
        }
    }

    public boolean openingTransferedFiles() {
        return this.openingTransferedFile;
    }

    private void saveChangedForm() {
        AcroRenderer acroRenderer = this.decode_pdf.getFormRenderer();
        if (acroRenderer == null) {
            return;
        }
        List list = null;
        try {
            list = acroRenderer.getComponentNameList();
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        if (list == null) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
        } else {
            Object object;
            File file = null;
            String string = "";
            boolean bl = false;
            while (!bl) {
                object = new JFileChooser(this.commonValues.getInputDir());
                ((JFileChooser)object).setSelectedFile(new File(this.commonValues.getInputDir() + '/' + this.commonValues.getSelectedFile()));
                ((JFileChooser)object).addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
                ((JFileChooser)object).addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
                ((JFileChooser)object).setFileSelectionMode(0);
                int n = ((JFileChooser)object).showSaveDialog(null);
                if (n == 0) {
                    int n2;
                    file = ((JFileChooser)object).getSelectedFile();
                    string = file.getAbsolutePath();
                    if (!string.endsWith(".pdf")) {
                        string = string + ".pdf";
                        file = new File(string);
                    }
                    if (string.equals(this.commonValues.getSelectedFile())) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.SaveError"));
                        continue;
                    }
                    if (file.exists() && (n2 = this.currentGUI.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                    bl = true;
                    continue;
                }
                return;
            }
            object = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
            ((ItextFunctions)object).saveFormsData(string);
            this.commonValues.setFormsChanged(false);
            this.currentGUI.setViewerTitle(null);
        }
    }

    public void handleUnsaveForms() {
        int n;
        if (this.commonValues.isFormsChanged() && this.commonValues.isItextOnClasspath() && (n = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerFormsUnsavedOptions.message"), Messages.getMessage("PdfViewerFormsUnsavedWarning.message"), 0)) == 0) {
            this.saveChangedForm();
        }
        this.commonValues.setFormsChanged(false);
    }

    public void extractSelectedScreenAsImage() {
        int n = this.commonValues.m_x1;
        int n2 = this.commonValues.m_x2;
        int n3 = this.commonValues.m_y1;
        int n4 = this.commonValues.m_y2;
        if (this.commonValues.m_y1 < this.commonValues.m_y2) {
            n4 = this.commonValues.m_y1;
            n3 = this.commonValues.m_y2;
        }
        if (this.commonValues.m_x1 > this.commonValues.m_x2) {
            n2 = this.commonValues.m_x1;
            n = this.commonValues.m_x2;
        }
        float f = 100.0f;
        if (PdfDecoder.isRunningOnWindows) {
            f = 100.0f * this.currentGUI.getScaling();
        }
        BufferedImage bufferedImage = this.decode_pdf.getSelectedRectangleOnscreen(n, n3, n2, n4, f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (bufferedImage == null) {
            return;
        }
        Object object = new IconiseImage(bufferedImage);
        jPanel.add((Component)new JLabel((Icon)object), "Center");
        object = new JScrollPane();
        ((JScrollPane)object).getViewport().add(jPanel);
        int n5 = bufferedImage.getWidth();
        if (n5 < bufferedImage.getHeight()) {
            n5 = bufferedImage.getHeight();
        }
        if ((n5 += 50) > 450) {
            n5 = 450;
        }
        Container container = this.currentGUI.getFrame();
        final JDialog jDialog = new JDialog((Frame)null, true);
        if (this.commonValues.getModeOfOperation() != 1) {
            jDialog.setLocationRelativeTo(null);
            jDialog.setLocation(container.getLocationOnScreen().x + 10, container.getLocationOnScreen().y + 10);
        }
        jDialog.setSize(n5, n5);
        jDialog.setTitle(Messages.getMessage("PdfViewerMessage.SaveImage"));
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)object, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jPanel2, "South");
        JButton jButton = new JButton(Messages.getMessage("PdfMessage.Yes"));
        jButton.setFont(new Font("SansSerif", 0, 12));
        jPanel2.add((Component)jButton, "West");
        jButton.addActionListener(new ActionListener((JScrollPane)object, bufferedImage){
            private final /* synthetic */ JScrollPane val$image_scroll;
            private final /* synthetic */ BufferedImage val$snapShot;
            {
                this.val$image_scroll = jScrollPane;
                this.val$snapShot = bufferedImage;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                File file = null;
                String string = "";
                boolean bl = false;
                while (!bl) {
                    JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"tif", "tiff"}, "TIFF"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"jpg", "jpeg"}, "JPEG"));
                    int n = jFileChooser.showSaveDialog(this.val$image_scroll);
                    if (n == 0) {
                        int n2;
                        file = jFileChooser.getSelectedFile();
                        string = file.getAbsolutePath();
                        String string2 = jFileChooser.getFileFilter().getDescription();
                        if (string2.equals("All Files")) {
                            string2 = "TIFF";
                        }
                        if (!string.toLowerCase().endsWith(('.' + string2).toLowerCase())) {
                            string = string + '.' + string2;
                            file = new File(string);
                        }
                        if (file.exists() && (n2 = Commands.this.currentGUI.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                        if (JAIHelper.isJAIused()) {
                            JAIHelper.confirmJAIOnClasspath();
                        }
                        if (this.val$snapShot != null) {
                            if (JAIHelper.isJAIused()) {
                                JAI.create((String)"filestore", (RenderedImage)this.val$snapShot, (Object)string, (Object)string2);
                            } else if (string2.toLowerCase().startsWith("tif")) {
                                Commands.this.currentGUI.showMessageDialog("Please setup JAI library for Tiffs");
                            } else {
                                try {
                                    ImageIO.write((RenderedImage)this.val$snapShot, string2, new File(string));
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                        }
                        bl = true;
                        continue;
                    }
                    return;
                }
                jDialog.dispose();
            }
        });
        JButton jButton2 = new JButton(Messages.getMessage("PdfMessage.No"));
        jButton2.setFont(new Font("SansSerif", 0, 12));
        jPanel2.add((Component)jButton2, "East");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.setVisible(true);
    }

    private static Rectangle adjustHighlightForExtraction(Rectangle rectangle) {
        int n = rectangle.x - 3;
        int n2 = rectangle.y - 3;
        int n3 = rectangle.width + 6;
        int n4 = rectangle.height + 6;
        return new Rectangle(n, n2, n3, n4);
    }

    public String copySelectedText() {
        int n;
        if (!this.decode_pdf.isExtractionAllowed()) {
            this.currentGUI.showMessageDialog("Not allowed");
            return "";
        }
        if (DynamicVectorRenderer.textBasedHighlight) {
            String string = "";
            Rectangle[] rectangleArray = this.decode_pdf.getHighlightedAreas(this.commonValues.getCurrentPage());
            if (rectangleArray == null) {
                return "";
            }
            boolean bl = rectangleArray.length > 1;
            for (int i = 0; i != rectangleArray.length; ++i) {
                int n2;
                rectangleArray[i] = Commands.adjustHighlightForExtraction(rectangleArray[i]);
                int n3 = rectangleArray[i].x;
                int n4 = rectangleArray[i].x + rectangleArray[i].width;
                int n5 = rectangleArray[i].y + rectangleArray[i].height;
                int n6 = rectangleArray[i].y;
                if (n5 < n6) {
                    n2 = n6;
                    n6 = n5;
                    n5 = n2;
                }
                if (n3 > n4) {
                    n2 = n4;
                    n4 = n3;
                    n3 = n2;
                }
                if (n3 < this.currentGUI.cropX) {
                    n3 = this.currentGUI.cropX;
                }
                if (n3 > this.currentGUI.cropW - this.currentGUI.cropX) {
                    n3 = this.currentGUI.cropW - this.currentGUI.cropX;
                }
                if (n4 < this.currentGUI.cropX) {
                    n4 = this.currentGUI.cropX;
                }
                if (n4 > this.currentGUI.cropW - this.currentGUI.cropX) {
                    n4 = this.currentGUI.cropW - this.currentGUI.cropX;
                }
                if (n5 < this.currentGUI.cropY) {
                    n5 = this.currentGUI.cropY;
                }
                if (n5 > this.currentGUI.cropH - this.currentGUI.cropY) {
                    n5 = this.currentGUI.cropH - this.currentGUI.cropY;
                }
                if (n6 < this.currentGUI.cropY) {
                    n6 = this.currentGUI.cropY;
                }
                if (n6 > this.currentGUI.cropH - this.currentGUI.cropY) {
                    n6 = this.currentGUI.cropH - this.currentGUI.cropY;
                }
                this.display = true;
                while (this.display) {
                    String string2 = null;
                    try {
                        PdfGroupingAlgorithms pdfGroupingAlgorithms = null;
                        pdfGroupingAlgorithms = this.decode_pdf.getGroupingObject();
                        this.display = false;
                        string2 = pdfGroupingAlgorithms.extractTextInRectangle(n3, n5, n4, n6, this.commonValues.getCurrentPage(), false, true);
                        if (string2 == null || string2.length() == 0) {
                            if (!bl) {
                                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound"));
                            }
                        } else {
                            string2 = Strip.stripXML(string2).toString();
                        }
                        if (string2 == null) continue;
                        string = string + string2 + '\r' + '\n';
                    }
                    catch (PdfException pdfException) {
                        System.err.println("Exception " + pdfException.getMessage() + " in file " + this.commonValues.getSelectedFile());
                        pdfException.printStackTrace();
                    }
                }
            }
            if (string.length() > 2) {
                return string.substring(0, string.length() - 2);
            }
            return "";
        }
        int n7 = this.commonValues.m_x1;
        int n8 = this.commonValues.m_x2;
        int n9 = this.commonValues.m_y1;
        int n10 = this.commonValues.m_y2;
        if (n9 < n10) {
            n = n10;
            n10 = n9;
            n9 = n;
        }
        if (n7 > n8) {
            n = n8;
            n8 = n7;
            n7 = n;
        }
        if (n7 < this.currentGUI.cropX) {
            n7 = this.currentGUI.cropX;
        }
        if (n7 > this.currentGUI.cropW - this.currentGUI.cropX) {
            n7 = this.currentGUI.cropW - this.currentGUI.cropX;
        }
        if (n8 < this.currentGUI.cropX) {
            n8 = this.currentGUI.cropX;
        }
        if (n8 > this.currentGUI.cropW - this.currentGUI.cropX) {
            n8 = this.currentGUI.cropW - this.currentGUI.cropX;
        }
        if (n9 < this.currentGUI.cropY) {
            n9 = this.currentGUI.cropY;
        }
        if (n9 > this.currentGUI.cropH - this.currentGUI.cropY) {
            n9 = this.currentGUI.cropH - this.currentGUI.cropY;
        }
        if (n10 < this.currentGUI.cropY) {
            n10 = this.currentGUI.cropY;
        }
        if (n10 > this.currentGUI.cropH - this.currentGUI.cropY) {
            n10 = this.currentGUI.cropH - this.currentGUI.cropY;
        }
        this.display = true;
        while (this.display) {
            String string = null;
            try {
                PdfGroupingAlgorithms pdfGroupingAlgorithms = null;
                pdfGroupingAlgorithms = this.decode_pdf.getGroupingObject();
                this.display = false;
                string = pdfGroupingAlgorithms.extractTextInRectangle(n7, n9, n8, n10, this.commonValues.getCurrentPage(), false, true);
                if (string == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound"));
                } else {
                    string = Strip.stripXML(string).toString();
                }
                if (string != null) {
                    return string;
                }
                return "";
            }
            catch (PdfException pdfException) {
                System.err.println("Exception " + pdfException.getMessage() + " in file " + this.commonValues.getSelectedFile());
                pdfException.printStackTrace();
            }
        }
        return "";
    }

    private JScrollPane updateExtractionExample(AbstractButton abstractButton, boolean bl) throws PdfException {
        int n;
        int n2;
        Rectangle[] rectangleArray = this.decode_pdf.getHighlightedAreas(this.commonValues.getCurrentPage());
        if (!DynamicVectorRenderer.textBasedHighlight) {
            rectangleArray = new Rectangle[]{this.currentGUI.getRectangle()};
        }
        JScrollPane jScrollPane = new JScrollPane();
        String string = "";
        for (int i = 0; i != rectangleArray.length; ++i) {
            int n3;
            if (rectangleArray[i] == null) continue;
            rectangleArray[i] = Commands.adjustHighlightForExtraction(rectangleArray[i]);
            n2 = rectangleArray[i].x;
            int n4 = rectangleArray[i].x + rectangleArray[i].width;
            int n5 = rectangleArray[i].y + rectangleArray[i].height;
            n = rectangleArray[i].y;
            if (n5 < n) {
                n3 = n;
                n = n5;
                n5 = n3;
            }
            if (n2 > n4) {
                n3 = n4;
                n4 = n2;
                n2 = n3;
            }
            if (n2 < this.currentGUI.cropX) {
                n2 = this.currentGUI.cropX;
            }
            if (n2 > this.currentGUI.cropW - this.currentGUI.cropX) {
                n2 = this.currentGUI.cropW - this.currentGUI.cropX;
            }
            if (n4 < this.currentGUI.cropX) {
                n4 = this.currentGUI.cropX;
            }
            if (n4 > this.currentGUI.cropW - this.currentGUI.cropX) {
                n4 = this.currentGUI.cropW - this.currentGUI.cropX;
            }
            if (n5 < this.currentGUI.cropY) {
                n5 = this.currentGUI.cropY;
            }
            if (n5 > this.currentGUI.cropH - this.currentGUI.cropY) {
                n5 = this.currentGUI.cropH - this.currentGUI.cropY;
            }
            if (n < this.currentGUI.cropY) {
                n = this.currentGUI.cropY;
            }
            if (n > this.currentGUI.cropH - this.currentGUI.cropY) {
                n = this.currentGUI.cropH - this.currentGUI.cropY;
            }
            if (abstractButton.getText().equals("Table")) {
                string = string + this.extractTextTable(this.decode_pdf.getGroupingObject(), bl, n2, n4, n5, n);
            }
            if (abstractButton.getText().equals("Rectangle")) {
                string = string + this.extractTextRectangle(this.decode_pdf.getGroupingObject(), bl, n2, n4, n5, n) + " ";
            }
            if (!abstractButton.getText().equals("WordList")) continue;
            string = string + this.extractTextList(this.decode_pdf.getGroupingObject(), bl, n2, n4, n5, n);
        }
        if (string.length() != 0) {
            if (abstractButton.getText().equals("Table")) {
                try {
                    jScrollPane = this.currentGUI.createPane(new JTextPane(), string, bl);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            if (abstractButton.getText().equals("Rectangle")) {
                try {
                    jScrollPane = this.currentGUI.createPane(new JTextPane(), string, bl);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            if (abstractButton.getText().equals("WordList")) {
                try {
                    jScrollPane = this.currentGUI.createPane(new JTextPane(), string, bl);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            jScrollPane.setPreferredSize(new Dimension(315, 150));
            jScrollPane.setMinimumSize(new Dimension(315, 150));
            Component[] componentArray = jScrollPane.getComponents();
            for (n2 = 0; n2 != componentArray.length; ++n2) {
                if (!(jScrollPane.getComponent(n2) instanceof JViewport)) continue;
                JViewport jViewport = (JViewport)jScrollPane.getComponent(n2);
                Component[] componentArray2 = jViewport.getComponents();
                for (n = 0; n != componentArray2.length; ++n) {
                    if (!(componentArray2[n] instanceof JTextPane)) continue;
                    ((JTextPane)componentArray2[n]).setEditable(false);
                }
            }
            return jScrollPane;
        }
        return null;
    }

    public void extractSelectedText() {
        if (!this.decode_pdf.isExtractionAllowed()) {
            this.currentGUI.showMessageDialog("Not allowed");
            return;
        }
        Rectangle[] rectangleArray = !DynamicVectorRenderer.textBasedHighlight ? new Rectangle[]{this.currentGUI.getRectangle()} : this.decode_pdf.getHighlightedAreas(this.commonValues.getCurrentPage());
        final Rectangle[] rectangleArray2 = rectangleArray;
        if (rectangleArray2 == null) {
            JOptionPane.showMessageDialog(this.decode_pdf, "There is no text selected.\nPlease highlight the text you wish to extract.", "No Text selected", 0);
            return;
        }
        JScrollPane jScrollPane = new JScrollPane();
        final JPanel jPanel = new JPanel();
        final ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton jRadioButton = new JRadioButton("Extract as Text");
        final JRadioButton jRadioButton2 = new JRadioButton("Extract  as  XML");
        JRadioButton jRadioButton3 = new JRadioButton(Messages.getMessage("PdfViewerRect.label"));
        final JRadioButton jRadioButton4 = new JRadioButton(Messages.getMessage("PdfViewerTable.label"));
        JRadioButton jRadioButton5 = new JRadioButton(Messages.getMessage("PdfViewerWordList.label"));
        final SpringLayout springLayout = new SpringLayout();
        final JFrame jFrame = new JFrame(Messages.getMessage("PdfViewerCoords.message") + ' ' + this.commonValues.m_x1 + " , " + this.commonValues.m_y1 + " , " + (this.commonValues.m_x2 - this.commonValues.m_x1) + " , " + (this.commonValues.m_y2 - this.commonValues.m_y1));
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerDemo.message"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        Object[] objectArray = new Object[]{Messages.getMessage("PdfViewerHelpMenu.text"), Messages.getMessage("PdfViewerCancel.text"), Messages.getMessage("PdfViewerextract.text")};
        JButton jButton = new JButton((String)objectArray[0]);
        JButton jButton2 = new JButton((String)objectArray[1]);
        JButton jButton3 = new JButton((String)objectArray[2]);
        jPanel.setLayout(springLayout);
        final Runnable runnable = new Runnable(){

            public void run() {
                Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    AbstractButton abstractButton = enumeration.nextElement();
                    if (!abstractButton.isSelected()) continue;
                    try {
                        Component[] componentArray = jPanel.getComponents();
                        for (int i = 0; i != componentArray.length; ++i) {
                            if (!(componentArray[i] instanceof JScrollPane)) continue;
                            jPanel.remove(componentArray[i]);
                        }
                        JScrollPane jScrollPane = Commands.this.updateExtractionExample(abstractButton, jRadioButton2.isSelected());
                        if (jScrollPane != null) {
                            springLayout.putConstraint("East", (Component)jScrollPane, -5, "East", (Component)jPanel);
                            springLayout.putConstraint("North", (Component)jScrollPane, 5, "South", (Component)jRadioButton4);
                            jPanel.add(jScrollPane);
                            break;
                        }
                        JLabel jLabel = new JLabel("No Example Available");
                        Font font = jLabel.getFont();
                        font = font.deriveFont(font.getStyle(), 20.0f);
                        jLabel.setFont(font);
                        jLabel.setForeground(Color.RED);
                        springLayout.putConstraint("East", (Component)jLabel, -75, "East", (Component)jPanel);
                        springLayout.putConstraint("North", (Component)jLabel, 50, "South", (Component)jRadioButton4);
                        jPanel.add(jLabel);
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                    break;
                }
                jPanel.updateUI();
            }
        };
        jRadioButton3.setSelected(true);
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRadioButton2.setText("Extract  as  XML");
                jRadioButton.setText("Extract as Text");
                SwingUtilities.invokeLater(runnable);
            }
        });
        buttonGroup.add(jRadioButton3);
        jRadioButton3.setToolTipText(Messages.getMessage("PdfViewerRect.message"));
        springLayout.putConstraint("West", (Component)jRadioButton3, 10, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jRadioButton3, 5, "North", (Component)jPanel);
        jPanel.add(jRadioButton3);
        jRadioButton4.setSelected(true);
        jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRadioButton2.setText("Extract as XHTML");
                jRadioButton.setText("Extract as CSV");
                SwingUtilities.invokeLater(runnable);
            }
        });
        buttonGroup.add(jRadioButton4);
        jRadioButton4.setToolTipText(Messages.getMessage("PdfViewerTable.message"));
        springLayout.putConstraint("West", (Component)jRadioButton4, 50, "East", (Component)jRadioButton3);
        springLayout.putConstraint("North", (Component)jRadioButton4, 5, "North", (Component)jPanel);
        jPanel.add(jRadioButton4);
        jRadioButton5.setSelected(true);
        jRadioButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRadioButton2.setText("Extract  as  XML");
                jRadioButton.setText("Extract as Text");
                SwingUtilities.invokeLater(runnable);
            }
        });
        buttonGroup.add(jRadioButton5);
        jRadioButton5.setToolTipText(Messages.getMessage("PdfViewerWordList.message"));
        springLayout.putConstraint("East", (Component)jRadioButton5, -5, "East", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jRadioButton5, 5, "North", (Component)jPanel);
        jPanel.add(jRadioButton5);
        jScrollPane.setPreferredSize(new Dimension(315, 150));
        jScrollPane.setMinimumSize(new Dimension(315, 150));
        springLayout.putConstraint("East", (Component)jScrollPane, -5, "East", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jScrollPane, 5, "South", (Component)jRadioButton4);
        jPanel.add(jScrollPane);
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(runnable);
            }
        });
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(runnable);
            }
        });
        jRadioButton.setSelected(true);
        springLayout.putConstraint("West", (Component)jRadioButton2, 5, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jRadioButton2, -5, "North", (Component)jButton3);
        jPanel.add(jRadioButton2);
        springLayout.putConstraint("East", (Component)jRadioButton, -5, "East", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jRadioButton, -5, "North", (Component)jButton3);
        jPanel.add(jRadioButton);
        springLayout.putConstraint("South", (Component)jButton3, -5, "North", (Component)jLabel);
        springLayout.putConstraint("East", (Component)jButton3, -5, "East", (Component)jPanel);
        jPanel.add(jButton3);
        springLayout.putConstraint("South", (Component)jButton2, -5, "North", (Component)jLabel);
        springLayout.putConstraint("East", (Component)jButton2, -5, "West", (Component)jButton3);
        jPanel.add(jButton2);
        springLayout.putConstraint("South", (Component)jButton, -5, "North", (Component)jLabel);
        springLayout.putConstraint("East", (Component)jButton, -5, "West", (Component)jButton2);
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea(Messages.getMessage("PdfViewerGroupingInfo.message"));
                Commands.this.currentGUI.showMessageDialog(jTextArea);
                Commands.this.display = true;
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block22: {
                    try {
                        Container container;
                        String string = "";
                        String string2 = "";
                        int n = 0;
                        boolean bl = true;
                        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
                        while (enumeration.hasMoreElements() && !enumeration.nextElement().isSelected()) {
                            ++n;
                        }
                        for (int i = 0; i != rectangleArray2.length; ++i) {
                            int n2;
                            string2 = "";
                            rectangleArray2[i] = Commands.adjustHighlightForExtraction(rectangleArray2[i]);
                            int n3 = rectangleArray2[i].x;
                            int n4 = rectangleArray2[i].x + rectangleArray2[i].width;
                            int n5 = rectangleArray2[i].y + rectangleArray2[i].height;
                            int n6 = rectangleArray2[i].y;
                            if (n5 < n6) {
                                n2 = n6;
                                n6 = n5;
                                n5 = n2;
                            }
                            if (n3 > n4) {
                                n2 = n4;
                                n4 = n3;
                                n3 = n2;
                            }
                            if (n3 < ((Commands)Commands.this).currentGUI.cropX) {
                                n3 = ((Commands)Commands.this).currentGUI.cropX;
                            }
                            if (n3 > ((Commands)Commands.this).currentGUI.cropW - ((Commands)Commands.this).currentGUI.cropX) {
                                n3 = ((Commands)Commands.this).currentGUI.cropW - ((Commands)Commands.this).currentGUI.cropX;
                            }
                            if (n4 < ((Commands)Commands.this).currentGUI.cropX) {
                                n4 = ((Commands)Commands.this).currentGUI.cropX;
                            }
                            if (n4 > ((Commands)Commands.this).currentGUI.cropW - ((Commands)Commands.this).currentGUI.cropX) {
                                n4 = ((Commands)Commands.this).currentGUI.cropW - ((Commands)Commands.this).currentGUI.cropX;
                            }
                            if (n5 < ((Commands)Commands.this).currentGUI.cropY) {
                                n5 = ((Commands)Commands.this).currentGUI.cropY;
                            }
                            if (n5 > ((Commands)Commands.this).currentGUI.cropH - ((Commands)Commands.this).currentGUI.cropY) {
                                n5 = ((Commands)Commands.this).currentGUI.cropH - ((Commands)Commands.this).currentGUI.cropY;
                            }
                            if (n6 < ((Commands)Commands.this).currentGUI.cropY) {
                                n6 = ((Commands)Commands.this).currentGUI.cropY;
                            }
                            if (n6 > ((Commands)Commands.this).currentGUI.cropH - ((Commands)Commands.this).currentGUI.cropY) {
                                n6 = ((Commands)Commands.this).currentGUI.cropH - ((Commands)Commands.this).currentGUI.cropY;
                            }
                            switch (n) {
                                case 0: {
                                    string2 = Commands.this.extractTextRectangle(Commands.this.decode_pdf.getGroupingObject(), jRadioButton2.isSelected(), n3, n4, n5, n6) + '\r' + '\n';
                                    break;
                                }
                                case 1: {
                                    string2 = Commands.this.extractTextTable(Commands.this.decode_pdf.getGroupingObject(), jRadioButton2.isSelected(), n3, n4, n5, n6);
                                    break;
                                }
                                case 2: {
                                    string2 = Commands.this.extractTextList(Commands.this.decode_pdf.getGroupingObject(), jRadioButton2.isSelected(), n3, n4, n5, n6);
                                    break;
                                }
                            }
                            string = string + string2;
                        }
                        if (string == null) break block22;
                        JScrollPane jScrollPane = new JScrollPane();
                        try {
                            container = new JTextPane();
                            jScrollPane = Commands.this.currentGUI.createPane((JTextPane)container, string, bl);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                        jScrollPane.setHorizontalScrollBarPolicy(31);
                        jScrollPane.setVerticalScrollBarPolicy(20);
                        jScrollPane.setPreferredSize(new Dimension(400, 400));
                        container = new JDialog((Frame)null, true);
                        if (Commands.this.commonValues.getModeOfOperation() != 1) {
                            Container container2 = Commands.this.currentGUI.getFrame();
                            ((Window)container).setLocation(container2.getLocationOnScreen().x + 10, container2.getLocationOnScreen().y + 10);
                        }
                        ((Window)container).setSize(450, 450);
                        ((Dialog)container).setTitle(Messages.getMessage("PdfViewerExtractedText.menu"));
                        ((JDialog)container).getContentPane().setLayout(new BorderLayout());
                        ((JDialog)container).getContentPane().add((Component)jScrollPane, "Center");
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BorderLayout());
                        ((JDialog)container).getContentPane().add((Component)jPanel, "South");
                        JButton jButton = new JButton(Messages.getMessage("PdfViewerMenu.return"));
                        jButton.setFont(new Font("SansSerif", 0, 12));
                        jPanel.add((Component)jButton, "West");
                        jButton.addActionListener(new ActionListener((JDialog)container){
                            private final /* synthetic */ JDialog val$displayFrame;
                            {
                                this.val$displayFrame = jDialog;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                Commands.this.display = true;
                                this.val$displayFrame.dispose();
                            }
                        });
                        JButton jButton2 = new JButton(Messages.getMessage("PdfViewerFileMenuExit.text"));
                        jButton2.setFont(new Font("SansSerif", 0, 12));
                        jPanel.add((Component)jButton2, "East");
                        jButton2.addActionListener(new ActionListener((JDialog)container){
                            private final /* synthetic */ JDialog val$displayFrame;
                            {
                                this.val$displayFrame = jDialog;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                this.val$displayFrame.dispose();
                            }
                        });
                        ((Dialog)container).setVisible(true);
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                }
            }
        });
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jFrame.setSize(350, 300);
        SwingUtilities.invokeLater(runnable);
        jFrame.setLocationRelativeTo(this.currentGUI.getFrame());
        jFrame.setResizable(false);
        jFrame.setVisible(true);
    }

    private String extractTextList(PdfGroupingAlgorithms pdfGroupingAlgorithms, boolean bl, int n, int n2, int n3, int n4) throws PdfException {
        Vector vector;
        int n5;
        String string = "";
        PdfGroupingAlgorithms.useUnrotatedCoords = true;
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        int n6 = pdfPageData.getRotation(this.commonValues.getCurrentPage());
        if (n6 != 0 && (n5 = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerRotatedCoords.message"), Messages.getMessage("PdfViewerOutputFormat.message"), 0)) == 0) {
            PdfGroupingAlgorithms.useUnrotatedCoords = false;
        }
        if ((vector = pdfGroupingAlgorithms.extractTextAsWordlist(n, n3, n2, n4, this.commonValues.getCurrentPage(), true, null)) == null) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound") + "\nx1:" + n + " y1:" + n3 + " x2:" + n2 + " y2:" + n4);
        }
        if (vector != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!bl) {
                    string2 = Strip.convertToText(string2);
                }
                int n7 = (int)Float.parseFloat((String)iterator.next());
                int n8 = (int)Float.parseFloat((String)iterator.next());
                int n9 = (int)Float.parseFloat((String)iterator.next());
                int n10 = (int)Float.parseFloat((String)iterator.next());
                stringBuffer.append(string2).append(',').append(n7).append(',').append(n8).append(',').append(n9).append(',').append(n10).append('\n');
            }
            if (stringBuffer.toString() != null) {
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    private String extractTextTable(PdfGroupingAlgorithms pdfGroupingAlgorithms, boolean bl, int n, int n2, int n3, int n4) throws PdfException {
        Map map = !bl ? pdfGroupingAlgorithms.extractTextAsTable(n, n3, n2, n4, this.commonValues.getCurrentPage(), true, false, false, false, 0) : pdfGroupingAlgorithms.extractTextAsTable(n, n3, n2, n4, this.commonValues.getCurrentPage(), false, true, true, false, 1);
        if ((String)map.get("content") != null) {
            return (String)map.get("content");
        }
        return "";
    }

    private String extractTextRectangle(PdfGroupingAlgorithms pdfGroupingAlgorithms, boolean bl, int n, int n2, int n3, int n4) throws PdfException {
        String string = pdfGroupingAlgorithms.extractTextInRectangle(n, n3, n2, n4, this.commonValues.getCurrentPage(), false, true);
        if (string == null) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound") + "\nx1:" + n + " y1:" + n3 + " x2:" + n2 + " y2:" + n4);
            return "";
        }
        if (!bl) {
            string = Strip.stripXML(string).toString();
        }
        return string;
    }

    private void decodeImage(final boolean bl) {
        this.decode_pdf.clearHighlights();
        this.currentGUI.setRectangle(null);
        this.currentGUI.resetComboBoxes(false);
        this.currentGUI.setPageLayoutButtonsEnabled(false);
        this.decode_pdf.getDynamicRenderer().flush();
        this.decode_pdf.clearScreen();
        this.thumbnails.terminateDrawing();
        Values.setProcessing(true);
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Commands.this.currentGUI.updateStatusMessage(Messages.getMessage("PdfViewerDecoding.page"));
                    if (Commands.this.img != null) {
                        Commands.this.decode_pdf.addImage(Commands.this.img);
                    }
                    PdfPageData pdfPageData = Commands.this.decode_pdf.getPdfPageData();
                    if (Commands.this.img != null) {
                        pdfPageData.setMediaBox(new float[]{0.0f, 0.0f, Commands.this.img.getWidth(), Commands.this.img.getHeight()});
                    }
                    pdfPageData.checkSizeSet(1);
                    Commands.this.currentGUI.resetRotationBox();
                    if (bl && Commands.this.thumbnails.isShownOnscreen()) {
                        Commands.this.currentGUI.zoom(false);
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Commands.this.currentGUI.setPageNumber();
                    Commands.this.currentGUI.setViewerTitle(null);
                }
                catch (Exception exception) {
                    Commands.this.currentGUI.setViewerTitle(null);
                }
                Commands.this.currentGUI.setStatusProgress(100);
                Commands.this.currentGUI.resetComboBoxes(true);
                Commands.this.decode_pdf.repaint();
                Commands.this.openingTransferedFile = false;
                return null;
            }
        };
        swingWorker.start();
    }

    protected boolean openUpFile(String string) throws PdfException {
        this.commonValues.maxViewY = 0;
        this.commonValues.setMultiTiff(false);
        boolean bl = true;
        if (this.currentGUI.isSingle()) {
            this.decode_pdf.closePdfFile();
        }
        try {
            if (this.commonValues.isPDF()) {
                block45: {
                    if (this.inputStream != null || string.startsWith("http") || string.startsWith("file:") || string.startsWith("jar:")) {
                        try {
                            boolean bl2 = false;
                            if (this.inputStream != null) {
                                bl2 = true;
                            } else if (this.commonValues.getModeOfOperation() != 1) {
                                bl2 = this.decode_pdf.isPDFLinearized(this.commonValues.getSelectedFile());
                            }
                            if (!bl2) {
                                Point point = null;
                                if (this.commonValues.getModeOfOperation() != 1) {
                                    point = new Point(this.currentGUI.getFrame().getLocationOnScreen().x + this.currentGUI.getFrame().getWidth() / 2, this.currentGUI.getFrame().getLocationOnScreen().y + this.currentGUI.getFrame().getHeight() / 2);
                                }
                                if (this.commonValues.getSelectedFile().startsWith("jar:")) {
                                    InputStream inputStream = this.getClass().getResourceAsStream(this.commonValues.getSelectedFile().substring(4));
                                    this.decode_pdf.openPdfFileFromInputStream(inputStream, false);
                                } else {
                                    DownloadProgress downloadProgress = null;
                                    downloadProgress = new DownloadProgress(this.currentGUI, this.commonValues.getSelectedFile());
                                    while (downloadProgress.isDownloading()) {
                                        this.currentGUI.setDownloadProgress("download", downloadProgress.getProgress());
                                        Thread.sleep(500L);
                                    }
                                    File file = downloadProgress.getFile();
                                    this.decode_pdf.openPdfFile(file.getCanonicalPath());
                                }
                                break block45;
                            }
                            this.currentGUI.setViewerTitle("Loading linearized PDF " + this.commonValues.getSelectedFile());
                            if (this.inputStream != null) {
                                this.decode_pdf.openPdfFileFromInputStream(this.inputStream, true);
                            } else {
                                this.decode_pdf.openPdfFileFromURL(this.commonValues.getSelectedFile(), true);
                            }
                            PdfObject pdfObject = (PdfObject)this.decode_pdf.getJPedalObject(2004845231);
                            int n = pdfObject.getInt(28);
                            String string2 = "Downloading ";
                            string2 = (n /= 1024) < 1024 ? string2 + n + " kB" : string2 + (n /= 1024) + " M";
                            final String string3 = string2;
                            Thread thread = new Thread(){

                                public void run() {
                                    PdfDecoder.LinearThread linearThread = (PdfDecoder.LinearThread)Commands.this.decode_pdf.getJPedalObject(-1276915978);
                                    while (linearThread.isAlive()) {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            interruptedException.printStackTrace();
                                        }
                                        Commands.this.currentGUI.setDownloadProgress(string3, linearThread.getPercentageLoaded());
                                    }
                                    Commands.this.currentGUI.setDownloadProgress(string3, 100);
                                    Commands.this.processPage();
                                }
                            };
                            thread.start();
                        }
                        catch (Exception exception) {
                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.UrlError") + " file=" + string + "\n" + exception.getMessage());
                            string = null;
                            bl = false;
                        }
                    } else {
                        try {
                            this.decode_pdf.openPdfFile(this.commonValues.getSelectedFile());
                        }
                        catch (RuntimeException runtimeException) {
                            this.currentGUI.showMessageDialog(runtimeException.getMessage());
                            LogWriter.writeLog("Exception " + runtimeException.getMessage());
                        }
                        if (this.decode_pdf.getPageCount() > 1 && !this.commonValues.isContentExtractor()) {
                            this.currentGUI.setPageLayoutButtonsEnabled(true);
                        }
                    }
                }
                this.currentGUI.reinitThumbnails();
            } else {
                boolean bl3;
                boolean bl4;
                this.decode_pdf.resetForNonPDFPage();
                this.decode_pdf.setlastPageDecoded(1);
                boolean bl5 = bl4 = string.toLowerCase().indexOf(".tif") != -1;
                if (JAIHelper.isJAIused()) {
                    JAIHelper.confirmJAIOnClasspath();
                }
                boolean bl6 = bl3 = string.startsWith("http:") || string.startsWith("file:");
                if (bl4 && JAIHelper.isJAIused()) {
                    try {
                        this.tiffHelper = new JAITiffHelper(this.commonValues.getSelectedFile());
                        int n = this.tiffHelper.getTiffPageCount();
                        this.tiffImageToLoad = 0;
                        if (n > 1) {
                            this.decode_pdf.setPageCount(n);
                            this.commonValues.setPageCount(n);
                            this.decode_pdf.setlastPageDecoded(1);
                            this.commonValues.setMultiTiff(true);
                            this.decode_pdf.setMultiPageTiff(true);
                        }
                        this.drawMultiPageTiff();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LogWriter.writeLog("Exception " + exception + Messages.getMessage("PdfViewerError.Loading") + this.commonValues.getSelectedFile());
                    }
                } else {
                    boolean bl7;
                    String string4 = this.properties.getValue("showtiffmessage");
                    boolean bl8 = bl7 = bl4 && string4.length() > 0 && string4.equals("true");
                    if (bl7) {
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new GridBagLayout());
                        GridBagConstraints gridBagConstraints = new GridBagConstraints();
                        gridBagConstraints.anchor = 17;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = 0;
                        String string5 = "<html>Some Tiff images do not display correctly without JAI support turned on.  <br>See <a href=\"http://www.jpedal.org/support_JVMOpt.php\"> http://www.jpedal.org/support_JVMOpt.php</a> for information on enabling JAI.";
                        JCheckBox jCheckBox = new JCheckBox();
                        jCheckBox.setText(Messages.getMessage("PdfViewerFormsWarning.CheckBox"));
                        Font font = jCheckBox.getFont();
                        JEditorPane jEditorPane = new JEditorPane();
                        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                                    try {
                                        BrowserLauncher.openURL(hyperlinkEvent.getURL().toExternalForm());
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                }
                            }
                        });
                        jEditorPane.setEditable(false);
                        jEditorPane.setContentType("text/html");
                        jEditorPane.setText(string5);
                        jEditorPane.setOpaque(false);
                        jEditorPane.setFont(font);
                        gridBagConstraints.ipady = 20;
                        jPanel.add((Component)jEditorPane, gridBagConstraints);
                        gridBagConstraints.ipady = 0;
                        gridBagConstraints.gridy = 1;
                        jPanel.add((Component)jCheckBox, gridBagConstraints);
                        JOptionPane.showMessageDialog(this.currentGUI.getFrame(), jPanel);
                        if (jCheckBox.isSelected()) {
                            this.properties.setValue("showtiffmessage", "false");
                        }
                    }
                    try {
                        this.img = bl3 ? ImageIO.read(new URL(string)) : ImageIO.read(new File(string));
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + "loading " + this.commonValues.getSelectedFile());
                    }
                }
            }
            this.currentGUI.updateStatusMessage("opening file");
            if (bl && this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
                bl = false;
                String string6 = System.getProperty("org.jpedal.password");
                if (string6 == null) {
                    string6 = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                }
                if (string6 != null) {
                    this.decode_pdf.setEncryptionPassword(string6);
                    if (this.decode_pdf.isFileViewable()) {
                        bl = true;
                    }
                }
                if (!bl) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                }
            }
            if (bl) {
                if (this.properties.getValue("Recentdocuments").equals("true")) {
                    this.properties.addRecentDocument(this.commonValues.getSelectedFile());
                    this.updateRecentDocuments(this.properties.getRecentDocuments());
                }
                this.recent.addToFileList(this.commonValues.getSelectedFile());
                this.commonValues.setCurrentPage(1);
            }
        }
        catch (PdfException pdfException) {
            System.err.println("Exception " + pdfException + " opening file");
            if (this.currentGUI.isSingle()) {
                if (SimpleViewer.showMessages) {
                    ErrorDialog.showError(pdfException, Messages.getMessage("PdfViewerOpenerror"), this.currentGUI.getFrame(), this.commonValues.getSelectedFile());
                }
                if (SimpleViewer.exitOnClose) {
                    System.exit(1);
                } else {
                    this.currentGUI.getFrame().setVisible(false);
                    if (this.currentGUI.getFrame() instanceof JFrame) {
                        ((JFrame)this.currentGUI.getFrame()).dispose();
                    }
                }
            }
            throw pdfException;
        }
        if (!this.decode_pdf.isOpen() && this.commonValues.isPDF() && this.decode_pdf.getJPedalObject(2004845231) == null) {
            return false;
        }
        return bl;
    }

    public void openFile(String string) throws PdfException {
        String string2;
        this.decode_pdf.setPDF(false);
        this.decode_pdf.setMultiPageTiff(false);
        String string3 = System.getProperty("org.jpedal.hires");
        if (PdfDecoder.hires || string3 != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        this.thumbnails.resetToDefault();
        this.currentGUI.setNoPagesDecoded();
        if (this.searchFrame != null) {
            this.searchFrame.removeSearchWindow(false);
        }
        this.commonValues.maxViewY = 0;
        String string4 = string.toLowerCase().trim();
        this.commonValues.setPDF(string4.endsWith(".pdf") || string4.endsWith(".fdf"));
        this.decode_pdf.setPDF(string4.endsWith(".pdf") || string4.endsWith(".fdf"));
        if (!this.commonValues.isPDF()) {
            this.decode_pdf.setDisplayView(1, 2);
        }
        this.currentGUI.setQualityBoxVisible(this.commonValues.isPDF());
        this.commonValues.setCurrentPage(1);
        try {
            boolean bl = this.openUpFile(this.commonValues.getSelectedFile());
            if (bl) {
                this.processPage();
            } else {
                this.currentGUI.setViewerTitle(Messages.getMessage("PdfViewer.NoFile"));
                this.decode_pdf.clearScreen();
                this.currentGUI.zoom(false);
                this.commonValues.setPageCount(1);
                this.commonValues.setCurrentPage(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.DecodeFile"));
        }
    }

    protected void processPage() {
        if (this.commonValues.isPDF() && (this.decode_pdf.isOpen() || !this.commonValues.isPDF() || this.decode_pdf.getJPedalObject(2004845231) != null)) {
            boolean bl;
            PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
            this.decode_pdf.setRenderMode(3);
            String[] stringArray = pdfFileInformation.getFieldValues();
            String[] stringArray2 = pdfFileInformation.getFieldNames();
            String[] stringArray3 = new String[]{"TeleForm", "dgn2pdf"};
            for (bl = false; bl < stringArray2.length; bl += 1) {
                if (!stringArray2[bl].equals("Creator") && !stringArray2[bl].equals("Producer")) continue;
                for (int i = 0; i < stringArray3.length; ++i) {
                    if (!stringArray[bl].equals(stringArray3[i])) continue;
                    this.decode_pdf.setRenderMode(2);
                }
                if (!stringArray[bl].equals("ABBYY FineReader 8.0 Professional Edition")) continue;
                this.decode_pdf.setRenderMode(35);
            }
            Commands commands = this;
            bl = commands.commonValues.isProcessing();
            Values.setProcessing(true);
            Values.setProcessing(bl);
        }
        if (this.commonValues.isPDF()) {
            this.commonValues.setPageCount(this.decode_pdf.getPageCount());
        } else if (!this.commonValues.isMultiTiff()) {
            this.commonValues.setPageCount(1);
            this.decode_pdf.useHiResScreenDisplay(true);
        }
        if (this.commonValues.getPageCount() < this.commonValues.getCurrentPage()) {
            this.commonValues.setCurrentPage(this.commonValues.getPageCount());
            System.err.println(this.commonValues.getCurrentPage() + " out of range. Opening on last page");
            LogWriter.writeLog(this.commonValues.getCurrentPage() + " out of range. Opening on last page");
        }
        this.decode_pdf.setExtractionMode(1, 72, this.currentGUI.getScaling());
        this.currentGUI.setPageNumber();
        this.currentGUI.resetRotationBox();
        if (this.commonValues.isPDF()) {
            this.currentGUI.messageShown = false;
            this.currentGUI.decodePage(true);
        } else {
            this.currentGUI.zoom(false);
            this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.decode_pdf.disableBorderForPrinting();
            this.decodeImage(true);
            Values.setProcessing(false);
        }
    }

    public void selectFile() {
        if (this.searchFrame != null) {
            this.searchFrame.removeSearchWindow(false);
        }
        this.currentGUI.resetNavBar();
        JFileChooser jFileChooser = new JFileChooser(this.commonValues.getInputDir());
        jFileChooser.setName("chooser");
        if (this.commonValues.getSelectedFile() != null) {
            jFileChooser.setSelectedFile(new File(this.commonValues.getSelectedFile()));
        }
        jFileChooser.setFileSelectionMode(0);
        String[] stringArray = new String[]{"pdf"};
        String[] stringArray2 = new String[]{"fdf"};
        String[] stringArray3 = new String[]{"png", "tif", "tiff", "jpg", "jpeg"};
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray3, "Images (Tiff, Jpeg,Png)"));
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray2, "fdf (*.fdf)"));
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Pdf (*.pdf)"));
        int n = jFileChooser.showOpenDialog(this.currentGUI.getFrame());
        File file = jFileChooser.getSelectedFile();
        if (file != null && n == 0) {
            boolean bl;
            String string = file.getName().toLowerCase();
            boolean bl2 = bl = string.endsWith(".pdf") || string.endsWith(".fdf") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg");
            if (bl) {
                try {
                    this.commonValues.setInputDir(jFileChooser.getCurrentDirectory().getCanonicalPath());
                    this.open(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                this.decode_pdf.repaint();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
            }
        } else {
            this.decode_pdf.repaint();
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
    }

    private String selectURL() {
        boolean bl;
        String string = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.RequestURL"));
        if (string != null) {
            string = string.trim();
        }
        if (!(string == null || string.trim().startsWith("http://") || string.trim().startsWith("https://") || string.trim().startsWith("file:/"))) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.URLMustContain"));
            string = null;
        }
        if (string != null) {
            boolean bl2 = bl = string.endsWith(".pdf") || string.endsWith(".fdf") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg");
            if (!bl) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
                string = null;
            }
        }
        if (string != null) {
            this.commonValues.setSelectedFile(string);
            bl = false;
            try {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection.getContent() == null) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            if (bl) {
                string = null;
                this.currentGUI.showMessageDialog("URL " + string + ' ' + Messages.getMessage("PdfViewerError.DoesNotExist"));
            }
        }
        if (string != null) {
            try {
                this.commonValues.setFileSize(0L);
                this.currentGUI.setViewerTitle(null);
            }
            catch (Exception exception) {
                System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.GettingPaths"));
            }
            if (string != null) {
                Commands commands = this;
                if (!commands.commonValues.isProcessing()) {
                    this.thumbnails.terminateDrawing();
                    this.decode_pdf.flushObjectValues(true);
                    this.decode_pdf.resetViewableArea();
                    this.currentGUI.stopThumbnails();
                    if (!this.currentGUI.isSingle()) {
                        this.openNewMultiplePage(this.commonValues.getSelectedFile());
                    }
                    try {
                        this.openFile(this.commonValues.getSelectedFile());
                    }
                    catch (PdfException pdfException) {}
                }
            }
        } else {
            this.decode_pdf.repaint();
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
        return string;
    }

    private void navigatePages(int n) {
        if (n == 0) {
            return;
        }
        int n2 = this.commonValues.getCurrentPage() + n;
        if (n > 0) {
            if (!this.decode_pdf.isPageAvailable(n2)) {
                this.currentGUI.showMessageDialog("Page " + n2 + " is not yet loaded");
                return;
            }
            if (this.decode_pdf.getDisplayView() == 5) {
                Display display = (Display)this.decode_pdf.getExternalHandler(16);
                display.stopGeneratingPage();
                display.drawBorder();
            }
            Commands commands = this;
            if (!commands.commonValues.isProcessing()) {
                if (n2 <= this.commonValues.getPageCount()) {
                    if (this.commonValues.isMultiTiff()) {
                        this.tiffImageToLoad = this.decode_pdf.getlastPageDecoded() - 1 + n;
                        this.drawMultiPageTiff();
                        this.commonValues.setCurrentPage(n2);
                        this.decode_pdf.setlastPageDecoded(this.tiffImageToLoad + 1);
                        this.currentGUI.setPageNumber();
                        this.decode_pdf.repaint();
                    } else {
                        if (this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) {
                            if (++n2 > this.commonValues.getPageCount()) {
                                n2 = this.commonValues.getPageCount();
                            }
                            if ((n2 & 1) == 1 && n2 != 1) {
                                --n2;
                            }
                            if (this.decode_pdf.getDisplayView() == 3) {
                                n = n2 / 2 - this.commonValues.getCurrentPage() / 2;
                            }
                        }
                        if (n == 1 && this.decode_pdf.turnoverOn && this.decode_pdf.getPageCount() != 2 && this.currentGUI.getPageTurnScalingAppropriate() && this.decode_pdf.getDisplayView() == 3 && n2 / 2 != this.commonValues.getCurrentPage() / 2 && !this.decode_pdf.getPdfPageData().hasMultipleSizes() && !((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().getPageTurnAnimating()) {
                            float f = this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                            float f2 = this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                            if (this.decode_pdf.getPdfPageData().getRotation(1) % 180 == 90) {
                                float f3 = f;
                                f = f2;
                                f2 = f3;
                            }
                            final Point point = new Point();
                            point.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)f);
                            point.y = (int)((float)this.decode_pdf.getInsetH() + f2);
                            final Point point2 = new Point();
                            point2.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)f);
                            point2.y = (int)((float)this.decode_pdf.getInsetH() + f2);
                            final int n3 = n2;
                            Thread thread = new Thread(){

                                public void run() {
                                    int n = 1;
                                    if (point2.x <= point.x) {
                                        point2.x = point.x - 1;
                                    }
                                    double d = point.x - point2.x;
                                    while (point2.getX() >= point.getX()) {
                                        double d2 = (double)n * d * 0.001;
                                        if (d2 > -1.0) {
                                            d2 = -1.0;
                                        }
                                        point2.setLocation(point2.getX() + d2, point2.getY());
                                        Commands.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 999);
                                        if (n < 32) {
                                            n *= 2;
                                        }
                                        try {
                                            Thread.currentThread();
                                            Thread.sleep(50L);
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }
                                    Commands.this.commonValues.setCurrentPage(n3);
                                    Commands.this.currentGUI.setPageNumber();
                                    Commands.this.decode_pdf.setPageParameters(Commands.this.currentGUI.getScaling(), Commands.this.commonValues.getCurrentPage());
                                    Commands.this.currentGUI.decodePage(false);
                                    ((DefaultActionHandler)Commands.this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().setPageTurnAnimating(false);
                                    Commands.this.decode_pdf.setUserOffsets(0, 0, 995);
                                }
                            };
                            ((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().setPageTurnAnimating(true);
                            thread.start();
                        } else {
                            this.commonValues.setCurrentPage(n2);
                            this.currentGUI.setPageNumber();
                            if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 5) {
                                this.currentGUI.decodePage(false);
                                return;
                            }
                            this.currentGUI.resetStatusMessage("Loading Page " + this.commonValues.getCurrentPage());
                            this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
                            if (this.commonValues.isPDF()) {
                                this.currentGUI.decodePage(false);
                            }
                        }
                    }
                }
            } else {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
            }
        } else {
            if (!this.decode_pdf.isPageAvailable(n2)) {
                this.currentGUI.showMessageDialog("Page " + n2 + " is not yet loaded");
                return;
            }
            if (this.decode_pdf.getDisplayView() == 5) {
                Display display = (Display)this.decode_pdf.getExternalHandler(16);
                display.stopGeneratingPage();
                display.drawBorder();
            }
            Commands commands = this;
            if (!commands.commonValues.isProcessing()) {
                if (n2 >= 1) {
                    if (this.commonValues.isMultiTiff()) {
                        this.tiffImageToLoad = this.decode_pdf.getlastPageDecoded() - 1 - n;
                        this.drawMultiPageTiff();
                        this.commonValues.setCurrentPage(n2);
                        this.decode_pdf.setlastPageDecoded(this.tiffImageToLoad + 1);
                        this.currentGUI.setPageNumber();
                        this.decode_pdf.repaint();
                    } else {
                        if (this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) {
                            if (--n2 < 1) {
                                n2 = 1;
                            }
                            if ((n2 & 1) == 1 && n2 != 1) {
                                --n2;
                            }
                            if (this.decode_pdf.getDisplayView() == 3) {
                                n = n2 / 2 - this.commonValues.getCurrentPage() / 2;
                            }
                        }
                        if (n == -1 && this.decode_pdf.turnoverOn && this.decode_pdf.getDisplayView() == 3 && this.currentGUI.getPageTurnScalingAppropriate() && this.decode_pdf.getPageCount() != 2 && (n2 != this.commonValues.getCurrentPage() - 1 || n2 == 1) && !this.decode_pdf.getPdfPageData().hasMultipleSizes() && !((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().getPageTurnAnimating()) {
                            float f = this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                            float f4 = this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                            if (this.decode_pdf.getPdfPageData().getRotation(1) % 180 == 90) {
                                float f5 = f;
                                f = f4;
                                f4 = f5;
                            }
                            final Point point = new Point();
                            point.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)f);
                            point.y = (int)((float)this.decode_pdf.getInsetH() + f4);
                            final Point point3 = new Point();
                            point3.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)f);
                            point3.y = (int)((float)this.decode_pdf.getInsetH() + f4);
                            final int n4 = n2;
                            Thread thread = new Thread(){

                                public void run() {
                                    int n = 1;
                                    if (point3.x >= point.x) {
                                        point3.x = point.x - 1;
                                    }
                                    double d = point.x - point3.x;
                                    while (point3.getX() <= point.getX()) {
                                        double d2 = (double)n * d * 0.001;
                                        if (d2 < 1.0) {
                                            d2 = 1.0;
                                        }
                                        point3.setLocation(point3.getX() + d2, point3.getY());
                                        Commands.this.decode_pdf.setUserOffsets((int)point3.getX(), (int)point3.getY(), 998);
                                        if (n < 32) {
                                            n *= 2;
                                        }
                                        try {
                                            Thread.currentThread();
                                            Thread.sleep(50L);
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }
                                    Commands.this.commonValues.setCurrentPage(n4);
                                    Commands.this.currentGUI.setPageNumber();
                                    Commands.this.decode_pdf.setPageParameters(Commands.this.currentGUI.getScaling(), Commands.this.commonValues.getCurrentPage());
                                    Commands.this.currentGUI.decodePage(false);
                                    Commands.this.decode_pdf.setUserOffsets(0, 0, 995);
                                    ((DefaultActionHandler)Commands.this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().setPageTurnAnimating(false);
                                }
                            };
                            ((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().setPageTurnAnimating(true);
                            thread.start();
                        } else {
                            this.commonValues.setCurrentPage(n2);
                            this.currentGUI.setPageNumber();
                            if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 5) {
                                this.currentGUI.decodePage(false);
                                return;
                            }
                            this.currentGUI.resetStatusMessage("loading page " + this.commonValues.getCurrentPage());
                            this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
                            if (this.commonValues.isPDF()) {
                                this.currentGUI.decodePage(false);
                            }
                        }
                    }
                }
            } else {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
            }
        }
    }

    public void gotoPage(String string) {
        int n;
        string = string.split("/")[0];
        try {
            n = Integer.parseInt(string);
            if (!this.decode_pdf.isPageAvailable(n)) {
                this.currentGUI.showMessageDialog("Page " + n + " is not yet loaded");
                this.currentGUI.pageCounter2.setText(String.valueOf(this.commonValues.getCurrentPage()));
                return;
            }
            if ((this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) && (n & 1) == 1 && n != 1) {
                --n;
            }
            if (n > this.decode_pdf.getPageCount() | n < 1) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPageLabel.text") + ' ' + string + ' ' + Messages.getMessage("PdfViewerOutOfRange.text") + ' ' + this.decode_pdf.getPageCount());
                n = this.commonValues.getCurrentPage();
                this.currentGUI.setPageNumber();
            }
        }
        catch (Exception exception) {
            this.currentGUI.showMessageDialog('>' + string + "< " + Messages.getMessage("PdfViewerInvalidNumber.text"));
            n = this.commonValues.getCurrentPage();
            this.currentGUI.pageCounter2.setText(String.valueOf(this.commonValues.getCurrentPage()));
        }
        this.navigatePages(n - this.commonValues.getCurrentPage());
        if (this.decode_pdf.getDisplayView() == 6) {
            this.navigatePages(0);
        }
    }

    private void open(String string) {
        this.currentGUI.resetNavBar();
        boolean bl = string.startsWith("http:") || string.startsWith("file:");
        try {
            if (!bl) {
                this.fileIsURL = false;
                this.commonValues.setFileSize(new File(string).length() >> 10);
            } else {
                this.fileIsURL = true;
            }
            this.commonValues.setSelectedFile(string);
            this.currentGUI.setViewerTitle(null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting paths");
        }
        File file = new File(this.commonValues.getSelectedFile());
        if (!bl && !file.exists()) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + this.commonValues.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (this.commonValues.getSelectedFile() != null) {
            Commands commands = this;
            if (!commands.commonValues.isProcessing()) {
                if (this.currentGUI.isSingle()) {
                    this.decode_pdf.flushObjectValues(true);
                } else {
                    this.decode_pdf = this.openNewMultiplePage(this.commonValues.getSelectedFile());
                }
                this.decode_pdf.resetViewableArea();
                try {
                    this.openFile(this.commonValues.getSelectedFile());
                }
                catch (PdfException pdfException) {
                    // empty catch block
                }
            }
        }
    }

    public void updateRecentDocuments(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            String string = RecentDocuments.getShortenedFileName(stringArray[i]);
            if (this.recentDocuments[i] == null) {
                this.recentDocuments[i] = new JMenuItem();
            }
            this.recentDocuments[i].setText(i + 1 + ": " + string);
            if (this.recentDocuments[i].getText().equals(i + 1 + ": ")) {
                this.recentDocuments[i].setVisible(false);
            } else {
                this.recentDocuments[i].setVisible(true);
            }
            this.recentDocuments[i].setName(stringArray[i]);
        }
    }

    public void enableRecentDocuments(boolean bl) {
        if (this.recentDocuments == null) {
            return;
        }
        for (int i = 0; i < this.recentDocuments.length; ++i) {
            if (this.recentDocuments[i] == null || this.recentDocuments[i].getText().equals(i + 1 + ": ")) continue;
            this.recentDocuments[i].setVisible(bl);
            this.recentDocuments[i].setEnabled(bl);
        }
    }

    private void drawMultiPageTiff() {
        if (this.tiffHelper != null) {
            this.img = this.tiffHelper.getImage(this.tiffImageToLoad);
            if (this.img != null) {
                this.decode_pdf.getDynamicRenderer().flush();
                this.decode_pdf.addImage(this.img);
            }
        }
    }

    public void recentDocumentsOption(JMenu jMenu) {
        String[] stringArray = this.properties.getRecentDocuments();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < this.noOfRecentDocs; ++i) {
            if (stringArray[i] == null) {
                stringArray[i] = "";
            }
            try {
                String string = stringArray[i];
                String string2 = RecentDocuments.getShortenedFileName(string);
                this.recentDocuments[i] = new JMenuItem(i + 1 + ": " + string2);
                if (this.recentDocuments[i].getText().equals(i + 1 + ": ")) {
                    this.recentDocuments[i].setVisible(false);
                }
                this.recentDocuments[i].setName(string);
                this.recentDocuments[i].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Commands.this.currentPrinter;
                        if (Printer.isPrinting()) {
                            Commands.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                        } else {
                            Commands.this.commonValues;
                            if (Values.isProcessing() || Commands.this.isOpening) {
                                Commands.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                            } else {
                                Commands.this.handleUnsaveForms();
                                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                                String string = jMenuItem.getName();
                                if (string.length() != 0) {
                                    Commands.this.open(string);
                                }
                            }
                        }
                    }
                });
                jMenu.add(this.recentDocuments[i]);
                continue;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Problem with file " + stringArray[i]);
            }
        }
    }

    private void saveFile() {
        File file = null;
        String string = "";
        boolean bl = false;
        while (!bl) {
            JFileChooser jFileChooser = new JFileChooser(this.commonValues.getInputDir());
            jFileChooser.setSelectedFile(new File(this.commonValues.getInputDir() + '/' + this.commonValues.getSelectedFile()));
            jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
            jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showSaveDialog(null);
            if (n == 0) {
                int n2;
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                file = jFileChooser.getSelectedFile();
                string = file.getAbsolutePath();
                if (!string.endsWith(".pdf")) {
                    string = string + ".pdf";
                    file = new File(string);
                }
                if (string.equals(this.commonValues.getSelectedFile())) {
                    return;
                }
                if (file.exists() && (n2 = this.currentGUI.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                try {
                    int n3;
                    fileInputStream = new FileInputStream(this.commonValues.getSelectedFile());
                    fileOutputStream = new FileOutputStream(string);
                    byte[] byArray = new byte[4096];
                    while ((n3 = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n3);
                    }
                }
                catch (Exception exception) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerException.NotSaveInternetFile"));
                }
                try {
                    fileInputStream.close();
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl = true;
                continue;
            }
            return;
        }
    }

    private void exit() {
        this.thumbnails.terminateDrawing();
        this.handleUnsaveForms();
        this.currentGUI.showConfirmDialog(new JLabel(Messages.getMessage("PdfViewerExiting")), Messages.getMessage("PdfViewerprogramExit"), -1, -1);
        this.decode_pdf.closePdfFile();
        this.flush();
        try {
            this.properties.setValue("lastDocumentPage", String.valueOf(this.commonValues.getCurrentPage()));
            this.properties.writeDoc();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!SimpleViewer.exitOnClose) {
            this.currentGUI.getFrame().setVisible(false);
            if (this.currentGUI.getFrame() instanceof JFrame) {
                ((JFrame)this.currentGUI.getFrame()).dispose();
            }
        } else {
            System.exit(1);
        }
    }

    public final void flush() {
        File file;
        String[] stringArray;
        String string = this.commonValues.getTarget();
        if (string != null && (stringArray = (file = new File(string)).list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string + this.commonValues.getSeparator() + stringArray[i]);
                file2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdates(boolean bl) {
        boolean bl2 = true;
        boolean bl3 = false;
        try {
            block9: {
                try {
                    String string = null;
                    string = "http://www.jpedal.org/version.txt";
                    if (string == null) break block9;
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    String string2 = bufferedReader.readLine();
                    bufferedReader.close();
                    string2 = string2.substring(0, 7);
                    String string3 = "4.22b16".substring(0, 7);
                    boolean bl4 = false;
                    String[] stringArray = string2.split("b");
                    String[] stringArray2 = string3.split("b");
                    if (Double.parseDouble(stringArray[0]) > Double.parseDouble(stringArray2[0]) || stringArray[0].equals(stringArray2[0]) && Integer.parseInt(stringArray[1]) > Integer.parseInt(stringArray2[1])) {
                        bl4 = true;
                    }
                    if (bl4) {
                        UpdateDialog updateDialog = new UpdateDialog(this.currentGUI.getFrame(), string3, string2);
                        updateDialog.setVisible(true);
                        bl3 = true;
                        break block9;
                    }
                    if (!bl) break block9;
                    this.currentGUI.showMessageDialog("The current version is up to date", "Up to date", 1);
                }
                catch (Exception exception) {
                    bl2 = false;
                    Object var15_16 = null;
                    if (!bl2 && bl) {
                        this.currentGUI.showMessageDialog("Error making connection so unable to check for updates", "Error", 0);
                    }
                }
            }
            Object var15_15 = null;
            if (!bl2 && bl) {
                this.currentGUI.showMessageDialog("Error making connection so unable to check for updates", "Error", 0);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (!bl2 && bl) {
                this.currentGUI.showMessageDialog("Error making connection so unable to check for updates", "Error", 0);
            }
            throw throwable;
        }
        return bl3;
    }

    public void setPdfDecoder(PdfDecoder pdfDecoder) {
        this.decode_pdf = pdfDecoder;
    }

    public void setPageProperties(Object object, Object object2) {
        if (this.multiViewListener != null) {
            this.multiViewListener.setPageProperties(object, object2);
        }
    }

    public void clearRecentDocuments() {
        this.properties.removeRecentDocuments();
        for (int i = 0; i < this.noOfRecentDocs; ++i) {
            this.recentDocuments[i].setText(i + 1 + ": ");
            this.recentDocuments[i].setVisible(false);
        }
    }

    public SearchList getSearchList() {
        return this.searchFrame.getResults();
    }
}

