/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.Paper;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.PageRanges;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.paper.PaperSizes;
import org.jpedal.objects.PrinterOptions;
import org.jpedal.utils.Messages;

public class PrintPanel
extends JPanel {
    int pageCount;
    int currentPage;
    private boolean okClicked = false;
    private String[] printersList;
    private PaperSizes paperDefinitions = new PaperSizes();
    private boolean isFirstTime = true;
    private JCheckBox autoRotateCenter;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JButton okButton;
    private JPanel pageHandlingPanel;
    private JComboBox pageSize;
    private JTextField pagesFrom;
    private JTextField pagesTo;
    private JCheckBox paperSourceByPDF;
    private JSpinner printHandlingCopies;
    private JComboBox printHandlingScaling;
    private JRadioButton printRangeAll;
    private JRadioButton printRangeCurrentPage;
    private JRadioButton printRangeCurrentView;
    private JRadioButton printRangeFrom;
    private JPanel printRangePanel;
    private JCheckBox printRangeReversePages;
    private JComboBox printRangeSubset;
    private JCheckBox printToFile;
    private JComboBox printerName;
    private JPanel printerPanel;

    public PrintPanel(String[] stringArray, String string, int n, int n2) {
        this.resetDefaults(stringArray, string, n, n2);
        this.isFirstTime = false;
    }

    public void resetDefaults(String[] stringArray, String string, int n, int n2) {
        int n3;
        String[] stringArray2;
        this.printersList = stringArray;
        this.pageCount = n;
        this.currentPage = n2;
        this.initComponents();
        String string2 = System.getProperty("org.jpedal.printPaperSize");
        if (string2 != null) {
            stringArray2 = this.paperDefinitions.getAvailablePaperSizes();
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                if (!string2.equals(stringArray2[n3])) continue;
                this.pageSize.setSelectedItem(stringArray2[n3]);
            }
        }
        if ((stringArray2 = System.getProperty("org.jpedal.defaultPrinter")) != null) {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (!stringArray2.equals(stringArray[n3])) continue;
                this.printerName.setSelectedItem(stringArray[n3]);
            }
        } else {
            this.printerName.setSelectedItem(string);
        }
    }

    private void initComponents() {
        if (this.isFirstTime) {
            this.buttonGroup1 = new ButtonGroup();
            this.printerPanel = new JPanel();
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.printerName = new JComboBox();
            this.pageSize = new JComboBox();
            this.printRangePanel = new JPanel();
            this.pagesFrom = new JTextField();
            this.printRangeCurrentPage = new JRadioButton();
            this.printRangeAll = new JRadioButton();
            this.printRangeCurrentView = new JRadioButton();
            this.printRangeFrom = new JRadioButton();
            this.jLabel4 = new JLabel();
            this.printRangeSubset = new JComboBox();
            this.printRangeReversePages = new JCheckBox();
            this.jLabel7 = new JLabel();
            this.pagesTo = new JTextField();
            this.pageHandlingPanel = new JPanel();
            this.jLabel8 = new JLabel();
            this.printHandlingCopies = new JSpinner();
            this.jLabel9 = new JLabel();
            this.printHandlingScaling = new JComboBox();
            this.autoRotateCenter = new JCheckBox();
            this.paperSourceByPDF = new JCheckBox();
            this.printToFile = new JCheckBox();
            this.okButton = new JButton();
            this.cancelButton = new JButton();
        } else {
            this.removeAll();
        }
        this.setLayout(null);
        this.printerPanel.setLayout(null);
        this.printerPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getMessage("PdfViewerLabel.Printer"), 0, 0, new Font("Tahoma", 0, 11), new Color(0, 0, 255)));
        this.jLabel1.setText(Messages.getMessage("PdfViewerPrint.Name"));
        this.printerPanel.add(this.jLabel1);
        this.jLabel1.setBounds(10, 20, 60, 14);
        this.jLabel2.setText(Messages.getMessage("PdfViewerPrint.PageSize"));
        this.printerPanel.add(this.jLabel2);
        this.jLabel2.setBounds(10, 50, 70, 14);
        this.printerName.setModel(new DefaultComboBoxModel<String>(this.printersList));
        this.printerPanel.add(this.printerName);
        this.printerName.setBounds(80, 20, 220, 22);
        this.pageSize.setModel(new DefaultComboBoxModel<String>(this.getAvailablePaperSizes()));
        this.pageSize.setSelectedIndex(this.paperDefinitions.getDefaultPageIndex());
        this.printerPanel.add(this.pageSize);
        this.pageSize.setBounds(80, 50, 220, 22);
        this.add(this.printerPanel);
        this.printerPanel.setBounds(10, 10, 420, 90);
        this.printRangePanel.setLayout(null);
        this.printRangePanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getMessage("PdfViewerLabel.PrintRange"), 0, 0, new Font("Tahoma", 0, 11), new Color(0, 0, 255)));
        this.pagesFrom.setText("1");
        this.pagesFrom.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PrintPanel.this.pagesBoxPressed(mouseEvent);
            }
        });
        this.printRangePanel.add(this.pagesFrom);
        this.pagesFrom.setBounds(130, 80, 60, 19);
        this.buttonGroup1.add(this.printRangeCurrentPage);
        this.printRangeCurrentPage.setText(Messages.getMessage("PdfViewerRadioButton.CurrentPage"));
        this.printRangeCurrentPage.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeCurrentPage.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeCurrentPage.setOpaque(false);
        this.printRangeCurrentPage.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PrintPanel.this.currentPageStateChanged(itemEvent);
            }
        });
        this.printRangePanel.add(this.printRangeCurrentPage);
        this.printRangeCurrentPage.setBounds(10, 60, 120, 15);
        this.buttonGroup1.add(this.printRangeAll);
        this.printRangeAll.setSelected(true);
        this.printRangeAll.setText(Messages.getMessage("PdfViewerRadioButton.All"));
        this.printRangeAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeAll.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeAll.setOpaque(false);
        if (this.isFirstTime) {
            this.printRangeAll.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    PrintPanel.this.allStateChanged(itemEvent);
                }
            });
        }
        this.printRangePanel.add(this.printRangeAll);
        this.printRangeAll.setBounds(10, 20, 70, 15);
        this.buttonGroup1.add(this.printRangeCurrentView);
        this.printRangeCurrentView.setText(Messages.getMessage("PdfViewerPrint.CurrentView"));
        this.printRangeCurrentView.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeCurrentView.setEnabled(true);
        this.printRangeCurrentView.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeCurrentView.setOpaque(false);
        this.printRangePanel.add(this.printRangeCurrentView);
        this.printRangeCurrentView.setBounds(10, 40, 140, 15);
        if (this.isFirstTime) {
            this.printRangeCurrentView.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    PrintPanel.this.printRangeCurrentView(itemEvent);
                }
            });
        }
        this.buttonGroup1.add(this.printRangeFrom);
        this.printRangeFrom.setText(Messages.getMessage("PdfViewerPrint.PagesFrom"));
        this.printRangeFrom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeFrom.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeFrom.setOpaque(false);
        if (this.isFirstTime) {
            this.printRangeFrom.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    PrintPanel.this.pagesFromStateChanged(itemEvent);
                }
            });
        }
        this.printRangePanel.add(this.printRangeFrom);
        this.printRangeFrom.setBounds(10, 80, 140, 15);
        this.jLabel4.setText(Messages.getMessage("PdfViewerPrint.Subset"));
        this.printRangePanel.add(this.jLabel4);
        this.jLabel4.setBounds(10, 110, 100, 14);
        this.printRangeSubset.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getMessage("PdfViewerPrint.AllPagesInRange"), Messages.getMessage("PdfViewerPrint.OddPagesOnly"), Messages.getMessage("PdfViewerPrint.EvenPagesOnly")}));
        this.printRangePanel.add(this.printRangeSubset);
        this.printRangeSubset.setBounds(130, 110, 190, 22);
        this.printRangeReversePages.setText(Messages.getMessage("PdfViewerPrint.ReversePages"));
        this.printRangeReversePages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeReversePages.setMargin(new Insets(0, 0, 0, 0));
        this.printRangePanel.add(this.printRangeReversePages);
        this.printRangeReversePages.setBounds(335, 110, 120, 15);
        this.jLabel7.setText(Messages.getMessage("PdfViewerPrint.PagesTo"));
        this.printRangePanel.add(this.jLabel7);
        this.jLabel7.setBounds(210, 80, 30, 14);
        this.pagesTo.setText(String.valueOf(this.pageCount));
        if (this.isFirstTime) {
            this.pagesTo.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    PrintPanel.this.pagesBoxPressed(mouseEvent);
                }
            });
        }
        this.printRangePanel.add(this.pagesTo);
        this.pagesTo.setBounds(240, 80, 60, 19);
        this.add(this.printRangePanel);
        this.printRangePanel.setBounds(10, 100, 460, 140);
        this.pageHandlingPanel.setLayout(null);
        this.pageHandlingPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getMessage("PdfViewerLabel.PageHandling"), 0, 0, new Font("Tahoma", 0, 11), new Color(0, 0, 255)));
        this.jLabel8.setText(Messages.getMessage("PdfViewerPrint.Copies"));
        this.pageHandlingPanel.add(this.jLabel8);
        this.jLabel8.setBounds(10, 20, 50, 14);
        this.printHandlingCopies.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        this.pageHandlingPanel.add(this.printHandlingCopies);
        this.printHandlingCopies.setBounds(90, 20, 60, 20);
        this.jLabel9.setText(Messages.getMessage("PdfViewerPrint.PageScaling"));
        this.pageHandlingPanel.add(this.jLabel9);
        this.jLabel9.setBounds(10, 50, 120, 14);
        this.printHandlingScaling.setModel(new DefaultComboBoxModel<String>(PrinterOptions.PRINT_SCALING_OPTIONS));
        this.printHandlingScaling.setSelectedIndex(PrinterOptions.LAST_SCALING_CHOICE);
        this.pageHandlingPanel.add(this.printHandlingScaling);
        this.printHandlingScaling.setBounds(130, 50, 270, 22);
        this.autoRotateCenter.setSelected(true);
        this.autoRotateCenter.setText(Messages.getMessage("PdfViewerPrint.AutoRotateAndCenter"));
        this.autoRotateCenter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoRotateCenter.setMargin(new Insets(0, 0, 0, 0));
        this.pageHandlingPanel.add(this.autoRotateCenter);
        this.autoRotateCenter.setBounds(10, 80, 350, 15);
        this.paperSourceByPDF.setText(Messages.getMessage("PdfViewerPrint.ChoosePaperByPdfSize"));
        this.paperSourceByPDF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.paperSourceByPDF.setMargin(new Insets(0, 0, 0, 0));
        this.pageHandlingPanel.add(this.paperSourceByPDF);
        this.paperSourceByPDF.setBounds(10, 110, 350, 15);
        this.add(this.pageHandlingPanel);
        this.pageHandlingPanel.setBounds(10, 240, 460, 140);
        this.printToFile.setText(Messages.getMessage("PdfViewerPrint.PrintToFile"));
        this.printToFile.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printToFile.setMargin(new Insets(0, 0, 0, 0));
        this.add(this.printToFile);
        this.printToFile.setBounds(20, 390, 160, 15);
        this.printToFile.setEnabled(false);
        this.okButton.setText(Messages.getMessage("PdfMessage.Ok"));
        if (this.isFirstTime) {
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PrintPanel.this.okEvent(actionEvent);
                }
            });
        }
        this.add(this.okButton);
        this.okButton.setBounds(230, 420, 90, 23);
        this.cancelButton.setText(Messages.getMessage("PdfMessage.Cancel"));
        if (this.isFirstTime) {
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PrintPanel.this.cancelEvent(actionEvent);
                }
            });
        }
        this.add(this.cancelButton);
        this.cancelButton.setBounds(340, 420, 90, 23);
    }

    private void pagesBoxPressed(MouseEvent mouseEvent) {
        this.printRangeFrom.setSelected(true);
        this.printRangeSubset.setEnabled(true);
        this.printRangeReversePages.setEnabled(true);
    }

    private void pagesFromStateChanged(ItemEvent itemEvent) {
        if (this.printRangeFrom.isSelected()) {
            this.printRangeSubset.setEnabled(true);
            this.printRangeReversePages.setEnabled(true);
        }
    }

    private void printRangeCurrentView(ItemEvent itemEvent) {
        if (this.printRangeCurrentView.isSelected()) {
            this.printRangeSubset.setEnabled(false);
            this.printRangeReversePages.setEnabled(false);
        }
    }

    private void currentPageStateChanged(ItemEvent itemEvent) {
        if (this.printRangeCurrentPage.isSelected()) {
            this.printRangeSubset.setEnabled(false);
            this.printRangeReversePages.setEnabled(false);
        }
    }

    private void allStateChanged(ItemEvent itemEvent) {
        if (this.printRangeAll.isSelected()) {
            this.printRangeSubset.setEnabled(true);
            this.printRangeReversePages.setEnabled(true);
        }
    }

    private void cancelEvent(ActionEvent actionEvent) {
        this.okClicked = false;
        this.getTopLevelAncestor().setVisible(false);
    }

    private void okEvent(ActionEvent actionEvent) {
        this.okClicked = true;
        this.getTopLevelAncestor().setVisible(false);
    }

    public SetOfIntegerSyntax getPrintRange() {
        PageRanges pageRanges = null;
        if (this.printRangeAll.isSelected()) {
            pageRanges = new PageRanges(1, this.pageCount);
            if (this.printRangeSubset.getSelectedIndex() == 0) {
                return pageRanges;
            }
            if (this.printRangeSubset.getSelectedIndex() == 1) {
                String string = "";
                int n = -1;
                while ((n = pageRanges.next(n)) != -1) {
                    if (n % 2 != 1) continue;
                    string = string + n + ",";
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.deleteCharAt(string.length() - 1);
                string = stringBuffer.toString();
                pageRanges = new PageRanges(string);
            } else if (this.printRangeSubset.getSelectedIndex() == 2) {
                String string = "";
                int n = -1;
                while ((n = pageRanges.next(n)) != -1) {
                    if (n % 2 != 0) continue;
                    string = string + n + ",";
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.deleteCharAt(string.length() - 1);
                string = stringBuffer.toString();
                pageRanges = new PageRanges(string);
            }
        } else if (this.printRangeCurrentPage.isSelected()) {
            pageRanges = new PageRanges(this.currentPage);
        } else if (this.printRangeCurrentView.isSelected()) {
            pageRanges = new PageRanges(this.currentPage);
        } else if (this.printRangeFrom.isSelected()) {
            int n;
            int n2 = Integer.parseInt(this.pagesFrom.getText());
            if (n2 > (n = Integer.parseInt(this.pagesTo.getText()))) {
                int n3 = n;
                n = n2;
                n2 = n3;
                if (SimpleViewer.showMessages) {
                    JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerPrint.SwapValues"));
                }
            }
            pageRanges = new PageRanges(n2, n);
            if (this.printRangeSubset.getSelectedIndex() == 0) {
                return pageRanges;
            }
            if (this.printRangeSubset.getSelectedIndex() == 1) {
                String string = "";
                int n4 = -1;
                while ((n4 = pageRanges.next(n4)) != -1) {
                    if (n4 % 2 != 1) continue;
                    string = string + n4 + ",";
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.deleteCharAt(string.length() - 1);
                string = stringBuffer.toString();
                pageRanges = new PageRanges(string);
            } else if (this.printRangeSubset.getSelectedIndex() == 2) {
                String string = "";
                int n5 = -1;
                while ((n5 = pageRanges.next(n5)) != -1) {
                    if (n5 % 2 != 0) continue;
                    string = string + n5 + ",";
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                int n6 = string.length();
                if (n6 > 0) {
                    stringBuffer.deleteCharAt(n6 - 1);
                }
                pageRanges = (string = stringBuffer.toString()).length() > 0 ? new PageRanges(string) : null;
            }
        }
        return pageRanges;
    }

    public int getCopies() {
        String string = this.printHandlingCopies.getValue().toString();
        return Integer.parseInt(string);
    }

    public int getPageScaling() {
        int n = this.printHandlingScaling.getSelectedIndex();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        PrinterOptions.LAST_SCALING_CHOICE = n2;
        return n2;
    }

    public String getPrinter() {
        return this.printerName.getSelectedItem().toString();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public boolean isAutoRotateAndCenter() {
        return this.autoRotateCenter.isSelected();
    }

    public boolean isPaperSourceByPDFSize() {
        return this.paperSourceByPDF.isSelected();
    }

    public boolean isPrintingCurrentView() {
        return this.printRangeCurrentView.isSelected();
    }

    public String[] getAvailablePaperSizes() {
        return this.paperDefinitions.getAvailablePaperSizes();
    }

    public Paper getSelectedPaper() {
        return this.paperDefinitions.getSelectedPaper(this.pageSize.getSelectedItem());
    }

    public boolean isPagesReversed() {
        return this.printRangeReversePages.isSelected();
    }

    public boolean isOddPagesOnly() {
        return this.printRangeSubset.getSelectedIndex() == 1;
    }

    public boolean isEvenPagesOnly() {
        return this.printRangeSubset.getSelectedIndex() == 2;
    }
}

