/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;

public final class SwingMousePanning
implements MouseListener,
MouseMotionListener {
    private Point currentPoint;
    private PdfDecoder decode_pdf;
    private Rectangle currentView;

    public SwingMousePanning(PdfDecoder pdfDecoder) {
        this.decode_pdf = pdfDecoder;
    }

    public void setupMouse() {
        this.decode_pdf.addMouseMotionListener(this);
        this.decode_pdf.addMouseListener(this);
        SwingGUI swingGUI = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        swingGUI.setCursor(1);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.currentPoint = mouseEvent.getPoint();
        this.currentView = this.decode_pdf.getVisibleRect();
        SwingGUI swingGUI = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        swingGUI.setCursor(2);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        SwingGUI swingGUI = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        swingGUI.setCursor(1);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.currentPoint.x - point.x;
        int n2 = this.currentPoint.y - point.y;
        Rectangle rectangle = this.currentView;
        rectangle.x += n;
        rectangle.y += n2;
        if (!rectangle.contains(this.decode_pdf.getVisibleRect())) {
            this.decode_pdf.scrollRectToVisible(rectangle);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

