/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Path;

public class T1Glyph
implements PdfGlyph,
Serializable {
    private transient Vector_Path cached_current_path = null;
    private float glyfwidth = 1000.0f;
    private boolean isStroked = false;
    private Paint strokePaint;
    private Map strokedPositions = new HashMap();
    Area glyphShape = null;
    int minX = 0;
    int minY = 0;
    int maxX = 0;
    int maxY = 0;

    public T1Glyph() {
    }

    public T1Glyph(Vector_Path vector_Path) {
        this.cached_current_path = vector_Path;
    }

    public void render(int n, Graphics2D graphics2D, float f, boolean bl) {
        if (this.cached_current_path != null) {
            GeneralPath[] generalPathArray = this.cached_current_path.get();
            int n2 = generalPathArray.length;
            for (int i = 0; i < n2 && generalPathArray[i] != null; ++i) {
                if (n == 2) {
                    if (this.isStroked) {
                        Paint paint = graphics2D.getPaint();
                        if (((Color)this.strokePaint).getRGB() != ((Color)paint).getRGB() && this.strokedPositions.containsKey(String.valueOf((int)graphics2D.getTransform().getTranslateX()) + '-' + (int)graphics2D.getTransform().getTranslateY())) {
                            Stroke stroke = graphics2D.getStroke();
                            graphics2D.setPaint(this.strokePaint);
                            float f2 = (float)((double)f / graphics2D.getTransform().getScaleX());
                            if (f2 < 0.0f) {
                                f2 = -f2;
                            }
                            graphics2D.setStroke(new BasicStroke(f2));
                            graphics2D.draw(generalPathArray[i]);
                            graphics2D.setPaint(paint);
                            graphics2D.setStroke(stroke);
                        }
                    }
                    graphics2D.fill(generalPathArray[i]);
                }
                if (n != 1) continue;
                if (n != 2 && f > 1.0f) {
                    graphics2D.setStroke(new BasicStroke((float)((double)f / graphics2D.getTransform().getScaleX())));
                }
                graphics2D.draw(generalPathArray[i]);
                this.strokePaint = graphics2D.getPaint();
                this.strokedPositions.put(String.valueOf((int)graphics2D.getTransform().getTranslateX()) + '-' + (int)graphics2D.getTransform().getTranslateY(), "x");
            }
        }
    }

    public float getmaxWidth() {
        return this.glyfwidth;
    }

    public int getmaxHeight() {
        return 0;
    }

    public void lockColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
    }

    public boolean ignoreColors() {
        return false;
    }

    public Area getShape() {
        if (this.cached_current_path != null && this.glyphShape == null) {
            GeneralPath[] generalPathArray = this.cached_current_path.get();
            int n = generalPathArray.length;
            for (int i = 1; i < n && generalPathArray[i] != null; ++i) {
                generalPathArray[0].append(generalPathArray[i], false);
            }
            if (generalPathArray != null && generalPathArray[0] != null) {
                this.glyphShape = new Area(generalPathArray[0]);
            }
        }
        return this.glyphShape;
    }

    public String getGlyphName() {
        return "";
    }

    public void setPaths(Vector_Path vector_Path) {
        this.cached_current_path = vector_Path;
    }

    public void writePathsToStream(ObjectOutput objectOutput) throws IOException {
        if (this.cached_current_path != null) {
            int n;
            GeneralPath[] generalPathArray = this.cached_current_path.get();
            int n2 = 0;
            for (n = 0; n < generalPathArray.length; ++n) {
                if (generalPathArray[n] != null) continue;
                n2 = n;
                break;
            }
            objectOutput.writeObject(new Integer(n2));
            for (n = 0; n < n2; ++n) {
                PathIterator pathIterator = generalPathArray[n].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(objectOutput, pathIterator);
            }
        }
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    public void setWidth(float f) {
        this.glyfwidth = f;
    }

    public int getFontBB(int n) {
        if (this.minX == 0 && this.minY == 0 && this.maxX == 0 && this.maxY == 0 && this.cached_current_path != null) {
            GeneralPath[] generalPathArray = this.cached_current_path.get();
            int n2 = generalPathArray.length;
            for (int i = 0; i < n2 && generalPathArray[i] != null; ++i) {
                Rectangle rectangle = generalPathArray[i].getBounds();
                if (i == 0) {
                    this.minX = rectangle.x;
                    this.minY = rectangle.y;
                    this.maxX = rectangle.width;
                    this.maxY = rectangle.height;
                    continue;
                }
                if (this.minX > rectangle.x) {
                    this.minX = rectangle.x;
                }
                if (this.minY > rectangle.y) {
                    this.minY = rectangle.y;
                }
                if (this.maxX < rectangle.width) {
                    this.maxX = rectangle.width;
                }
                if (this.maxY >= rectangle.height) continue;
                this.maxY = rectangle.height;
            }
        }
        if (n == 1) {
            return this.minX;
        }
        if (n == 2) {
            return this.minY;
        }
        if (n == 3) {
            return this.maxX;
        }
        if (n == 4) {
            return this.minY;
        }
        return 0;
    }

    public void setStrokedOnly(boolean bl) {
        this.isStroked = bl;
    }
}

