/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks.bookmark;

import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkSelection
implements Transferable,
ClipboardOwner,
Serializable {
    private DataFlavor bookmarkFlavor;
    private DataFlavor[] dataFlavors = new DataFlavor[1];
    private Bookmark bookmark;
    private ArrayList<Bookmark> bookmarks;
    private boolean cut;
    private File file;

    public BookmarkSelection(ArrayList<Bookmark> bookmarks, DataFlavor flavor, boolean cut) {
        this.bookmarkFlavor = flavor;
        this.bookmarks = bookmarks;
        this.dataFlavors[0] = this.bookmarkFlavor;
        this.cut = cut;
    }

    public BookmarkSelection(ArrayList<Bookmark> bookmarks, DataFlavor flavor, boolean cut, File pdfFile) {
        this(bookmarks, flavor, cut);
        this.file = pdfFile;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.dataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.bookmarkFlavor);
    }

    public ArrayList<Bookmark> getBookmarks() {
        ArrayList<Bookmark> copies = new ArrayList<Bookmark>(this.bookmarks.size());
        for (Bookmark b : this.bookmarks) {
            copies.add(Bookmark.cloneBookmark(b, !b.isOpened()));
        }
        return copies;
    }

    public boolean isCutOperation() {
        return this.cut;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(this.bookmarkFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

