/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.Prefs;
import it.flavianopetrocchi.jpdfbookmarks.Res;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;

public class GeneralOptionsPanel
extends JPanel {
    Prefs userPrefs;
    int defCharsetIndex = 0;
    String defCharset = Charset.defaultCharset().displayName();
    String defCharsetDecorated = this.defCharset + " (" + Res.getString("SYSTEM_DEFAULT") + ")";
    private JComboBox charsetsCombo;
    private JCheckBox checkConvertNamedDestinations;
    private JRadioButton checkUseDoubleClicks;
    private JRadioButton checkUseSingleClicks;
    private JCheckBox checkUseThousandthsUnits;
    private ButtonGroup groupClicks;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public GeneralOptionsPanel(Prefs prefs) {
        this.userPrefs = prefs;
        this.initComponents();
        this.checkConvertNamedDestinations.setSelected(prefs.getConvertNamedDestinations());
        this.checkUseThousandthsUnits.setSelected(prefs.getUseThousandths());
        this.checkUseThousandthsUnits.setVisible(false);
        if (prefs.getNumClicks() > 1) {
            this.checkUseDoubleClicks.setSelected(true);
        } else {
            this.checkUseSingleClicks.setSelected(true);
        }
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        for (String string : sortedMap.keySet()) {
            if (string.equalsIgnoreCase(this.defCharset)) {
                this.charsetsCombo.addItem(this.defCharsetDecorated);
                continue;
            }
            this.charsetsCombo.addItem(string);
        }
        String string = prefs.getCharsetEncoding();
        if (string.equalsIgnoreCase(this.defCharset)) {
            this.charsetsCombo.setSelectedItem(this.defCharsetDecorated);
        } else {
            this.charsetsCombo.setSelectedItem(string);
        }
    }

    public String getCharsetEncoding() {
        String string = (String)this.charsetsCombo.getSelectedItem();
        if (string.equalsIgnoreCase(this.defCharsetDecorated)) {
            return this.defCharset;
        }
        return string;
    }

    public boolean convertNamedDestinations() {
        return this.checkConvertNamedDestinations.isSelected();
    }

    public boolean useThousandths() {
        return this.checkUseThousandthsUnits.isSelected();
    }

    public int getNumClicks() {
        if (this.checkUseSingleClicks.isSelected()) {
            return 1;
        }
        return 2;
    }

    private void initComponents() {
        this.groupClicks = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.checkConvertNamedDestinations = new JCheckBox();
        this.checkUseThousandthsUnits = new JCheckBox();
        this.charsetsCombo = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jPanel2 = new JPanel();
        this.checkUseSingleClicks = new JRadioButton();
        this.checkUseDoubleClicks = new JRadioButton();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText");
        this.checkConvertNamedDestinations.setText(resourceBundle.getString("CHECK_CONVERT_NAMED_DEST"));
        this.checkConvertNamedDestinations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralOptionsPanel.this.checkConvertNamedDestinationsActionPerformed(actionEvent);
            }
        });
        this.checkUseThousandthsUnits.setText(resourceBundle.getString("CHECK_USE_THOUSANDTHS"));
        this.checkUseThousandthsUnits.setEnabled(false);
        this.jLabel7.setText(resourceBundle.getString("SELECT_ENCODING"));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("CHOOSE_NUM_CLICKS")));
        this.groupClicks.add(this.checkUseSingleClicks);
        this.checkUseSingleClicks.setText(resourceBundle.getString("SINGLE_CLICK"));
        this.groupClicks.add(this.checkUseDoubleClicks);
        this.checkUseDoubleClicks.setText(resourceBundle.getString("DOUBLE_CLICK"));
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.checkUseSingleClicks).addGap(18, 18, 18).addComponent(this.checkUseDoubleClicks).addContainerGap(388, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkUseSingleClicks).addComponent(this.checkUseDoubleClicks)).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.checkConvertNamedDestinations).addGap(14, 14, 14).addComponent(this.checkUseThousandthsUnits)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.charsetsCombo, 0, 357, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkConvertNamedDestinations).addComponent(this.checkUseThousandthsUnits)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.charsetsCombo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 634, Short.MAX_VALUE).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE))));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 172, Short.MAX_VALUE).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE))));
    }

    private void checkConvertNamedDestinationsActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, Res.getString("CONVERT_NAMED_DEST_MSG"), "JPdfBookmarks", 2);
    }
}

