/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import com.lowagie.text.exceptions.BadPasswordException;
import it.flavianopetrocchi.jpdfbookmarks.Applier;
import it.flavianopetrocchi.jpdfbookmarks.Dumper;
import it.flavianopetrocchi.jpdfbookmarks.JPdfBookmarksGui;
import it.flavianopetrocchi.jpdfbookmarks.LicenseBox;
import it.flavianopetrocchi.jpdfbookmarks.Prefs;
import it.flavianopetrocchi.jpdfbookmarks.Res;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.IBookmarksConverter;
import it.flavianopetrocchi.utilities.Ut;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

class JPdfBookmarks {
    public static final boolean DEBUG = false;
    private static String version = "1.0.0";
    private static final String VERSION_FILE = "jpdfbookmarks.properties";
    public static final String APP_NAME = "JPdfBookmarks";
    protected static final String NEWLINE;
    public static final String DOWNLOAD_URL = "http://flavianopetrocchi.blogspot.com/2008/07/jpsdbookmarks-download-page.html";
    public static final String BLOG_URL = "http://flavianopetrocchi.blogspot.com";
    public static final String ITEXT_URL = "http://www.lowagie.com/iText/";
    public static final String LAST_VERSION_PROPERTIES_URL = "http://jpdfbookmarks.altervista.org/version/jpdfbookmarks.properties";
    public static final String MANUAL_URL = "http://sourceforge.net/apps/mediawiki/jpdfbookmarks/";
    private static final int MAX_PASSWORD_LEN = 32;
    private Mode mode = Mode.GUI;
    private Options options = this.createOptions();
    private final PrintWriter out = new PrintWriter(System.out, true);
    private final PrintWriter err = new PrintWriter(System.err, true);
    private String inputFilePath = null;
    private String outputFilePath = "output.pdf";
    private String bookmarksFilePath = null;
    private String pageSeparator = "/";
    private String attributesSeparator = ",";
    private String indentationString = "\t";
    private String firstTargetString = null;
    private boolean silentMode = false;
    private String charset = Charset.defaultCharset().displayName();
    private String showOnOpenArg = null;
    private byte[] userPassword = null;
    private byte[] ownerPassword = null;

    JPdfBookmarks() {
    }

    public static void main(String[] stringArray) {
        JPdfBookmarks.localizeExternalModules();
        JPdfBookmarks jPdfBookmarks = new JPdfBookmarks();
        jPdfBookmarks.start(stringArray);
    }

    public static String getVersion() {
        return version;
    }

    private static void localizeExternalModules() {
        Bookmark.localizeStrings((String)Res.getString("DEFAULT_TITLE"), (String)Res.getString("PAGE"), (String)Res.getString("PARSE_ERROR"));
    }

    private byte[] askUserPassword() {
        char[] cArray = null;
        byte[] byArray = null;
        Console console = System.console();
        if (console != null && (cArray = console.readPassword("[%s:]", Res.getString("PASSWORD"))) != null) {
            byArray = Ut.arrayOfCharsToArrayOfBytes((char[])cArray);
            Arrays.fill(cArray, ' ');
        } else {
            this.out.print("[" + Res.getString("LABEL_PASSWORD") + "]");
            this.out.flush();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            cArray = new char[32];
            try {
                int n = bufferedReader.read(cArray, 0, 32);
                for (int i = n - 1; i >= 0 && (cArray[i] == '\r' || cArray[i] == '\n'); --i) {
                    --n;
                }
                char[] cArray2 = Arrays.copyOf(cArray, n);
                Arrays.fill(cArray, ' ');
                byArray = Ut.arrayOfCharsToArrayOfBytes((char[])cArray2);
                Arrays.fill(cArray2, ' ');
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    private IBookmarksConverter fatalGetConverterAndOpenPdf(String string) {
        IBookmarksConverter iBookmarksConverter = Bookmark.getBookmarksConverter();
        if (iBookmarksConverter != null) {
            try {
                this.userPassword = null;
                block4: while (true) {
                    try {
                        iBookmarksConverter.open(string, this.userPassword);
                    }
                    catch (BadPasswordException badPasswordException) {
                        this.userPassword = null;
                        this.out.println(Res.getString("DIALOG_USER_PASSWORD"));
                        while (true) {
                            if (this.userPassword != null) continue block4;
                            this.userPassword = this.askUserPassword();
                        }
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                this.fatalOpenFileError(string);
            }
        } else {
            this.err.println(Res.getString("ERROR_BOOKMARKS_CONVERTER_NOT_FOUND"));
            System.exit(1);
        }
        return iBookmarksConverter;
    }

    private void apply() {
        IBookmarksConverter iBookmarksConverter = this.fatalGetConverterAndOpenPdf(this.inputFilePath);
        if (this.outputFilePath == null || this.outputFilePath.equals(this.inputFilePath)) {
            if (this.getYesOrNo(Res.getString("ERR_INFILE_EQUAL_OUTFILE"))) {
                this.outputFilePath = this.inputFilePath;
                this.applySave(iBookmarksConverter, this.inputFilePath, this.outputFilePath);
            }
        } else {
            File file = new File(this.outputFilePath);
            if (!file.exists() || this.getYesOrNo(Res.getString("WARNING_OVERWRITE_CMD"))) {
                this.applySave(iBookmarksConverter, this.inputFilePath, this.outputFilePath);
            }
        }
    }

    private byte[] openAsOwner(IBookmarksConverter iBookmarksConverter, String string) {
        boolean bl = false;
        if (this.userPassword != null) {
            if (!iBookmarksConverter.isBookmarksEditingPermitted()) {
                bl = true;
            }
        } else if (iBookmarksConverter.isEncryped()) {
            bl = true;
        }
        while (bl) {
            this.out.println(Res.getString("DIALOG_OWNER_PASSWORD"));
            this.ownerPassword = null;
            while (this.ownerPassword == null) {
                this.ownerPassword = this.askUserPassword();
            }
            try {
                iBookmarksConverter.close();
                iBookmarksConverter.open(string, this.ownerPassword);
                if (!iBookmarksConverter.isBookmarksEditingPermitted()) continue;
                bl = false;
            }
            catch (Exception exception) {
                this.ownerPassword = null;
            }
        }
        return this.ownerPassword;
    }

    private void resetPasswords() {
        if (this.userPassword != null) {
            Arrays.fill(this.userPassword, (byte)0);
            this.userPassword = null;
        }
        if (this.ownerPassword != null) {
            Arrays.fill(this.ownerPassword, (byte)0);
            this.ownerPassword = null;
        }
    }

    private void applySave(IBookmarksConverter iBookmarksConverter, String string, String string2) {
        try {
            this.ownerPassword = this.openAsOwner(iBookmarksConverter, string);
            Applier applier = new Applier(iBookmarksConverter, this.indentationString, this.pageSeparator, this.attributesSeparator);
            try {
                applier.loadBookmarksFile(this.bookmarksFilePath, this.charset);
            }
            catch (Exception exception) {
                this.fatalOpenFileError(this.bookmarksFilePath);
            }
            applier.save(string2, this.userPassword, this.ownerPassword);
            iBookmarksConverter.close();
            this.resetPasswords();
        }
        catch (IOException iOException) {
            this.fatalSaveFileError(string2);
        }
    }

    private void dump() {
        IBookmarksConverter iBookmarksConverter = this.fatalGetConverterAndOpenPdf(this.inputFilePath);
        this.resetPasswords();
        Dumper dumper = new Dumper(iBookmarksConverter, this.indentationString, this.pageSeparator, this.attributesSeparator);
        if (this.outputFilePath == null) {
            dumper.printBookmarksIterative(new OutputStreamWriter(System.out));
        } else {
            File file = new File(this.outputFilePath);
            if (!file.exists() || this.getYesOrNo(Res.getString("WARNING_OVERWRITE_CMD"))) {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(this.outputFilePath);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.charset);
                    dumper.printBookmarksIterative(outputStreamWriter);
                    outputStreamWriter.close();
                    iBookmarksConverter.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.fatalOpenFileError(this.outputFilePath);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void save(IBookmarksConverter iBookmarksConverter, byte[] byArray) {
        try {
            iBookmarksConverter.save(this.outputFilePath, this.userPassword, byArray);
            iBookmarksConverter.close();
            if (this.userPassword != null) {
                Arrays.fill(this.userPassword, (byte)0);
            }
            if (byArray != null) {
                Arrays.fill(byArray, (byte)0);
            }
        }
        catch (IOException iOException) {
            this.fatalSaveFileError(this.outputFilePath);
        }
    }

    private void showOnOpen() {
        IBookmarksConverter iBookmarksConverter = this.fatalGetConverterAndOpenPdf(this.inputFilePath);
        if (this.showOnOpenArg.equalsIgnoreCase("CHECK") || this.showOnOpenArg.equalsIgnoreCase("c")) {
            if (iBookmarksConverter.showBookmarksOnOpen()) {
                this.out.println("YES");
            } else {
                this.out.println("NO");
            }
        } else {
            this.ownerPassword = this.openAsOwner(iBookmarksConverter, this.inputFilePath);
            if (this.showOnOpenArg.equalsIgnoreCase("yes") || this.showOnOpenArg.equalsIgnoreCase("y")) {
                iBookmarksConverter.setShowBookmarksOnOpen(true);
            } else if (this.showOnOpenArg.equalsIgnoreCase("no") || this.showOnOpenArg.equalsIgnoreCase("n")) {
                iBookmarksConverter.setShowBookmarksOnOpen(false);
            }
            if (this.outputFilePath == null || this.outputFilePath.equals(this.inputFilePath)) {
                if (this.getYesOrNo(Res.getString("ERR_INFILE_EQUAL_OUTFILE"))) {
                    this.outputFilePath = this.inputFilePath;
                    this.save(iBookmarksConverter, this.ownerPassword);
                }
            } else {
                File file = new File(this.outputFilePath);
                if (!file.exists() || this.getYesOrNo(Res.getString("WARNING_OVERWRITE_CMD"))) {
                    this.save(iBookmarksConverter, this.ownerPassword);
                }
            }
        }
        this.resetPasswords();
    }

    private void fatalOpenFileError(String string) {
        this.err.println(Res.getString("ERROR_OPENING_FILE") + " " + string);
        System.exit(1);
    }

    private void fatalSaveFileError(String string) {
        this.err.println(Res.getString("ERROR_SAVING_FILE") + " (" + string + ")");
        System.exit(1);
    }

    public void launchNewGuiInstance(String string, Bookmark bookmark) {
        EventQueue.invokeLater(new GuiLauncher(string, bookmark));
    }

    public static File getPath() {
        File file = null;
        try {
            file = new File(JPdfBookmarks.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return file;
    }

    public void start(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.setModeByCommandLine(stringArray);
        }
        switch (this.mode) {
            case VERSION: {
                this.out.println(version);
                break;
            }
            case DUMP: {
                this.dump();
                break;
            }
            case SHOW_ON_OPEN: {
                this.showOnOpen();
                break;
            }
            case APPLY: {
                this.apply();
                break;
            }
            case GUI: {
                EventQueue.invokeLater(new GuiLauncher(this.inputFilePath));
                break;
            }
            default: {
                this.printHelpMessage();
            }
        }
    }

    public static void printErrorForDebug(Exception exception) {
    }

    public void printHelpMessage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        String string = Res.getString("APP_DESCR");
        String string2 = "jpdfbookmarks <input.pdf> [--dump | --apply <bookmarks.txt> | --show-on-open <YES | NO | CHECK> | --help | --version] [--out <output.pdf>]";
        int n = 80;
        int n2 = 1;
        int n3 = 2;
        String string3 = Res.getString("BOOKMARKS_DESCR");
        helpFormatter.printHelp(this.out, n, string2, string, this.options, n2, n3, string3);
    }

    private void setModeByCommandLine(String[] stringArray) {
        Prefs prefs = new Prefs();
        PosixParser posixParser = new PosixParser();
        try {
            CommandLine commandLine = posixParser.parse(this.options, stringArray);
            if (commandLine.hasOption('h')) {
                this.mode = Mode.HELP;
            } else if (commandLine.hasOption('v')) {
                this.mode = Mode.VERSION;
            } else if (commandLine.hasOption('w')) {
                this.mode = Mode.SHOW_ON_OPEN;
                this.showOnOpenArg = commandLine.getOptionValue('w');
                this.outputFilePath = commandLine.hasOption('o') ? commandLine.getOptionValue('o') : null;
            } else if (commandLine.hasOption('a')) {
                this.mode = Mode.APPLY;
                this.bookmarksFilePath = commandLine.getOptionValue('a');
            } else if (commandLine.hasOption('d')) {
                this.mode = Mode.DUMP;
            } else {
                this.mode = Mode.GUI;
                if (commandLine.hasOption('b')) {
                    this.firstTargetString = commandLine.getOptionValue('b');
                }
            }
            this.outputFilePath = commandLine.hasOption('o') ? commandLine.getOptionValue('o') : null;
            String[] stringArray2 = commandLine.getArgs();
            if (stringArray2.length > 0) {
                this.inputFilePath = stringArray2[0];
            } else if (this.mode == Mode.DUMP || this.mode == Mode.APPLY) {
                throw new ParseException(Res.getString("ERR_NO_INPUT_FILE"));
            }
            this.pageSeparator = commandLine.hasOption("p") ? commandLine.getOptionValue("p") : prefs.getPageSeparator();
            this.indentationString = commandLine.hasOption("i") ? commandLine.getOptionValue("i") : prefs.getIndentationString();
            this.attributesSeparator = commandLine.hasOption("t") ? commandLine.getOptionValue("t") : prefs.getAttributesSeparator();
            if (commandLine.hasOption("f")) {
                this.silentMode = true;
            }
            if (commandLine.hasOption("e")) {
                this.charset = commandLine.getOptionValue("e");
                if (!Charset.isSupported(this.charset)) {
                    throw new ParseException(Res.getString("ERR_CHARSET_NOT_SUPPORTED"));
                }
            }
            if (this.pageSeparator.equals(this.indentationString) || this.pageSeparator.equals(this.attributesSeparator) || this.indentationString.equals(this.attributesSeparator)) {
                throw new ParseException(Res.getString("ERR_OPTIONS_CONTRAST"));
            }
        }
        catch (ParseException parseException) {
            this.mode = Mode.GUI;
            this.err.println(parseException.getLocalizedMessage());
            System.exit(1);
        }
    }

    private boolean getYesOrNo(String string) {
        if (this.silentMode) {
            return true;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter printWriter = new PrintWriter(System.out, true);
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            printWriter.println(string);
            try {
                String string2 = bufferedReader.readLine();
                if (string2.equalsIgnoreCase(Res.getString("SHORT_YES")) || string2.equalsIgnoreCase(Res.getString("LONG_YES"))) {
                    bl = true;
                    bl2 = true;
                    continue;
                }
                if (!string2.equalsIgnoreCase(Res.getString("SHORT_NO")) && !string2.equalsIgnoreCase(Res.getString("LONG_NO"))) continue;
                bl = false;
                bl2 = true;
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    private Options createOptions() {
        Options options = new Options();
        options.addOption("f", "force", false, Res.getString("FORCE_DESCR"));
        options.addOption("v", "version", false, Res.getString("VERSION_DESCR"));
        options.addOption("h", "help", false, Res.getString("HELP_DESCR"));
        OptionBuilder.withLongOpt("dump");
        OptionBuilder.withDescription(Res.getString("DUMP_DESCR"));
        options.addOption(OptionBuilder.create('d'));
        OptionBuilder.withLongOpt("apply");
        OptionBuilder.hasArg(true);
        OptionBuilder.withArgName("bookmarks.txt");
        OptionBuilder.withDescription(Res.getString("APPLY_DESCR"));
        options.addOption(OptionBuilder.create('a'));
        OptionBuilder.withLongOpt("out");
        OptionBuilder.hasArg(true);
        OptionBuilder.withArgName("output.pdf");
        OptionBuilder.withDescription(Res.getString("OUT_DESCR"));
        options.addOption(OptionBuilder.create('o'));
        OptionBuilder.withLongOpt("encoding");
        OptionBuilder.hasArg(true);
        OptionBuilder.withArgName("UTF-8");
        OptionBuilder.withDescription(Res.getString("ENCODING_DESCR"));
        options.addOption(OptionBuilder.create('e'));
        options.addOption("b", "bookmark", true, Res.getString("BOOKMARK_ARG_DESCR"));
        options.addOption("p", "page-sep", true, Res.getString("PAGE_SEP_DESCR"));
        options.addOption("t", "attributes-sep", true, Res.getString("ATTRIBUTES_SEP_DESCR"));
        options.addOption("i", "indentation", true, Res.getString("INDENTATION_STRING_DESCR"));
        options.addOption("w", "show-on-open", true, Res.getString("SHOW_ON_OPEN_DESCR"));
        return options;
    }

    static {
        Properties properties = new Properties();
        try {
            InputStream inputStream = JPdfBookmarks.class.getResourceAsStream(VERSION_FILE);
            properties.load(inputStream);
            version = properties.getProperty("VERSION");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(JPdfBookmarks.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(JPdfBookmarks.class.getName()).log(Level.SEVERE, null, iOException);
        }
        NEWLINE = System.getProperty("line.separator");
    }

    public class GuiLauncher
    implements Runnable {
        private Bookmark firstTarget;
        private String inputPath;

        public GuiLauncher(String string) {
            if (string != null) {
                IBookmarksConverter iBookmarksConverter = JPdfBookmarks.this.fatalGetConverterAndOpenPdf(string);
                if (JPdfBookmarks.this.firstTargetString != null) {
                    StringBuilder stringBuilder = new StringBuilder("Bookmark");
                    stringBuilder.append(JPdfBookmarks.this.pageSeparator).append(JPdfBookmarks.this.firstTargetString);
                    this.firstTarget = Bookmark.bookmarkFromString(null, (IBookmarksConverter)iBookmarksConverter, (String)stringBuilder.toString(), (String)JPdfBookmarks.this.indentationString, (String)JPdfBookmarks.this.pageSeparator, (String)JPdfBookmarks.this.attributesSeparator);
                }
                this.inputPath = string;
                try {
                    iBookmarksConverter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public GuiLauncher(String string, Bookmark bookmark) {
            this.firstTarget = bookmark;
            this.inputPath = string;
        }

        @Override
        public void run() {
            try {
                JPdfBookmarksGui jPdfBookmarksGui = new JPdfBookmarksGui();
                Prefs prefs = new Prefs();
                if (!prefs.getGplAccepted()) {
                    LicenseBox licenseBox = new LicenseBox(null, true);
                    licenseBox.setLocationRelativeTo(null);
                    licenseBox.setVisible(true);
                    if (licenseBox.getLicenseAccepted()) {
                        prefs.setGplAccepted(true);
                    } else {
                        return;
                    }
                }
                jPdfBookmarksGui.setVisible(true);
                if (this.inputPath != null) {
                    jPdfBookmarksGui.openFileAsync(new File(new File(this.inputPath).getAbsolutePath()), this.firstTarget);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception.getMessage(), JPdfBookmarks.APP_NAME, 1);
            }
        }
    }

    private static enum Mode {
        DUMP,
        APPLY,
        HELP,
        GUI,
        VERSION,
        SHOW_ON_OPEN;

    }
}

