/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.Res;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class PageOffsetDialog
extends JDialog {
    private JSpinner pageOffset;
    private JLabel lblMaxOffset;
    private boolean operationNotAborted = false;

    public PageOffsetDialog(Frame frame, int n, int n2, int n3) {
        super(frame, true);
        this.setTitle(Res.getString("PAGE_OFFSET"));
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel(new FlowLayout(1, 10, 10));
        this.getContentPane().add(jPanel);
        JLabel jLabel = new JLabel(Res.getString("PAGE_OFFSET") + ": ");
        jPanel.add(jLabel);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n3, n2, 1);
        this.pageOffset = new JSpinner(spinnerNumberModel);
        jPanel.add(this.pageOffset);
        this.lblMaxOffset = new JLabel();
        this.lblMaxOffset.setText(String.format(" [%d,%d]", n3, n2));
        jPanel.add(this.lblMaxOffset);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
        this.getContentPane().add((Component)jPanel2, "South");
        JButton jButton = new JButton(Res.getString("OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageOffsetDialog.this.operationNotAborted = true;
                PageOffsetDialog.this.setVisible(false);
            }
        });
        jPanel2.add(jButton);
        jButton = new JButton(Res.getString("CANCEL"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageOffsetDialog.this.operationNotAborted = false;
                PageOffsetDialog.this.setVisible(false);
            }
        });
        jPanel2.add(jButton);
        this.setDefaultCloseOperation(0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                PageOffsetDialog.this.pageOffset.requestFocusInWindow();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PageOffsetDialog.this.operationNotAborted = false;
                PageOffsetDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public boolean operationNotAborted() {
        return this.operationNotAborted;
    }

    public int getOffsetValue() {
        return (Integer)this.pageOffset.getValue();
    }
}

