/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.Prefs;
import it.flavianopetrocchi.jpdfbookmarks.Res;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SeparatorsPanel
extends JPanel {
    Prefs userPrefs;
    String previewText = "Chapter 1/1,Black,notBold,notItalic,open,FitWidth,80\n\tParagraph 1/5,Red,bold,italic,closed,FitWidth,120\n\t\tParagraph 1.1/9,Black,notBold,notItalic,closed,FitWidth,500\n\tParagraph 2/13,Black,bold,italic,closed,FitWidth,250";
    int defCharsetIndex = 0;
    String defCharset = Charset.defaultCharset().displayName();
    String defCharsetDecorated = this.defCharset + " (" + Res.getString("SYSTEM_DEFAULT") + ")";
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JTextField txtAttributesSeparator;
    private JTextField txtIndentationString;
    private JTextField txtPageSeparator;
    private JTextArea txtPreview;
    private JPanel valueSeparatorsPanel;

    public SeparatorsPanel(Prefs prefs) {
        this.userPrefs = prefs;
        this.initComponents();
        String string = prefs.getIndentationString();
        String string2 = prefs.getPageSeparator();
        String string3 = prefs.getAttributesSeparator();
        this.txtPageSeparator.setText(this.formatText(string2));
        this.txtAttributesSeparator.setText(this.formatText(string3));
        this.txtIndentationString.setText(this.formatText(string));
        this.setPreview();
        TextChangedListener textChangedListener = new TextChangedListener();
        this.txtPageSeparator.getDocument().addDocumentListener(textChangedListener);
        this.txtAttributesSeparator.getDocument().addDocumentListener(textChangedListener);
        this.txtIndentationString.getDocument().addDocumentListener(textChangedListener);
    }

    public String getPageSeparator() {
        return this.unformatText(this.txtPageSeparator.getText());
    }

    public String getIndentationString() {
        return this.unformatText(this.txtIndentationString.getText());
    }

    public String getAttributesSeparator() {
        return this.unformatText(this.txtAttributesSeparator.getText());
    }

    private String formatText(String string) {
        String string2 = string.replace("\t", "[tab]");
        string2 = string2.replace(" ", "[space]");
        return string2;
    }

    private String unformatText(String string) {
        String string2 = string.replace("[tab]", "\t");
        string2 = string2.replace("[space]", " ");
        return string2;
    }

    private void setPreview() {
        String string = this.unformatText(this.txtPageSeparator.getText());
        String string2 = this.unformatText(this.txtIndentationString.getText());
        String string3 = this.unformatText(this.txtAttributesSeparator.getText());
        String string4 = this.previewText.replace("\t", string2).replace("/", string).replace(",", string3);
        this.txtPreview.setText(string4);
    }

    private boolean checkNotEmpty(JTextField ... jTextFieldArray) {
        for (JTextField jTextField : jTextFieldArray) {
            if (!jTextField.getText().isEmpty()) continue;
            JOptionPane.showMessageDialog(this, Res.getString("ERROR_EMPTY_FIELD"), "JPdfBookmarks", 2);
            jTextField.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private boolean checkDifferentValues() {
        String string = this.unformatText(this.txtPageSeparator.getText());
        String string2 = this.unformatText(this.txtIndentationString.getText());
        String string3 = this.unformatText(this.txtAttributesSeparator.getText());
        JTextField jTextField = null;
        if (string.equals(string2)) {
            jTextField = this.txtIndentationString;
        } else if (string.equals(string3)) {
            jTextField = this.txtAttributesSeparator;
        } else if (string2.equals(string3)) {
            jTextField = this.txtPageSeparator;
        }
        if (jTextField != null) {
            JOptionPane.showMessageDialog(this, Res.getString("ERROR_DUPLICATED_VALUES"), "JPdfBookmarks", 2);
            jTextField.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.valueSeparatorsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.txtPageSeparator = new JTextField();
        this.jLabel2 = new JLabel();
        this.txtAttributesSeparator = new JTextField();
        this.jLabel3 = new JLabel();
        this.txtIndentationString = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.txtPreview = new JTextArea();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText");
        this.valueSeparatorsPanel.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("OPTIONS_SEPARATORS")));
        this.jLabel1.setText(resourceBundle.getString("LABEL_PAGE_SEPARATOR"));
        this.txtPageSeparator.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                SeparatorsPanel.this.txtPageSeparatorInputMethodTextChanged(inputMethodEvent);
            }
        });
        this.jLabel2.setText(resourceBundle.getString("LABEL_ATTRIBUTES_SEPARATOR"));
        this.jLabel3.setText(resourceBundle.getString("LABEL_INDENTATION_STRING"));
        this.txtPreview.setColumns(20);
        this.txtPreview.setEditable(false);
        this.txtPreview.setRows(5);
        this.txtPreview.setFocusable(false);
        this.jScrollPane1.setViewportView(this.txtPreview);
        this.jLabel4.setText(resourceBundle.getString("LABEL_PREVIEW"));
        this.jLabel5.setText(resourceBundle.getString("OPTIONS_DESCRIPTION_01"));
        this.jLabel6.setText(resourceBundle.getString("OPTIONS_DESCRIPTION_02"));
        GroupLayout groupLayout = new GroupLayout(this.valueSeparatorsPanel);
        this.valueSeparatorsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 550, Short.MAX_VALUE).addComponent(this.jLabel4).addComponent(this.jLabel5).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtIndentationString, -1, 443, Short.MAX_VALUE).addComponent(this.txtAttributesSeparator, -1, 443, Short.MAX_VALUE).addComponent(this.txtPageSeparator, -1, 443, Short.MAX_VALUE))).addComponent(this.jLabel6)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtPageSeparator, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txtAttributesSeparator, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtIndentationString, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 143, -2).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.valueSeparatorsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.valueSeparatorsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void txtPageSeparatorInputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        System.out.println("textchanged");
    }

    private class TextChangedListener
    implements DocumentListener {
        private TextChangedListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            SeparatorsPanel.this.setPreview();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            SeparatorsPanel.this.setPreview();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            SeparatorsPanel.this.setPreview();
        }
    }
}

