/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.utilities;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ut {
    private Ut() {
    }

    public static byte[] arrayOfCharsToArrayOfBytes(char[] charsArray) {
        byte[] truncated;
        Charset defaultCharset = Charset.defaultCharset();
        CharsetEncoder encoder = defaultCharset.newEncoder();
        int maxArrayLen = (int)((float)charsArray.length * encoder.maxBytesPerChar());
        byte[] bytesArray = new byte[maxArrayLen];
        encoder.reset();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytesArray);
        CharBuffer charBuffer = CharBuffer.wrap(charsArray);
        try {
            encoder.encode(charBuffer, byteBuffer, true);
            encoder.flush(byteBuffer);
        }
        catch (Exception x) {
            // empty catch block
        }
        if (byteBuffer.position() == bytesArray.length) {
            truncated = bytesArray;
        } else {
            truncated = Arrays.copyOf(bytesArray, byteBuffer.position());
            Arrays.fill(bytesArray, (byte)0);
        }
        return truncated;
    }

    private static byte[] encode(CharsetEncoder ce, char[] charsArray) {
        int maxArrayLen = (int)((float)charsArray.length * ce.maxBytesPerChar());
        byte[] bytesArray = new byte[maxArrayLen];
        ce.reset();
        ByteBuffer bb = ByteBuffer.wrap(bytesArray);
        CharBuffer cb = CharBuffer.wrap(charsArray);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return Ut.truncateArrayToTheLastUsedByte(bytesArray, bb.position());
    }

    private static byte[] truncateArrayToTheLastUsedByte(byte[] transcodedArray, int usedBytes) {
        byte[] truncated;
        if (usedBytes == transcodedArray.length) {
            truncated = transcodedArray;
        } else {
            truncated = Arrays.copyOf(transcodedArray, usedBytes);
            Arrays.fill(transcodedArray, (byte)0);
        }
        return truncated;
    }

    public static String getClassNameForCurrentLAF() {
        UIManager.LookAndFeelInfo[] infoArray;
        String className = null;
        String currentLAF = UIManager.getLookAndFeel().getName();
        for (UIManager.LookAndFeelInfo info : infoArray = UIManager.getInstalledLookAndFeels()) {
            if (!currentLAF.equals(info.getName())) continue;
            className = info.getClassName();
        }
        return className;
    }

    public static void copyFile(String srcPath, String dstPath) throws FileNotFoundException, IOException {
        int len;
        File f1 = new File(srcPath);
        File f2 = new File(dstPath);
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static String rtrim(String s) {
        char c;
        StringBuilder sb = new StringBuilder(s);
        for (int i = sb.length() - 1; i >= 0 && Character.isWhitespace(c = sb.charAt(i)); --i) {
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    public static boolean changeLAF(String laf, Component c) {
        boolean success = true;
        try {
            UIManager.setLookAndFeel(laf);
            SwingUtilities.updateComponentTreeUI(c);
        }
        catch (Exception ex) {
            success = false;
        }
        return success;
    }

    public static void enableActions(boolean enabled, Action ... actions) {
        for (Action action : actions) {
            action.setEnabled(enabled);
        }
    }

    public static void enableComponents(boolean enabled, JComponent ... components) {
        for (JComponent component : components) {
            component.setEnabled(enabled);
        }
    }

    public static void setSelectedButtons(boolean selected, AbstractButton ... buttons) {
        for (AbstractButton button : buttons) {
            button.setSelected(selected);
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static File createAbsolutePath(File base, File target) {
        File absoluteTarget = target;
        if (!target.isAbsolute()) {
            String containingFolder = base.getParent();
            String remotePath = containingFolder + File.separator + target.getPath();
            absoluteTarget = new File(remotePath);
        }
        return absoluteTarget.getAbsoluteFile();
    }

    public static String onWindowsReplaceBackslashWithSlash(String path) {
        StringBuilder s = new StringBuilder(path);
        if (Ut.isWindowsSystem()) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) != '\\') continue;
                s.replace(i, i + 1, "/");
            }
        }
        return s.toString();
    }

    public static boolean isWindowsSystem() {
        String sys = System.getProperty("os.name");
        return sys.startsWith("Windows");
    }

    public static ArrayList<File> getParentDirectories(File f) {
        ArrayList<File> directories = new ArrayList<File>();
        File canonical = f.getAbsoluteFile();
        try {
            canonical = canonical.getCanonicalFile();
        }
        catch (IOException ex) {
            // empty catch block
        }
        for (File parent = canonical.getParentFile(); parent != null; parent = parent.getParentFile()) {
            directories.add(parent);
            if (Ut.isWindowsSystem() && parent.toString().endsWith(":\\")) break;
        }
        return directories;
    }

    public static File createRelativePath(File base, File target) {
        int targetIndex;
        File relativeFile = target;
        ArrayList<File> baseDirectories = Ut.getParentDirectories(base);
        ArrayList<File> targetDirectories = Ut.getParentDirectories(target);
        File commonBaseDir = null;
        int baseIndex = baseDirectories.size() - 1;
        for (targetIndex = targetDirectories.size() - 1; baseIndex >= 0 && targetIndex >= 0 && baseDirectories.get(baseIndex).equals(targetDirectories.get(targetIndex)); --baseIndex, --targetIndex) {
            commonBaseDir = baseDirectories.get(baseIndex);
        }
        if (commonBaseDir != null) {
            int upDirectories = baseIndex + 1;
            StringBuilder path = new StringBuilder();
            for (int j = 0; j < upDirectories; ++j) {
                path.append("..");
                path.append(File.separator);
            }
            while (targetIndex >= 0) {
                path.append(targetDirectories.get(targetIndex).getName());
                path.append(File.separator);
                --targetIndex;
            }
            path.append(target.getName());
            relativeFile = new File(path.toString());
        }
        return relativeFile;
    }
}

