/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import jcmdline.AbstractParameter;
import jcmdline.CmdLineException;
import jcmdline.Strings;

public class LongParam
extends AbstractParameter {
    public static final String DEFAULT_OPTION_LABEL = Strings.get("LongParam.defaultOptionLabel");
    protected long max = Long.MAX_VALUE;
    protected long min = Long.MIN_VALUE;

    public LongParam(String tag, String desc) {
        this(tag, desc, Long.MIN_VALUE, Long.MAX_VALUE, true, false, false);
    }

    public LongParam(String tag, String desc, boolean optional) {
        this(tag, desc, Long.MIN_VALUE, Long.MAX_VALUE, optional, false, false);
    }

    public LongParam(String tag, String desc, boolean optional, boolean multiValued) {
        this(tag, desc, Long.MIN_VALUE, Long.MAX_VALUE, optional, multiValued, false);
    }

    public LongParam(String tag, String desc, boolean optional, boolean multiValued, boolean hidden) {
        this(tag, desc, Long.MIN_VALUE, Long.MAX_VALUE, optional, multiValued, hidden);
    }

    public LongParam(String tag, String desc, long min, long max) {
        this(tag, desc, min, max, true, false, false);
    }

    public LongParam(String tag, String desc, long min, long max, boolean optional) {
        this(tag, desc, min, max, optional, false, false);
    }

    public LongParam(String tag, String desc, long min, long max, boolean optional, boolean multiValued) {
        this(tag, desc, min, max, optional, multiValued, false);
    }

    public LongParam(String tag, String desc, long min, long max, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setMin(min);
        this.setMax(max);
        this.setDesc(desc);
        this.setOptional(optional);
        this.setMultiValued(multiValued);
        this.setHidden(hidden);
        this.setOptionLabel(DEFAULT_OPTION_LABEL);
    }

    public LongParam(String tag, String desc, long[] acceptableValues) {
        this(tag, desc, acceptableValues, true, false, false);
    }

    public LongParam(String tag, String desc, long[] acceptableValues, boolean optional) {
        this(tag, desc, acceptableValues, optional, false, false);
    }

    public LongParam(String tag, String desc, long[] acceptableValues, boolean optional, boolean multiValued) {
        this(tag, desc, acceptableValues, optional, multiValued, false);
    }

    public LongParam(String tag, String desc, long[] acceptableValues, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setAcceptablesLongValues(acceptableValues);
        this.setDesc(desc);
        this.setOptional(optional);
        this.setMultiValued(multiValued);
        this.setHidden(hidden);
        this.setOptionLabel(DEFAULT_OPTION_LABEL);
    }

    public void setMin(long min) {
        if (min > this.max) {
            throw new IllegalArgumentException(Strings.get("LongParam.maxLessThanMin", new Object[]{this.tag}));
        }
        this.min = min;
    }

    public long longValue() {
        if (!this.set) {
            throw new RuntimeException(Strings.get("LongParam.valueNotSet", new Object[]{this.tag}));
        }
        return Long.parseLong((String)this.values.get(0));
    }

    public long[] longValues() {
        long[] vals = new long[this.values.size()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = Long.parseLong((String)this.values.get(i));
        }
        return vals;
    }

    public long getMin() {
        return this.min;
    }

    public void setMax(long max) {
        if (this.min > max) {
            throw new IllegalArgumentException(Strings.get("LongParam.maxLessThanMin", new Object[]{this.tag}));
        }
        this.max = max;
    }

    public long getMax() {
        return this.max;
    }

    public void setAcceptablesLongValues(long[] longValues) {
        String[] sValues = new String[longValues.length];
        for (int i = 0; i < longValues.length; ++i) {
            sValues[i] = Long.toString(longValues[i]);
        }
        this.setAcceptableValues(sValues);
    }

    public long[] getAcceptableLongValues() {
        String[] sValues = this.getAcceptableValues();
        long[] longValues = new long[sValues.length];
        for (int i = 0; i < sValues.length; ++i) {
            longValues[i] = Long.parseLong(sValues[i]);
        }
        return longValues;
    }

    public void validateValue(String val) throws CmdLineException {
        int offset = 0;
        while (val.startsWith("0", offset)) {
            ++offset;
        }
        super.validateValue(val.substring(offset));
        CmdLineException exception = new CmdLineException(Strings.get("LongParam.validValues", new Object[]{this.tag, new Long(this.min), new Long(this.max)}));
        long longVal = 0L;
        try {
            longVal = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw exception;
        }
        if (longVal < this.min || longVal > this.max) {
            throw exception;
        }
    }
}

