/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.functor.IArgs;
import java.util.HashMap;
import java.util.Map;

public class EntityResolver
extends ContainerResolver {
    private static Map<String, String> entities = new HashMap<String, String>();

    static {
        entities.put("amp", "&");
        entities.put("gt", ">");
        entities.put("lt", "<");
        entities.put("copy", "\u00a9");
        entities.put("trade", "\u2122");
        entities.put("cr", "\r");
        entities.put("lf", "\n");
        entities.put("quot", "\"");
        entities.put("squot", "'");
        entities.put("slash", "/");
        entities.put("backslash", "\\");
        entities.put("nl", System.getProperty("line.separator"));
    }

    @Override
    protected Object basicEvaluate(String string, IArgs iArgs) throws EvaluationException {
        try {
            if (string.startsWith("x")) {
                String string2 = string.substring(1);
                int n = Integer.parseInt(string2, 16);
                return new String(Character.toChars(n));
            }
            if (string.startsWith("o")) {
                String string3 = string.substring(1);
                int n = Integer.parseInt(string3, 8);
                return new String(Character.toChars(n));
            }
            int n = Integer.parseInt(string);
            return new String(Character.toChars(n));
        }
        catch (Exception exception) {
            return entities.get(string);
        }
    }
}

