/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.hex;

import de.intarsys.tools.hex.HexRow;
import de.intarsys.tools.hex.HexTools;

public class HexData {
    private byte[] bytes;
    private int length;
    private int offset;
    private int rowWidth = HexRow.DEFAULT_LENGTH;

    public HexData(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public HexData(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.bytes = byArray2;
        this.offset = 0;
        this.length = n2;
    }

    protected byte[] basicGetBytes() {
        return this.bytes;
    }

    protected byte basicGetValue(int n) {
        return this.bytes[n];
    }

    protected void basicSetValue(int n, byte by) {
        if (n >= this.offset + this.length) {
            int n2 = n - this.offset + 1;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.bytes, this.offset, byArray, 0, this.length);
            this.bytes = byArray;
            this.length = n2;
            this.offset = 0;
        }
        this.bytes[n] = by;
    }

    public byte getCellValue(int n, int n2) {
        return this.getRow(n).getCellValue(n2);
    }

    public String getCellValueAsString(int n, int n2) {
        return this.getRow(n).getCellValueAsString(n2);
    }

    public HexRow getRow(int n) {
        return new HexRow(this, this.offset + n * this.rowWidth, this.rowWidth);
    }

    public int getRowCount() {
        return this.length / this.rowWidth + 1;
    }

    public HexRow[] getRows() {
        int n = this.getRowCount();
        HexRow[] hexRowArray = new HexRow[n];
        int n2 = 0;
        while (n2 < n) {
            hexRowArray[n2] = this.getRow(n2);
            ++n2;
        }
        return hexRowArray;
    }

    public byte getValue(int n) {
        return this.basicGetValue(this.offset + n);
    }

    public String getValueAsString(int n) {
        return new String(HexTools.ByteToHex[this.getValue(n)]);
    }

    public void insertCellValue(int n, int n2, byte by) {
        int n3 = n * this.rowWidth + n2;
        int n4 = this.length + 1;
        byte[] byArray = new byte[n4];
        System.arraycopy(this.bytes, this.offset, byArray, 0, n3);
        byArray[n3] = by;
        System.arraycopy(this.bytes, this.offset + n3, byArray, n3 + 1, this.length - n3);
        this.bytes = byArray;
        this.length = n4;
        this.offset = 0;
    }

    public int length() {
        return this.bytes.length;
    }

    public void removeCellValue(int n, int n2) {
        int n3 = n * this.rowWidth + n2;
        int n4 = this.length - 1;
        byte[] byArray = new byte[n4];
        System.arraycopy(this.bytes, this.offset, byArray, 0, n3);
        System.arraycopy(this.bytes, this.offset + n3 + 1, byArray, n3, this.length - n3 - 1);
        this.bytes = byArray;
        this.length = n4;
        this.offset = 0;
    }

    public void setCellValue(int n, int n2, byte by) {
        this.getRow(n).setCellValue(n2, by);
    }

    public void setCellValue(int n, int n2, String string) {
        this.getRow(n).setCellValue(n2, string);
    }

    public void setValue(int n, byte by) {
        this.basicSetValue(this.offset + n, by);
    }

    public void setValue(int n, String string) {
        this.basicSetValue(this.offset + n, (byte)HexTools.hexStringToInt(string));
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, byArray, 0, this.length);
        return byArray;
    }
}

