/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.PageRotation;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.RotateParsedCommand;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.EncryptException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.PdfUtility;
import org.pdfsam.console.utils.perfix.PrefixParser;

public class RotateCmdExecutor
extends AbstractCmdExecutor {
    private static final Logger LOG = Logger.getLogger(RotateCmdExecutor.class.getPackage().getName());
    private PdfReader pdfReader = null;
    private PdfStamper pdfStamper = null;

    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        if (parsedCommand != null && parsedCommand instanceof RotateParsedCommand) {
            RotateParsedCommand inputCommand = (RotateParsedCommand)parsedCommand;
            this.setPercentageOfWorkDone(0);
            try {
                PdfFile[] fileList = inputCommand.getInputFileList();
                for (int i = 0; i < fileList.length; ++i) {
                    try {
                        int rotationDegrees;
                        PdfDictionary dictionary;
                        PrefixParser prefixParser = new PrefixParser(inputCommand.getOutputFilesPrefix(), fileList[i].getFile().getName());
                        File tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                        LOG.debug("Opening " + fileList[i].getFile().getAbsolutePath());
                        this.pdfReader = PdfUtility.fullReaderFor(fileList[i]);
                        this.pdfReader.removeUnusedObjects();
                        this.pdfReader.consolidateNamedDestinations();
                        int pdfNumberOfPages = this.pdfReader.getNumberOfPages();
                        PageRotation rotation = inputCommand.getRotation();
                        if (rotation.getType() == 3) {
                            int pageRotation = rotation.getDegrees();
                            LOG.debug("Applying rotation of " + pageRotation + " for all pages");
                            for (int j = 1; j <= pdfNumberOfPages; ++j) {
                                dictionary = this.pdfReader.getPageN(j);
                                rotationDegrees = (pageRotation + this.pdfReader.getPageRotation(j)) % 360;
                                dictionary.put(PdfName.ROTATE, (PdfObject)new PdfNumber(rotationDegrees));
                            }
                        } else if (rotation.getType() == 1) {
                            int pageRotation = rotation.getDegrees();
                            LOG.debug("Applying rotation of " + pageRotation + " for odd pages");
                            for (int j = 1; j <= pdfNumberOfPages; j += 2) {
                                dictionary = this.pdfReader.getPageN(j);
                                rotationDegrees = (pageRotation + this.pdfReader.getPageRotation(j)) % 360;
                                dictionary.put(PdfName.ROTATE, (PdfObject)new PdfNumber(rotationDegrees));
                            }
                        } else if (rotation.getType() == 2) {
                            int pageRotation = rotation.getDegrees();
                            LOG.debug("Applying rotation of " + pageRotation + " for even pages");
                            for (int j = 2; j <= pdfNumberOfPages; j += 2) {
                                dictionary = this.pdfReader.getPageN(j);
                                rotationDegrees = (pageRotation + this.pdfReader.getPageRotation(j)) % 360;
                                dictionary.put(PdfName.ROTATE, (PdfObject)new PdfNumber(rotationDegrees));
                            }
                        } else {
                            LOG.warn("Unable to find the rotation type. " + rotation);
                        }
                        LOG.debug("Creating a new document.");
                        Character pdfVersion = inputCommand.getOutputPdfVersion();
                        this.pdfStamper = pdfVersion != null ? new PdfStamper(this.pdfReader, (OutputStream)new FileOutputStream(tmpFile), inputCommand.getOutputPdfVersion().charValue()) : new PdfStamper(this.pdfReader, (OutputStream)new FileOutputStream(tmpFile), this.pdfReader.getPdfVersion());
                        HashMap meta = this.pdfReader.getInfo();
                        meta.put("Creator", "pdfsam-console (Ver. 2.4.3e)");
                        this.setCompressionSettingOnStamper(inputCommand, this.pdfStamper);
                        this.pdfStamper.setMoreInfo(meta);
                        this.pdfStamper.close();
                        this.pdfReader.close();
                        File outFile = new File(inputCommand.getOutputFile(), prefixParser.generateFileName());
                        FileUtility.renameTemporaryFile(tmpFile, outFile, inputCommand.isOverwrite());
                        LOG.debug("Rotated file " + outFile.getCanonicalPath() + " created.");
                        this.setPercentageOfWorkDone((i + 1) * 1000 / fileList.length);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Error rotating file " + fileList[i].getFile().getName(), e);
                    }
                }
                LOG.info("Pdf files rotated in " + inputCommand.getOutputFile().getAbsolutePath() + ".");
            }
            catch (Exception e) {
                throw new EncryptException(e);
            }
            finally {
                this.setWorkCompleted();
            }
        } else {
            throw new ConsoleException(5);
        }
    }

    public void clean() {
        this.closePdfReader(this.pdfReader);
        this.closePdfStamper(this.pdfStamper);
    }
}

