/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.SetViewerParsedCommand;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.SetViewerException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.PdfUtility;
import org.pdfsam.console.utils.perfix.PrefixParser;

public class SetViewerCmdExecutor
extends AbstractCmdExecutor {
    private static final Logger LOG = Logger.getLogger(SetViewerCmdExecutor.class.getPackage().getName());
    private PdfReader pdfReader = null;
    private PdfStamper pdfStamper = null;

    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        if (parsedCommand != null && parsedCommand instanceof SetViewerParsedCommand) {
            SetViewerParsedCommand inputCommand = (SetViewerParsedCommand)parsedCommand;
            this.setPercentageOfWorkDone(0);
            try {
                PdfFile[] fileList = this.arraysConcat(inputCommand.getInputFileList(), this.getPdfFiles(inputCommand.getInputDirectory()));
                if (fileList == null || fileList.length <= 0) {
                    throw new SetViewerException(1);
                }
                for (int i = 0; i < fileList.length; ++i) {
                    try {
                        PrefixParser prefixParser = new PrefixParser(inputCommand.getOutputFilesPrefix(), fileList[i].getFile().getName());
                        File tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                        this.pdfReader = PdfUtility.readerFor(fileList[i]);
                        this.pdfReader.removeUnusedObjects();
                        this.pdfReader.consolidateNamedDestinations();
                        LOG.debug("Creating a new document.");
                        Character pdfVersion = inputCommand.getOutputPdfVersion();
                        this.pdfStamper = pdfVersion != null ? new PdfStamper(this.pdfReader, (OutputStream)new FileOutputStream(tmpFile), inputCommand.getOutputPdfVersion().charValue()) : new PdfStamper(this.pdfReader, (OutputStream)new FileOutputStream(tmpFile), this.pdfReader.getPdfVersion());
                        HashMap meta = this.pdfReader.getInfo();
                        meta.put("Creator", "pdfsam-console (Ver. 2.4.3e)");
                        this.setCompressionSettingOnStamper(inputCommand, this.pdfStamper);
                        this.pdfStamper.setMoreInfo(meta);
                        this.pdfStamper.setViewerPreferences(inputCommand.getDirection() | inputCommand.getLayout() | inputCommand.getMode() | inputCommand.getNfsmode() | this.getVewerOptions(inputCommand));
                        this.pdfStamper.close();
                        this.pdfReader.close();
                        File outFile = new File(inputCommand.getOutputFile(), prefixParser.generateFileName());
                        FileUtility.renameTemporaryFile(tmpFile, outFile, inputCommand.isOverwrite());
                        LOG.debug("File " + outFile.getCanonicalPath() + " created.");
                        this.setPercentageOfWorkDone((i + 1) * 1000 / fileList.length);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Error setting options for file " + fileList[i].getFile().getName(), e);
                    }
                }
                LOG.info("Viewer options set. Pdf files created in " + inputCommand.getOutputFile().getAbsolutePath() + ".");
            }
            catch (Exception e) {
                throw new SetViewerException(e);
            }
            finally {
                this.setWorkCompleted();
            }
        } else {
            throw new ConsoleException(5);
        }
    }

    private int getVewerOptions(SetViewerParsedCommand parsedCommand) {
        int retVal = 0;
        if (parsedCommand.isCenterWindow()) {
            retVal |= 0x10000;
        }
        if (parsedCommand.isDisplayDocTitle()) {
            retVal |= 0x20000;
        }
        if (parsedCommand.isFitWindow()) {
            retVal |= 0x8000;
        }
        if (parsedCommand.isHideMenu()) {
            retVal |= 0x2000;
        }
        if (parsedCommand.isHideToolBar()) {
            retVal |= 0x1000;
        }
        if (parsedCommand.isHideWindowUI()) {
            retVal |= 0x4000;
        }
        if (parsedCommand.isNoPrintScaling()) {
            retVal |= 0x1000000;
        }
        return retVal;
    }

    public void clean() {
        this.closePdfReader(this.pdfReader);
        this.closePdfStamper(this.pdfStamper);
    }
}

