/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.thumbnails.creators;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.PasswordProvider;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.thumbnails.JPodRenderer;
import org.pdfsam.guiclient.business.thumbnails.callables.JPodCreatorCloser;
import org.pdfsam.guiclient.business.thumbnails.callables.JPodThmbnailCallable;
import org.pdfsam.guiclient.business.thumbnails.creators.AbstractThumbnailCreator;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.DocumentInfo;
import org.pdfsam.guiclient.dto.DocumentPage;
import org.pdfsam.guiclient.dto.VisualPageListItem;
import org.pdfsam.guiclient.exceptions.ThumbnailCreationException;
import org.pdfsam.guiclient.utils.DialogUtility;
import org.pdfsam.guiclient.utils.ImageUtility;
import org.pdfsam.i18n.GettextResource;

public class JPodThumbnailCreator
extends AbstractThumbnailCreator {
    public static final int JPOD_RESOLUTION = 72;
    private static final String JPOD_CREATOR_NAME = "Itarsys JPodRenderer";
    private static final Logger log = Logger.getLogger((String)JPodThumbnailCreator.class.getPackage().getName());
    private PDDocument pdfDoc = null;
    private PDPageTree pageTree = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BufferedImage getPageImage(File inputFile, String password, int page, int rotation) throws ThumbnailCreationException {
        BufferedImage retVal = null;
        IGraphicsContext graphics = null;
        PDDocument pdfDoc = null;
        if (inputFile == null || !inputFile.exists() || !inputFile.isFile()) throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Input file doesn't exists or is a directory"));
        try {
            int totalRotation;
            pdfDoc = this.openDoc(inputFile, password);
            PDPage pdPage = pdfDoc.getPageTree().getPageAt(page - 1);
            Rectangle2D rect = pdPage.getCropBox().toNormalizedRectangle();
            retVal = new BufferedImage((int)rect.getWidth(), (int)rect.getHeight(), 1);
            Graphics2D g2 = (Graphics2D)retVal.getGraphics();
            graphics = new CwtAwtGraphicsContext(g2);
            AffineTransform imgTransform = graphics.getTransform();
            imgTransform.scale(1.0, -1.0);
            imgTransform.translate(-rect.getMinX(), -rect.getMaxY());
            graphics.setTransform(imgTransform);
            graphics.setBackgroundColor(Color.WHITE);
            graphics.fill(rect);
            CSContent content = pdPage.getContentStream();
            if (content != null) {
                JPodRenderer renderer = new JPodRenderer(null, graphics);
                renderer.process(content, pdPage.getResources());
            }
            if (pdfDoc != null) {
                pdfDoc.close();
            }
            if ((totalRotation = (rotation + pdPage.getRotate()) % 360) == 0) return retVal;
            BufferedImage rotated = ImageUtility.rotateImage((Image)retVal, (int)totalRotation);
            retVal = new BufferedImage(((Image)rotated).getWidth(null), ((Image)rotated).getHeight(null), 1);
            Graphics g = retVal.getGraphics();
            g.drawImage(rotated, 0, 0, null);
            return retVal;
        }
        catch (Throwable t) {
            throw new ThumbnailCreationException(t);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    public BufferedImage getThumbnail(File inputFile, String password, int page, float resizePercentage) throws ThumbnailCreationException {
        BufferedImage retVal = null;
        BufferedImage tempImage = this.getPageImage(inputFile, password, page);
        try {
            retVal = ImageUtility.getScaledInstance((BufferedImage)tempImage, (int)Math.round((float)tempImage.getWidth(null) * resizePercentage), (int)Math.round((float)tempImage.getHeight(null) * resizePercentage));
        }
        catch (Exception e) {
            throw new ThumbnailCreationException((Throwable)e);
        }
        return retVal;
    }

    private PDDocument openDoc(File inputFile, String password) throws IOException, COSLoadException {
        PDDocument retVal = null;
        FileLocator locator = new FileLocator(inputFile);
        if (password != null) {
            HashMap options = new HashMap();
            final char[] pwd = password.toCharArray();
            PasswordProvider.setPasswordProvider(options, (IPasswordProvider)new IPasswordProvider(){

                public char[] getPassword() {
                    return pwd;
                }
            });
            retVal = PDDocument.createFromLocator((ILocator)locator, options);
        } else {
            retVal = PDDocument.createFromLocator((ILocator)locator);
        }
        return retVal;
    }

    public int getResolution() {
        return 72;
    }

    public String getCreatorName() {
        return JPOD_CREATOR_NAME;
    }

    public String getCreatorIdentifier() {
        return JPodThumbnailCreator.class.getName();
    }

    protected void finalizeThumbnailsCreation() throws ThumbnailCreationException {
        this.pageTree = null;
    }

    protected Callable<Boolean> getCloserTask() throws ThumbnailCreationException {
        JPodCreatorCloser retVal = null;
        if (this.pdfDoc != null) {
            retVal = new JPodCreatorCloser(this.pdfDoc);
        }
        return retVal;
    }

    protected DocumentInfo getDocumentInfo() throws ThumbnailCreationException {
        File inputFile = this.getInputFile();
        DocumentInfo documentInfo = new DocumentInfo();
        this.pageTree = this.pdfDoc.getPageTree();
        documentInfo.getDocumentMetaData().setCreator(this.pdfDoc.getCreator());
        documentInfo.setFileName(inputFile.getAbsolutePath());
        documentInfo.setPages(this.pageTree.getCount());
        documentInfo.getDocumentMetaData().setAuthor(this.pdfDoc.getAuthor());
        documentInfo.setPdfVersion(this.pdfDoc.cosGetDoc().stGetDoc().getDocType().getVersion());
        documentInfo.setEncrypted(this.pdfDoc.isEncrypted());
        documentInfo.getDocumentMetaData().setTitle(this.pdfDoc.getTitle());
        documentInfo.getDocumentMetaData().setProducer(this.pdfDoc.getProducer());
        return documentInfo;
    }

    protected Vector<VisualPageListItem> getDocumentModel(List<DocumentPage> template) throws ThumbnailCreationException {
        int pages = this.pageTree.getCount();
        File inputFile = this.getInputFile();
        Vector<VisualPageListItem> modelList = null;
        try {
            if (pages > 0 && inputFile != null) {
                modelList = new Vector<VisualPageListItem>(pages);
                if (template == null || template.size() <= 0) {
                    for (int i = 1; i <= pages; ++i) {
                        modelList.add(new VisualPageListItem(i, inputFile.getCanonicalPath(), this.getProvidedPassword()));
                    }
                } else {
                    for (DocumentPage page : template) {
                        if (page.getPageNumber() <= 0 || page.getPageNumber() > pages) continue;
                        VisualPageListItem currentItem = new VisualPageListItem(page.getPageNumber(), inputFile.getCanonicalPath(), this.getProvidedPassword());
                        currentItem.setDeleted(page.isDeleted());
                        currentItem.setRotation(page.getRotation());
                        modelList.add(currentItem);
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error opening pdf document") + " " + inputFile.getAbsolutePath(), (Throwable)ioe);
        }
        return modelList;
    }

    protected Collection<? extends Callable<Boolean>> getGenerationTasks(Vector<VisualPageListItem> modelList) throws ThumbnailCreationException {
        ArrayList<JPodThmbnailCallable> tasks = null;
        if (this.pageTree != null && modelList != null && modelList.size() > 0) {
            tasks = new ArrayList<JPodThmbnailCallable>(modelList.size());
            for (VisualPageListItem pageItem : modelList) {
                PDPage pdPage = this.pageTree.getPageAt(pageItem.getPageNumber() - 1);
                tasks.add(new JPodThmbnailCallable(pdPage, pageItem, this.getPanel(), this.getCurrentId()));
            }
        }
        return tasks;
    }

    protected void initThumbnailsCreation() throws ThumbnailCreationException {
        this.pdfDoc = null;
        this.pageTree = null;
    }

    protected boolean openInputDocument() throws ThumbnailCreationException {
        boolean retVal = false;
        String providedPwd = this.getProvidedPassword();
        File inputFile = this.getInputFile();
        if (inputFile != null) {
            if (inputFile.exists() && inputFile.isFile()) {
                try {
                    try {
                        this.pdfDoc = this.openDoc(inputFile, providedPwd);
                    }
                    catch (IOException ioe) {
                        if (ioe.getCause() instanceof COSSecurityException) {
                            providedPwd = DialogUtility.askForDocumentPasswordDialog((Component)this.getPanel(), (String)inputFile.getName());
                            if (providedPwd != null && providedPwd.length() > 0) {
                                this.setProvidedPassword(providedPwd);
                                this.pdfDoc = this.openDoc(inputFile, providedPwd);
                            }
                            throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Password not provided."));
                        }
                        throw new ThumbnailCreationException((Throwable)ioe);
                    }
                    if (this.pdfDoc != null) {
                        if (this.pdfDoc.isEncrypted() && (providedPwd == null || providedPwd.length() == 0)) {
                            providedPwd = DialogUtility.askForDocumentPasswordDialog((Component)this.getPanel(), (String)inputFile.getName());
                            this.setProvidedPassword(providedPwd);
                        }
                    } else {
                        throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to open the document."));
                    }
                    retVal = true;
                }
                catch (IOException ioe) {
                    throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error opening pdf document") + " " + inputFile.getAbsolutePath(), (Throwable)ioe);
                }
                catch (COSLoadException cle) {
                    throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error opening pdf document") + " " + inputFile.getAbsolutePath(), (Throwable)cle);
                }
                catch (OutOfMemoryError oom) {
                    throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Not enough memory to create thumbnails") + " " + inputFile.getAbsolutePath(), (Throwable)oom);
                }
            }
            log.error((Object)(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Input file doesn't exists or is a directory") + " (" + inputFile.getAbsolutePath() + ")"));
        }
        return retVal;
    }
}

