/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDFileSpecification;
import java.net.MalformedURLException;
import java.net.URL;

public class PDFileSpecificationURL
extends PDFileSpecification {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private URL url = null;

    public static PDFileSpecificationURL createNew(URL uRL) {
        PDFileSpecificationURL pDFileSpecificationURL = (PDFileSpecificationURL)META.createNew();
        pDFileSpecificationURL.setURL(uRL);
        return pDFileSpecificationURL;
    }

    protected PDFileSpecificationURL(COSObject cOSObject) {
        super(cOSObject);
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    protected void initializeFromCos() {
        super.initializeFromCos();
        this.setFileSystem(CN_FS_URL);
        COSString cOSString = this.cosGetField(DK_F).asString();
        if (cOSString != null) {
            try {
                this.setURL(new URL(cOSString.stringValue()));
            }
            catch (MalformedURLException malformedURLException) {
                this.cosGetObject().handleException(new COSRuntimeException("error parsing URL", malformedURLException));
            }
        }
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.setFileSystem((COSName)CN_FS_URL.copyShallow());
    }

    public void setURL(URL uRL) {
        this.url = uRL;
        if (uRL == null) {
            this.setFieldString(DK_F, null);
        } else {
            this.setFieldString(DK_F, this.url.toString());
        }
    }

    public static class MetaClass
    extends PDFileSpecification.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDFileSpecificationURL(cOSObject);
        }
    }
}

