/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.actions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.actions.AbstractImageAction;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.gui.components.JPreviewImage;
import org.pdfsam.guiclient.utils.filters.AbstractFileFilter;
import org.pdfsam.i18n.GettextResource;

public class SaveImageAction
extends AbstractImageAction {
    private static final long serialVersionUID = 136283111853869669L;
    private static final Logger LOG = Logger.getLogger(SaveImageAction.class.getPackage().getName());
    private JFileChooser fileChooser;
    private JFrame parent;

    public SaveImageAction(JPreviewImage previewImage, JFrame parent) {
        super(previewImage, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Save as"));
        this.setEnabled(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 128));
        this.putValue("ShortDescription", GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Save the image"));
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getPreviewImage() != null) {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(Configuration.getInstance().getDefaultWorkingDirectory());
                this.fileChooser.setAcceptAllFileFilterUsed(false);
                Set<String> types = this.unique(ImageIO.getWriterFileSuffixes());
                for (final String extension : types) {
                    this.fileChooser.addChoosableFileFilter(new AbstractFileFilter(){

                        @Override
                        public String getAcceptedExtension() {
                            return extension;
                        }

                        @Override
                        public String getDescription() {
                            return extension;
                        }
                    });
                }
            }
            if (this.fileChooser.showSaveDialog(this.parent) == 0) {
                try {
                    Image image;
                    File selectedFile = this.fileChooser.getSelectedFile();
                    String extension = this.getExtension(selectedFile);
                    if (extension == null || !this.accept(this.fileChooser.getChoosableFileFilters(), selectedFile)) {
                        extension = this.fileChooser.getFileFilter().getDescription();
                        selectedFile = new File(selectedFile.getAbsolutePath() + "." + extension);
                    }
                    if ((image = this.getPreviewImage().getImage()) instanceof RenderedImage) {
                        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix(extension);
                        if (writers.hasNext()) {
                            ImageWriter writer = writers.next();
                            writer.setOutput(ImageIO.createImageOutputStream(selectedFile));
                            writer.write((RenderedImage)((Object)image));
                        } else {
                            LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to save image"));
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to save image"), ex);
                }
            }
        }
    }

    private boolean accept(FileFilter[] filters, File selectedFile) {
        for (FileFilter filter : filters) {
            if (!filter.accept(selectedFile)) continue;
            return true;
        }
        return false;
    }

    private String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private Set<String> unique(String[] strings) {
        HashSet<String> set = new HashSet<String>();
        for (String current : strings) {
            set.add(current.toLowerCase());
        }
        return set;
    }
}

