/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business.loaders.callable;

import java.io.File;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.commons.business.loaders.callable.AddPdfDocument;
import org.pdfsam.guiclient.commons.panels.JPdfSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.utils.filters.PdfFilter;
import org.pdfsam.i18n.GettextResource;

public class ReloadPdfDocument
extends AddPdfDocument {
    private static final Logger LOG = Logger.getLogger(ReloadPdfDocument.class.getPackage().getName());
    private int index = 0;

    public ReloadPdfDocument(File inputFile, JPdfSelectionPanel panel, String password, String pageSelection, int index) {
        super(inputFile, panel, password, pageSelection);
        this.index = index;
    }

    @Override
    public Boolean call() {
        Boolean retVal = Boolean.FALSE;
        try {
            if (this.inputFile != null) {
                if (new PdfFilter(false).accept(this.inputFile)) {
                    this.wipText = GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please wait while reading") + " " + this.inputFile.getName() + " ...";
                    this.panel.addWipText(this.wipText);
                    this.panel.updateTableRow(this.index, this.getPdfSelectionTableItem(this.inputFile, this.password, this.pageSelection));
                    this.panel.removeWipText(this.wipText);
                    retVal = Boolean.TRUE;
                } else {
                    LOG.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Selected file is not a pdf document.") + " " + this.inputFile.getName());
                }
            }
        }
        catch (Throwable e) {
            LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), e);
        }
        return retVal;
    }
}

