/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.dto;

import java.io.File;
import java.io.Serializable;
import org.pdfsam.guiclient.dto.DocumentMetaData;
import org.pdfsam.guiclient.utils.PdfVersionUtility;

public class PdfSelectionTableItem
implements Serializable {
    private static final long serialVersionUID = 7190628784577648811L;
    private File inputFile;
    private String pagesNumber;
    private String pageSelection;
    private boolean encrypted;
    private boolean fullPermission;
    private String encryptionAlgorithm;
    private String permissions;
    private long fileSize = 0L;
    private DocumentMetaData documentMetaData = new DocumentMetaData();
    private String password;
    private char pdfVersion;
    private String pdfVersionDescription;
    private boolean loadedWithErrors = false;
    private boolean syntaxErrors = false;

    public PdfSelectionTableItem() {
        this(null, "0", "All", false, true, ' ');
    }

    public PdfSelectionTableItem(File inputFile, String pagesNumber, String pageSelection, boolean encrypted, boolean fullPermission, char pdfVersion, String password, boolean loadedWithErrors, boolean syntaxErrors) {
        this.inputFile = inputFile;
        this.pagesNumber = pagesNumber;
        this.pageSelection = pageSelection;
        this.encrypted = encrypted;
        this.pdfVersion = pdfVersion;
        this.pdfVersionDescription = PdfVersionUtility.getVersionDescription(pdfVersion);
        this.password = password;
        this.loadedWithErrors = loadedWithErrors;
        this.syntaxErrors = syntaxErrors;
        this.fullPermission = fullPermission;
    }

    public PdfSelectionTableItem(File inputFile, String pagesNumber, String pageSelection, boolean encrypted, boolean fullPermission, char pdfVersion, String password) {
        this(inputFile, pagesNumber, pageSelection, encrypted, fullPermission, pdfVersion, password, false, false);
    }

    public PdfSelectionTableItem(File inputFile, String pagesNumber, String pageSelection, boolean encrypted, boolean fullPermission, char pdfVersion) {
        this(inputFile, pagesNumber, pageSelection, encrypted, fullPermission, pdfVersion, null);
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public String getPagesNumber() {
        return this.pagesNumber;
    }

    public void setPagesNumber(String pagesNumber) {
        this.pagesNumber = pagesNumber;
    }

    public String getPageSelection() {
        return this.pageSelection;
    }

    public void setPageSelection(String pageSelection) {
        this.pageSelection = pageSelection;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public char getPdfVersion() {
        return this.pdfVersion;
    }

    public void setPdfVersion(char pdfVersion) {
        this.pdfVersion = pdfVersion;
        this.pdfVersionDescription = PdfVersionUtility.getVersionDescription(pdfVersion);
    }

    public boolean isLoadedWithErrors() {
        return this.loadedWithErrors;
    }

    public void setLoadedWithErrors(boolean loadedWithErrors) {
        this.loadedWithErrors = loadedWithErrors;
    }

    public String getPdfVersionDescription() {
        return this.pdfVersionDescription;
    }

    public boolean isSyntaxErrors() {
        return this.syntaxErrors;
    }

    public void setSyntaxErrors(boolean syntaxErrors) {
        this.syntaxErrors = syntaxErrors;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public DocumentMetaData getDocumentMetaData() {
        return this.documentMetaData;
    }

    public void setDocumentInfo(DocumentMetaData documentMetaData) {
        this.documentMetaData = documentMetaData;
    }

    public boolean isFullPermission() {
        return this.fullPermission;
    }

    public void setFullPermission(boolean fullPermission) {
        this.fullPermission = fullPermission;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.documentMetaData == null ? 0 : this.documentMetaData.hashCode());
        result = 31 * result + (this.encrypted ? 1231 : 1237);
        result = 31 * result + (this.encryptionAlgorithm == null ? 0 : this.encryptionAlgorithm.hashCode());
        result = 31 * result + (int)(this.fileSize ^ this.fileSize >>> 32);
        result = 31 * result + (this.fullPermission ? 1231 : 1237);
        result = 31 * result + (this.inputFile == null ? 0 : this.inputFile.hashCode());
        result = 31 * result + (this.loadedWithErrors ? 1231 : 1237);
        result = 31 * result + (this.pageSelection == null ? 0 : this.pageSelection.hashCode());
        result = 31 * result + (this.pagesNumber == null ? 0 : this.pagesNumber.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + this.pdfVersion;
        result = 31 * result + (this.pdfVersionDescription == null ? 0 : this.pdfVersionDescription.hashCode());
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        result = 31 * result + (this.syntaxErrors ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdfSelectionTableItem other = (PdfSelectionTableItem)obj;
        if (this.documentMetaData == null ? other.documentMetaData != null : !this.documentMetaData.equals(other.documentMetaData)) {
            return false;
        }
        if (this.encrypted != other.encrypted) {
            return false;
        }
        if (this.encryptionAlgorithm == null ? other.encryptionAlgorithm != null : !this.encryptionAlgorithm.equals(other.encryptionAlgorithm)) {
            return false;
        }
        if (this.fileSize != other.fileSize) {
            return false;
        }
        if (this.fullPermission != other.fullPermission) {
            return false;
        }
        if (this.inputFile == null ? other.inputFile != null : !this.inputFile.equals(other.inputFile)) {
            return false;
        }
        if (this.loadedWithErrors != other.loadedWithErrors) {
            return false;
        }
        if (this.pageSelection == null ? other.pageSelection != null : !this.pageSelection.equals(other.pageSelection)) {
            return false;
        }
        if (this.pagesNumber == null ? other.pagesNumber != null : !this.pagesNumber.equals(other.pagesNumber)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.pdfVersion != other.pdfVersion) {
            return false;
        }
        if (this.pdfVersionDescription == null ? other.pdfVersionDescription != null : !this.pdfVersionDescription.equals(other.pdfVersionDescription)) {
            return false;
        }
        if (this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions)) {
            return false;
        }
        return this.syntaxErrors == other.syntaxErrors;
    }
}

