/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.updates;

import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.GuiClient;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.updates.checkers.HttpUpdateChecker;
import org.pdfsam.guiclient.updates.checkers.UpdateChecker;
import org.pdfsam.i18n.GettextResource;

public class UpdateManager {
    private static Logger LOG = Logger.getLogger(UpdateManager.class.getPackage().getName());
    private UpdateChecker checker = null;
    private boolean checked = false;
    private String availableVersion = "";

    public UpdateManager(String httpUrl) {
        this.checker = new HttpUpdateChecker(httpUrl);
    }

    public boolean isNewVersionAvailable() {
        return StringUtils.isNotBlank((String)this.availableVersion) && !StringUtils.equalsIgnoreCase((String)GuiClient.getVersion(), (String)this.availableVersion);
    }

    public String getAvailableVersion() {
        return this.availableVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForNewVersion(boolean forceRecheck) {
        if (forceRecheck) {
            this.resetStatus();
        }
        if (!this.checked) {
            LOG.debug(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Checking for a new version available."));
            try {
                this.availableVersion = this.checker.getLatestVersion();
            }
            catch (Exception e) {
                LOG.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error checking for a new version available."), e);
            }
            finally {
                this.checked = true;
            }
        }
    }

    private void resetStatus() {
        this.checked = false;
        this.availableVersion = "";
    }

    public void checkForNewVersion() {
        this.checkForNewVersion(true);
    }
}

