/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.DocumentPage;
import org.pdfsam.guiclient.dto.Rotation;
import org.pdfsam.i18n.GettextResource;

public final class XmlUtility {
    private static final Logger LOG = Logger.getLogger(XmlUtility.class.getPackage().getName());

    private XmlUtility() {
    }

    public static DocumentPage getDocumentPage(Node pageNode) {
        DocumentPage retVal = null;
        try {
            if (pageNode != null) {
                Node rotationNode;
                Node numberNode;
                retVal = new DocumentPage();
                Node deletedNode = pageNode.selectSingleNode("@deleted");
                if (deletedNode != null && deletedNode.getText().length() > 0) {
                    retVal.setDeleted(Boolean.valueOf(deletedNode.getText()));
                }
                if ((numberNode = pageNode.selectSingleNode("@number")) != null && numberNode.getText().length() > 0) {
                    retVal.setPageNumber(Integer.valueOf(numberNode.getText()));
                }
                if ((rotationNode = pageNode.selectSingleNode("@rotation")) != null && rotationNode.getText().length() > 0) {
                    retVal.setRotation(Rotation.getRotation(Integer.valueOf(rotationNode.getText())));
                }
            }
        }
        catch (Exception e) {
            LOG.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error retrieving page saved informations"), e);
        }
        return retVal;
    }

    public static void writeXmlFile(Document domDoc, File outFile) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile));
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        XMLWriter xmlFileWriter = new XMLWriter(bos, format);
        xmlFileWriter.write(domDoc);
        xmlFileWriter.flush();
        xmlFileWriter.close();
    }

    public static String getXmlValue(Document document, String xpath) {
        String retVal = "";
        Node node = document.selectSingleNode(xpath);
        if (node != null) {
            retVal = node.getText().trim();
        }
        return retVal;
    }

    public static Set<String> getXmlValues(Document document, String xpath) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        for (Node node : document.selectNodes(xpath)) {
            if (!StringUtils.isNotBlank((String)node.getText())) continue;
            retVal.add(node.getText().trim());
        }
        return retVal;
    }

    public static Document parseXmlFile(String fullPath) throws DocumentException {
        return XmlUtility.parseXmlFile(new File(fullPath));
    }

    public static Document parseXmlFile(File inputFile) throws DocumentException {
        Document document = null;
        if (!inputFile.isFile()) {
            throw new DocumentException("Unable to read " + inputFile + ".");
        }
        SAXReader reader = new SAXReader();
        document = reader.read(inputFile);
        return document;
    }

    public static Document parseXmlFile(URL url) throws DocumentException {
        Document document = null;
        SAXReader reader = new SAXReader();
        document = reader.read(url);
        return document;
    }

    public static Element processXPath(Element rootElement, String xpath, String attributeValue) {
        String[] values = xpath.split("@");
        if (values.length == 2) {
            return XmlUtility.addXmlNodeAndAttribute(rootElement, values[0], values[1], attributeValue);
        }
        return XmlUtility.addXmlNodeAndAttribute(rootElement, values[0], null, null);
    }

    public static Element addXmlNodeAndAttribute(Element rootElement, String nodeXPath, String attributeName, String attributeValue) {
        String[] nodes = nodeXPath.split("/");
        Element currentElement = rootElement;
        for (String node : nodes) {
            if (!StringUtils.isNotBlank((String)node)) continue;
            Element tmpElement = (Element)currentElement.selectSingleNode(node);
            currentElement = tmpElement != null ? tmpElement : currentElement.addElement(node);
        }
        if (attributeName != null && attributeValue != null) {
            currentElement.addAttribute(attributeName, attributeValue);
        }
        return currentElement;
    }

    public static void addXmlNodesAndAttribute(Element parentElement, String nodeName, String attributeName, Collection<String> attributeValues) {
        for (String attributeValue : attributeValues) {
            if (!StringUtils.isNotBlank((String)attributeValue)) continue;
            Element currentElement = parentElement.addElement(nodeName);
            currentElement.addAttribute(attributeName, attributeValue);
        }
    }
}

