/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableComponentModel
extends AbstractTableModel {
    List<Object[]> rows = new ArrayList<Object[]>();
    private final String[] columnNames;
    private final Class[] columnClasses;
    private RowListener listener;

    public TableComponentModel(String[] stringArray, Class[] classArray) {
        this.columnNames = stringArray;
        if (classArray == null) {
            classArray = new Class[stringArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                classArray[i] = Object.class;
            }
        }
        this.columnClasses = classArray;
        if (classArray.length != stringArray.length) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.rows.get(n)[n2];
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.columnClasses[n];
    }

    public void clear() {
        if (this.getRowCount() > 0) {
            this.fireTableRowsDeleted(0, this.getRowCount() - 1);
        }
        this.rows.clear();
    }

    public void addRow(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        this.rows.add(objectArray2);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void deleteRow(int n) {
        this.fireTableRowsDeleted(n, n);
        this.rows.remove(n);
    }

    public void moveRow(int n, int n2) {
        this.fireTableRowsDeleted(n, n);
        Object[] objectArray = this.rows.remove(n);
        this.rows.add(n + n2, objectArray);
        this.fireTableRowsInserted(n + n2, n + n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.rows.get((int)n)[n2] = object;
        if (this.listener != null) {
            this.listener.rowChanged(n, n2);
        }
    }

    public Object[] getRow(int n) {
        return this.rows.get(n);
    }

    public void setRowListener(RowListener rowListener) {
        this.listener = rowListener;
    }

    public static interface RowListener {
        public void rowChanged(int var1, int var2);
    }
}

